/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.redstone;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.block.redstone.RemoteComparatorBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class RemoteComparatorBlockEntity
extends BlockEntity {
    private int tickCycle;

    public RemoteComparatorBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.REMOTE_COMPARATOR.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, RemoteComparatorBlockEntity blockEntity) {
        if (blockEntity.tickCycle >= (Integer)MinestuckConfig.SERVER.puzzleBlockTickRate.get()) {
            blockEntity.sendUpdate();
            blockEntity.tickCycle = 0;
        }
        ++blockEntity.tickCycle;
    }

    private void sendUpdate() {
        if (this.level != null) {
            boolean shouldBePowered = RemoteComparatorBlock.isMatch(this.level, this.worldPosition);
            if ((Boolean)this.getBlockState().getValue((Property)RemoteComparatorBlock.POWERED) != shouldBePowered) {
                this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)RemoteComparatorBlock.POWERED, (Comparable)Boolean.valueOf(shouldBePowered)));
            }
        }
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.tickCycle = compound.getInt("tickCycle");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("tickCycle", this.tickCycle);
    }
}

