/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.redstone;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.block.redstone.RemoteObserverBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.entity.underling.UnderlingEntity;
import com.mraof.minestuck.network.block.RemoteObserverSettingsPacket;
import com.mraof.minestuck.util.MSTags;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class RemoteObserverBlockEntity
extends BlockEntity {
    private int tickCycle;
    @Nonnull
    private ActiveType activeType = ActiveType.IS_LIVING_ENTITY_PRESENT;
    private int observingRange = 16;
    private EntityType<?> currentEntityType;

    public RemoteObserverBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.REMOTE_OBSERVER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, RemoteObserverBlockEntity blockEntity) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if ((double)blockEntity.tickCycle >= (double)((Integer)MinestuckConfig.SERVER.puzzleBlockTickRate.get()).intValue() * 1.667) {
            blockEntity.checkRelaventType();
            blockEntity.tickCycle = 0;
        }
        ++blockEntity.tickCycle;
    }

    private void checkRelaventType() {
        boolean shouldBePowered = false;
        AABB axisalignedbb = new AABB(this.getBlockPos()).inflate((double)this.observingRange);
        List entityList = this.level.getEntities(null, axisalignedbb);
        if (!entityList.isEmpty()) {
            for (Entity entity : entityList) {
                if (!this.activeType.typeConditions.test(entity, this)) continue;
                shouldBePowered = true;
            }
        }
        if ((Boolean)this.getBlockState().getValue((Property)RemoteObserverBlock.POWERED) != shouldBePowered) {
            this.level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)RemoteObserverBlock.POWERED, (Comparable)Boolean.valueOf(shouldBePowered)));
        } else {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        }
    }

    public EntityType<?> getCurrentEntityType() {
        if (this.currentEntityType != null) {
            return this.currentEntityType;
        }
        return EntityType.PLAYER;
    }

    public static boolean entityCanBeObserved(EntityType<?> currentEntityType) {
        return !currentEntityType.is(MSTags.EntityTypes.REMOTE_OBSERVER_BLACKLIST);
    }

    public int getObservingRange() {
        return this.observingRange;
    }

    public void handleSettingsPacket(RemoteObserverSettingsPacket packet) {
        this.activeType = Objects.requireNonNull(packet.activeType());
        if (packet.entityType().isPresent()) {
            this.currentEntityType = packet.entityType().get();
        }
        this.observingRange = packet.observingRange();
        this.setChanged();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().blockChanged(this.getBlockPos());
        }
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.tickCycle = compound.getInt("tickCycle");
        this.activeType = ActiveType.fromInt(compound.getInt("activeTypeOrdinal"));
        this.observingRange = compound.contains("observingRange") ? compound.getInt("observingRange") : 15;
        Optional attemptedEntityType = EntityType.byString((String)compound.getString("currentEntityType"));
        attemptedEntityType.ifPresent(entityType -> {
            this.currentEntityType = entityType;
        });
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("tickCycle", this.tickCycle);
        compound.putInt("activeTypeOrdinal", this.getActiveType().ordinal());
        compound.putInt("observingRange", this.observingRange);
        compound.putString("currentEntityType", EntityType.getKey(this.getCurrentEntityType()).toString());
    }

    public ActiveType getActiveType() {
        return this.activeType;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public static enum ActiveType {
        IS_CROUCHING((entity, observer) -> entity.isCrouching()),
        CURRENT_ENTITY_PRESENT((entity, observer) -> entity.getType() == observer.getCurrentEntityType()),
        IS_LIVING_ENTITY_PRESENT((entity, observer) -> entity instanceof LivingEntity),
        IS_UNDERLING_PRESENT((entity, observer) -> entity instanceof UnderlingEntity),
        IS_ENTITY_BURNING((entity, observer) -> entity.isOnFire()),
        IS_ENTITY_INVISIBLE((entity, observer) -> entity.isInvisible()),
        IS_ELYTRA_FLYING((entity, observer) -> entity instanceof LivingEntity && ((LivingEntity)entity).isFallFlying()),
        IS_ENTITY_UNDER_WATER((entity, observer) -> entity.isUnderWater()),
        IS_ENTITY_WET((entity, observer) -> entity.isInWaterRainOrBubble()),
        IS_ENTITY_ON_GROUND((entity, observer) -> entity.onGround()),
        IS_SPRINTING((entity, observer) -> entity.isSprinting());

        private final BiPredicate<Entity, RemoteObserverBlockEntity> typeConditions;

        private ActiveType(BiPredicate<Entity, RemoteObserverBlockEntity> typeConditions) {
            this.typeConditions = typeConditions;
        }

        public static ActiveType fromInt(int ordinal) {
            if (0 <= ordinal && ordinal < ActiveType.values().length) {
                return ActiveType.values()[ordinal];
            }
            throw new IllegalArgumentException("Invalid ordinal of " + ordinal + " for remote observer active type!");
        }

        public String getNameNoSpaces() {
            return this.name().replace('_', ' ');
        }
    }
}

