/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.redstone;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.block.redstone.StatStorerBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.event.AlchemyEvent;
import com.mraof.minestuck.event.GristDropsEvent;
import com.mraof.minestuck.network.block.StatStorerSettingsPacket;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityStruckByLightningEvent;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingHealEvent;
import net.neoforged.neoforge.event.level.BlockGrowFeatureEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME)
public class StatStorerBlockEntity
extends BlockEntity {
    private float damageStored;
    private int deathsStored;
    private int saplingsGrownStored;
    private float healthRecoveredStored;
    private int lightningStruckStored;
    private int entitiesBredStored;
    private int explosionsStored;
    private int alchemyActivatedStored;
    private int gristDropsStored;
    private ActiveType activeType;
    private int divideValueBy;
    private int tickCycle;

    public StatStorerBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.STAT_STORER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, StatStorerBlockEntity blockEntity) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (blockEntity.tickCycle % (Integer)MinestuckConfig.SERVER.puzzleBlockTickRate.get() == 1) {
            if (!level.isClientSide) {
                int moddedStoredValue = Math.min(15, blockEntity.getActiveStoredStatValue() / blockEntity.getDivideValueBy());
                if ((Integer)state.getValue((Property)StatStorerBlock.POWER) != moddedStoredValue) {
                    level.setBlock(pos, (BlockState)state.setValue((Property)StatStorerBlock.POWER, (Comparable)Integer.valueOf(moddedStoredValue)), 3);
                }
            }
            if (blockEntity.tickCycle >= 5000) {
                blockEntity.tickCycle = 0;
            }
        }
        ++blockEntity.tickCycle;
    }

    public void handleSettingsPacket(StatStorerSettingsPacket packet) {
        this.activeType = packet.activeType();
        this.divideValueBy = Math.max(1, packet.divideValueBy());
        this.setChanged();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().blockChanged(this.getBlockPos());
        }
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.damageStored = compound.contains("damageStored") ? compound.getFloat("damageStored") : 0.0f;
        this.deathsStored = compound.contains("deathsStored") ? compound.getInt("deathsStored") : 0;
        this.saplingsGrownStored = compound.contains("saplingsGrownStored") ? compound.getInt("saplingsGrownStored") : 0;
        this.healthRecoveredStored = compound.contains("healthRecoveredStored") ? compound.getFloat("healthRecoveredStored") : 0.0f;
        this.lightningStruckStored = compound.contains("lightningStruckStored") ? compound.getInt("lightningStruckStored") : 0;
        this.entitiesBredStored = compound.contains("entitiesBredStored") ? compound.getInt("entitiesBredStored") : 0;
        this.explosionsStored = compound.contains("explosionsStored") ? compound.getInt("explosionsStored") : 0;
        this.alchemyActivatedStored = compound.contains("alchemyActivatedStored") ? compound.getInt("alchemyActivatedStored") : 0;
        this.gristDropsStored = compound.contains("gristDropsStored") ? compound.getInt("gristDropsStored") : 0;
        this.tickCycle = compound.getInt("tickCycle");
        this.activeType = ActiveType.fromInt(compound.getInt("activeTypeOrdinal"));
        this.divideValueBy = compound.contains("divideValueBy") ? compound.getInt("divideValueBy") : 1;
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putFloat("damageStored", this.damageStored);
        compound.putInt("deathsStored", this.deathsStored);
        compound.putInt("saplingsGrownStored", this.saplingsGrownStored);
        compound.putFloat("healthRecoveredStored", this.healthRecoveredStored);
        compound.putInt("lightningStruckStored", this.lightningStruckStored);
        compound.putInt("entitiesBredStored", this.entitiesBredStored);
        compound.putInt("explosionsStored", this.explosionsStored);
        compound.putInt("alchemyActivatedStored", this.alchemyActivatedStored);
        compound.putInt("gristDropsStored", this.gristDropsStored);
        compound.putInt("tickCycle", this.tickCycle);
        compound.putInt("activeTypeOrdinal", this.getActiveType().ordinal());
        compound.putInt("divideValueBy", this.divideValueBy);
    }

    public int getActiveStoredStatValue() {
        this.activeType = this.getActiveType();
        if (this.activeType == ActiveType.DAMAGE) {
            return (int)this.damageStored;
        }
        if (this.activeType == ActiveType.DEATHS) {
            return this.deathsStored;
        }
        if (this.activeType == ActiveType.SAPLING_GROWN) {
            return this.saplingsGrownStored;
        }
        if (this.activeType == ActiveType.HEALTH_RECOVERED) {
            return (int)this.healthRecoveredStored;
        }
        if (this.activeType == ActiveType.LIGHTNING_STRUCK_ENTITY) {
            return this.lightningStruckStored;
        }
        if (this.activeType == ActiveType.ENTITIES_BRED) {
            return this.entitiesBredStored;
        }
        if (this.activeType == ActiveType.EXPLOSIONS) {
            return this.explosionsStored;
        }
        if (this.activeType == ActiveType.ALCHEMY_ACTIVATED) {
            return this.alchemyActivatedStored;
        }
        if (this.activeType == ActiveType.GRIST_DROPS) {
            return this.gristDropsStored;
        }
        return 0;
    }

    public ActiveType getActiveType() {
        if (this.activeType == null) {
            this.activeType = ActiveType.DAMAGE;
        }
        return this.activeType;
    }

    public int getDivideValueBy() {
        if (this.divideValueBy <= 0) {
            this.divideValueBy = 1;
        }
        return this.divideValueBy;
    }

    public void setActiveStoredStatValue(float storedStatIn) {
        this.activeType = this.getActiveType();
        boolean changeBlockState = false;
        if (this.activeType == ActiveType.DAMAGE) {
            this.damageStored = storedStatIn;
            changeBlockState = true;
        } else if (this.activeType == ActiveType.DEATHS) {
            this.deathsStored = (int)storedStatIn;
            changeBlockState = true;
        } else if (this.activeType == ActiveType.SAPLING_GROWN) {
            this.saplingsGrownStored = (int)storedStatIn;
            changeBlockState = true;
        } else if (this.activeType == ActiveType.HEALTH_RECOVERED) {
            this.healthRecoveredStored = storedStatIn;
            changeBlockState = true;
        } else if (this.activeType == ActiveType.LIGHTNING_STRUCK_ENTITY) {
            this.lightningStruckStored = (int)storedStatIn;
            changeBlockState = true;
        } else if (this.activeType == ActiveType.ENTITIES_BRED) {
            this.entitiesBredStored = (int)storedStatIn;
            changeBlockState = true;
        } else if (this.activeType == ActiveType.EXPLOSIONS) {
            this.explosionsStored = (int)storedStatIn;
            changeBlockState = true;
        } else if (this.activeType == ActiveType.ALCHEMY_ACTIVATED) {
            this.alchemyActivatedStored = (int)storedStatIn;
            changeBlockState = true;
        } else if (this.activeType == ActiveType.GRIST_DROPS) {
            this.gristDropsStored = (int)storedStatIn;
            changeBlockState = true;
        }
        if (changeBlockState && this.level != null) {
            this.level.updateNeighborsAt(this.worldPosition, this.level.getBlockState(this.worldPosition).getBlock());
        }
    }

    public static void attemptStatUpdate(float eventAmount, ActiveType activeType, BlockPos eventPos, Level level) {
        if (level != null && !level.isClientSide()) {
            for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)eventPos.offset(16, 16, 16), (BlockPos)eventPos.offset(-16, -16, -16))) {
                StatStorerBlockEntity statStorer;
                if (!level.isAreaLoaded(blockPos, 0)) {
                    return;
                }
                BlockEntity blockEntity = level.getBlockEntity(blockPos);
                if (!(blockEntity instanceof StatStorerBlockEntity) || activeType != (statStorer = (StatStorerBlockEntity)blockEntity).getActiveType()) continue;
                statStorer.setActiveStoredStatValue((float)statStorer.getActiveStoredStatValue() + eventAmount);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onEntityHeal(LivingHealEvent event) {
        StatStorerBlockEntity.attemptStatUpdate(event.getAmount(), ActiveType.HEALTH_RECOVERED, event.getEntity().blockPosition(), event.getEntity().level());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onSaplingGrow(BlockGrowFeatureEvent event) {
        if (event.getLevel().getBlockState(event.getPos()).is(BlockTags.SAPLINGS)) {
            StatStorerBlockEntity.attemptStatUpdate(1.0f, ActiveType.SAPLING_GROWN, event.getPos(), (Level)event.getLevel());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onEntityStruck(EntityStruckByLightningEvent event) {
        if (event.getLightning().tickCount == 1) {
            StatStorerBlockEntity.attemptStatUpdate(1.0f, ActiveType.LIGHTNING_STRUCK_ENTITY, event.getEntity().blockPosition(), event.getEntity().level());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onEntityBred(BabyEntitySpawnEvent event) {
        if (!event.isCanceled()) {
            StatStorerBlockEntity.attemptStatUpdate(1.0f, ActiveType.ENTITIES_BRED, event.getParentA().blockPosition(), event.getParentA().level());
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        StatStorerBlockEntity.attemptStatUpdate(1.0f, ActiveType.EXPLOSIONS, BlockPos.containing((Position)event.getExplosion().center()), event.getLevel());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onAlchemy(AlchemyEvent event) {
        StatStorerBlockEntity.attemptStatUpdate(1.0f, ActiveType.ALCHEMY_ACTIVATED, event.getAlchemiter().getBlockPos(), event.getLevel());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onGristDrop(GristDropsEvent event) {
        StatStorerBlockEntity.attemptStatUpdate(1.0f, ActiveType.GRIST_DROPS, event.getUnderling().blockPosition(), event.getUnderling().level());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onEntityDamage(LivingDamageEvent.Post event) {
        StatStorerBlockEntity.attemptStatUpdate(event.getNewDamage(), ActiveType.DAMAGE, event.getEntity().blockPosition(), event.getEntity().level());
    }

    @SubscribeEvent(priority=EventPriority.LOWEST, receiveCanceled=false)
    public static void onEntityDeath(LivingDeathEvent event) {
        StatStorerBlockEntity.attemptStatUpdate(1.0f, ActiveType.DEATHS, event.getEntity().blockPosition(), event.getEntity().level());
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tagCompound = super.getUpdateTag(provider);
        tagCompound.putInt("activeTypeOrdinal", this.getActiveType().ordinal());
        tagCompound.putInt("divideValueBy", this.getDivideValueBy());
        return tagCompound;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public static enum ActiveType {
        DAMAGE,
        DEATHS,
        SAPLING_GROWN,
        HEALTH_RECOVERED,
        LIGHTNING_STRUCK_ENTITY,
        ENTITIES_BRED,
        EXPLOSIONS,
        ALCHEMY_ACTIVATED,
        GRIST_DROPS;


        public static ActiveType fromInt(int ordinal) {
            for (ActiveType type : ActiveType.values()) {
                if (type.ordinal() != ordinal) continue;
                return type;
            }
            throw new IllegalArgumentException("Invalid ordinal of " + ordinal + " for stat storer active type!");
        }

        public String getNameNoSpaces() {
            return this.name().replace('_', ' ');
        }
    }
}

