/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.redstone;

import com.mraof.minestuck.block.MSProperties;
import com.mraof.minestuck.block.redstone.StructureCoreBlock;
import com.mraof.minestuck.block.redstone.SummonerBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.network.block.StructureCoreSettingsPacket;
import com.mraof.minestuck.world.gen.structure.CoreCompatibleScatteredStructurePiece;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;

public class StructureCoreBlockEntity
extends BlockEntity {
    private int tickCycle;
    @Nonnull
    private ActionType actionType;
    private int shutdownRange = 32;
    private boolean hasWiped = false;
    public final Structure[] SOLVABLE_STRUCTURES = new Structure[0];

    public StructureCoreBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.STRUCTURE_CORE.get(), pos, state);
        this.actionType = ActionType.READ_AND_REDSTONE;
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, StructureCoreBlockEntity blockEntity) {
        int cycleRate;
        int n = cycleRate = blockEntity.hasWiped && blockEntity.actionType == ActionType.READ_AND_WIPE ? 600 : 100;
        if (blockEntity.tickCycle >= cycleRate) {
            blockEntity.sendUpdate();
            blockEntity.tickCycle = 0;
        }
        ++blockEntity.tickCycle;
    }

    private void sendUpdate() {
        if (this.level != null && this.level.isAreaLoaded(this.getBlockPos(), 1) && ((Boolean)this.getBlockState().getValue((Property)StructureCoreBlock.ACTIVE)).booleanValue()) {
            StructureManager structureManager = ((ServerLevel)this.level).structureManager();
            List<StructureStart> structureStarts = this.getStructureStarts(structureManager);
            for (StructureStart structureStartIterate : structureStarts) {
                BlockState newState;
                CoreCompatibleScatteredStructurePiece piece = this.getStructurePiece(structureStartIterate);
                if (piece == null) continue;
                if (this.actionType == ActionType.WRITE) {
                    this.writeToStructure(piece);
                    continue;
                }
                if (this.actionType == ActionType.READ_AND_WIPE) {
                    if (!piece.hasBeenCompleted()) continue;
                    this.wipeSlate();
                    continue;
                }
                if (this.actionType != ActionType.READ_AND_REDSTONE || (newState = (BlockState)this.getBlockState().setValue((Property)StructureCoreBlock.POWERED, (Comparable)Boolean.valueOf(piece.hasBeenCompleted()))) == this.getBlockState()) continue;
                this.level.setBlockAndUpdate(this.getBlockPos(), newState);
            }
        }
    }

    public List<StructureStart> getStructureStarts(StructureManager structureManager) {
        ArrayList<StructureStart> structureStartList = new ArrayList<StructureStart>();
        for (Structure structureListIterate : this.SOLVABLE_STRUCTURES) {
            StructureStart potentialStructureStart = structureManager.getStructureAt(this.getBlockPos(), structureListIterate);
            if (!potentialStructureStart.isValid()) continue;
            structureStartList.add(potentialStructureStart);
        }
        return structureStartList;
    }

    private void writeToStructure(CoreCompatibleScatteredStructurePiece piece) {
        if (!piece.hasBeenCompleted()) {
            piece.nowCompleted();
        }
    }

    private CoreCompatibleScatteredStructurePiece getStructurePiece(StructureStart structureStart) {
        List structurePieceList = structureStart.getPieces();
        for (StructurePiece pieceIterate : structurePieceList) {
            if (!(pieceIterate instanceof CoreCompatibleScatteredStructurePiece)) continue;
            return (CoreCompatibleScatteredStructurePiece)pieceIterate;
        }
        return null;
    }

    private void wipeSlate() {
        if (this.level != null) {
            for (BlockPos iteratePos : BlockPos.betweenClosed((BlockPos)this.getBlockPos().offset(this.shutdownRange, this.shutdownRange, this.shutdownRange), (BlockPos)this.getBlockPos().offset(-this.shutdownRange, -this.shutdownRange, -this.shutdownRange))) {
                BlockState iterateState = this.level.getBlockState(iteratePos);
                if (iterateState.hasProperty((Property)MSProperties.SHUT_DOWN) && !((Boolean)iterateState.getValue((Property)MSProperties.SHUT_DOWN)).booleanValue()) {
                    this.level.setBlock(iteratePos, (BlockState)iterateState.setValue((Property)MSProperties.SHUT_DOWN, (Comparable)Boolean.valueOf(true)), 3);
                    this.hasWiped = true;
                }
                if (!iterateState.hasProperty((Property)MSProperties.UNTRIGGERABLE) || !((Boolean)iterateState.getValue((Property)MSProperties.UNTRIGGERABLE)).booleanValue()) continue;
                if (iterateState.getBlock() instanceof SummonerBlock) {
                    this.level.setBlock(iteratePos, (BlockState)((BlockState)iterateState.setValue((Property)SummonerBlock.UNTRIGGERABLE, (Comparable)Boolean.valueOf(false))).setValue((Property)SummonerBlock.TRIGGERED, (Comparable)Boolean.valueOf(true)), 3);
                }
                this.hasWiped = true;
            }
        }
    }

    public int getShutdownRange() {
        return this.shutdownRange;
    }

    public boolean getHasWiped() {
        return this.hasWiped;
    }

    public ActionType getActionType() {
        return this.actionType;
    }

    public void prepForUpdate() {
        this.tickCycle = 600;
    }

    public void handleSettingsPacket(StructureCoreSettingsPacket packet) {
        this.actionType = Objects.requireNonNull(packet.actionType());
        this.shutdownRange = packet.shutdownRange();
        this.hasWiped = false;
        this.setChanged();
        this.level.setBlock(packet.beBlockPos(), (BlockState)this.getBlockState().setValue((Property)StructureCoreBlock.POWERED, (Comparable)Boolean.valueOf(false)), 3);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.tickCycle = compound.getInt("tickCycle");
        this.actionType = ActionType.fromInt(compound.getInt("actionTypeOrdinal"));
        this.hasWiped = compound.getBoolean("hasWiped");
        this.shutdownRange = compound.getInt("shutdownRange");
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("tickCycle", this.tickCycle);
        compound.putInt("actionTypeOrdinal", this.getActionType().ordinal());
        compound.putBoolean("hasWiped", this.hasWiped);
        compound.putInt("shutdownRange", this.shutdownRange);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public static enum ActionType {
        READ_AND_WIPE,
        READ_AND_REDSTONE,
        WRITE;


        public static ActionType fromInt(int ordinal) {
            if (0 <= ordinal && ordinal < ActionType.values().length) {
                return ActionType.values()[ordinal];
            }
            throw new IllegalArgumentException("Invalid ordinal of " + ordinal + " for structure core action type!");
        }

        public String getNameNoSpaces() {
            return this.name().replace('_', ' ');
        }
    }
}

