/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.redstone;

import com.mraof.minestuck.block.redstone.SummonerBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.network.block.SummonerSettingsPacket;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacementTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class SummonerBlockEntity
extends BlockEntity {
    private EntityType<?> summonType;
    private int cooldownTimer;
    private int summonRange = 8;

    public SummonerBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.SUMMONER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, SummonerBlockEntity blockEntity) {
        if (level == null) {
            return;
        }
        if (blockEntity.cooldownTimer >= 200) {
            blockEntity.cooldownTimer = 0;
        }
        if (blockEntity.cooldownTimer != 0) {
            ++blockEntity.cooldownTimer;
        }
    }

    public void summonEntity(Level levelIn, BlockPos summonerBlockPos, EntityType<?> type, boolean triggerActivate, boolean playParticles) {
        if (type == null) {
            throw new IllegalStateException("SummonerBlockEntity unable to create a new entity. Entity factory returned null!");
        }
        if (this.cooldownTimer == 0 && levelIn instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelIn;
            int iterateTracker = 0;
            for (int i = 0; i < 60; ++i) {
                iterateTracker = i;
                double newPosX = (double)summonerBlockPos.getX() + (level.random.nextDouble() - 0.5) * (double)this.summonRange;
                double newPosY = (double)summonerBlockPos.getY() + (level.random.nextDouble() - 0.5) * (double)this.summonRange;
                double newPosZ = (double)summonerBlockPos.getZ() + (level.random.nextDouble() - 0.5) * (double)this.summonRange;
                if (!level.noCollision(type.getDimensions().makeBoundingBox(newPosX, newPosY, newPosZ)) || !SpawnPlacementTypes.ON_GROUND.isSpawnPositionOk((LevelReader)level, BlockPos.containing((double)newPosX, (double)newPosY, (double)newPosZ), type)) continue;
                BlockPos newBlockPos = BlockPos.containing((double)newPosX, (double)newPosY, (double)newPosZ);
                type.spawn(level, ItemStack.EMPTY, null, newBlockPos, MobSpawnType.MOB_SUMMONED, true, true);
                if (!playParticles) break;
                break;
            }
            if (iterateTracker == 59) {
                level.scheduleTick(new BlockPos((Vec3i)summonerBlockPos), this.getBlockState().getBlock(), 30);
            } else {
                if (triggerActivate) {
                    level.setBlockAndUpdate(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)SummonerBlock.TRIGGERED, (Comparable)Boolean.valueOf(true)));
                }
                this.cooldownTimer = 1;
            }
        }
    }

    public void setSummonedEntity(EntityType<?> entityTypeIn) {
        this.summonType = entityTypeIn;
        this.setChanged();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().blockChanged(this.getBlockPos());
        }
    }

    public EntityType<?> getSummonedEntity() {
        if (this.summonType == null) {
            this.summonType = MSEntityTypes.IMP.get();
        }
        return this.summonType;
    }

    public void setSummonRange(int rangeIn) {
        this.summonRange = Mth.clamp((int)rangeIn, (int)1, (int)64);
    }

    public int getSummonRange() {
        return this.summonRange;
    }

    public void handleSettingsPacket(SummonerSettingsPacket packet) {
        this.setSummonedEntity(packet.entityType());
        this.setSummonRange(packet.summonRange());
        this.setChanged();
        this.getLevel().setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)SummonerBlock.UNTRIGGERABLE, (Comparable)Boolean.valueOf(packet.isUntriggerable())), 3);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.cooldownTimer = compound.getInt("cooldownTimer");
        if (compound.contains("summonRange", 99)) {
            this.setSummonRange(compound.getInt("summonRange"));
        } else {
            this.setSummonRange(16);
        }
        Optional attemptedSummonType = EntityType.byString((String)compound.getString("summonType"));
        attemptedSummonType.ifPresent(entityType -> {
            this.summonType = entityType;
        });
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("cooldownTimer", this.cooldownTimer);
        compound.putInt("summonRange", this.summonRange);
        compound.putString("summonType", EntityType.getKey(this.getSummonedEntity()).toString());
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

