/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.redstone;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.block.redstone.WirelessRedstoneReceiverBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.blockentity.redstone.WirelessRedstoneTransmitterBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WirelessRedstoneReceiverBlockEntity
extends BlockEntity {
    private BlockPos lastTransmitterBlockPos;
    private int lastTransmission;

    public WirelessRedstoneReceiverBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.WIRELESS_REDSTONE_RECEIVER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, WirelessRedstoneReceiverBlockEntity blockEntity) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (blockEntity.lastTransmission >= (Integer)MinestuckConfig.SERVER.puzzleBlockTickRate.get() && ((Boolean)state.getValue((Property)WirelessRedstoneReceiverBlock.AUTO_RESET)).booleanValue()) {
            blockEntity.renewFromLastTransmitter();
            blockEntity.lastTransmission = 0;
        }
        if (blockEntity.lastTransmission < (Integer)MinestuckConfig.SERVER.puzzleBlockTickRate.get()) {
            ++blockEntity.lastTransmission;
        }
    }

    public BlockPos getLastTransmitterBlockPos() {
        if (this.lastTransmitterBlockPos == null) {
            this.lastTransmitterBlockPos = new BlockPos(0, 0, 0);
        }
        return this.lastTransmitterBlockPos;
    }

    public void setLastTransmitterBlockPos(BlockPos lastTransmitterPosIn) {
        this.lastTransmitterBlockPos = lastTransmitterPosIn;
    }

    public void renewFromLastTransmitter() {
        if (this.level != null && !this.level.isClientSide) {
            BlockState state = this.getBlockState();
            BlockState unpoweredState = WirelessRedstoneReceiverBlock.setPower(state, 0);
            if (this.lastTransmitterBlockPos != null && this.level.isAreaLoaded(this.lastTransmitterBlockPos, 1)) {
                BlockEntity blockEntity = this.level.getBlockEntity(this.lastTransmitterBlockPos);
                if (blockEntity instanceof WirelessRedstoneTransmitterBlockEntity) {
                    WirelessRedstoneTransmitterBlockEntity be = (WirelessRedstoneTransmitterBlockEntity)blockEntity;
                    be.sendUpdateToPosition(this.level, this.getBlockPos());
                } else if (state != unpoweredState) {
                    this.level.setBlock(this.getBlockPos(), unpoweredState, 3);
                }
            } else if (state != unpoweredState) {
                this.level.setBlock(this.getBlockPos(), unpoweredState, 3);
            }
        }
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.lastTransmission = compound.getInt("lastTransmission");
        int transmitterX = compound.getInt("transmitterX");
        int transmitterY = compound.getInt("transmitterY");
        int transmitterZ = compound.getInt("transmitterZ");
        this.lastTransmitterBlockPos = new BlockPos(transmitterX, transmitterY, transmitterZ);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("lastTransmission", this.lastTransmission);
        this.getLastTransmitterBlockPos();
        compound.putInt("transmitterX", this.lastTransmitterBlockPos.getX());
        compound.putInt("transmitterY", this.lastTransmitterBlockPos.getY());
        compound.putInt("transmitterZ", this.lastTransmitterBlockPos.getZ());
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

