/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.blockentity.redstone;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.block.redstone.WirelessRedstoneReceiverBlock;
import com.mraof.minestuck.block.redstone.WirelessRedstoneTransmitterBlock;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.network.block.WirelessRedstoneTransmitterSettingsPacket;
import com.mraof.minestuck.util.MSRotationUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class WirelessRedstoneTransmitterBlockEntity
extends BlockEntity {
    private BlockPos offsetPos = new BlockPos(0, 0, 0);
    private int tickCycle;

    public WirelessRedstoneTransmitterBlockEntity(BlockPos pos, BlockState state) {
        super(MSBlockEntityTypes.WIRELESS_REDSTONE_TRANSMITTER.get(), pos, state);
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, WirelessRedstoneTransmitterBlockEntity blockEntity) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (blockEntity.tickCycle >= (Integer)MinestuckConfig.SERVER.puzzleBlockTickRate.get()) {
            blockEntity.sendUpdateToPosition();
            blockEntity.tickCycle = 0;
        }
        ++blockEntity.tickCycle;
    }

    public BlockPos getDestinationBlockPosFromOffset() {
        Direction stateFacing = (Direction)this.getBlockState().getValue((Property)WirelessRedstoneTransmitterBlock.FACING);
        return this.getBlockPos().offset((Vec3i)this.offsetPos.rotate(MSRotationUtil.rotationBetween(Direction.NORTH, stateFacing)));
    }

    public void handleSettingsPacket(WirelessRedstoneTransmitterSettingsPacket packet) {
        Direction facing = (Direction)this.getBlockState().getValue((Property)WirelessRedstoneTransmitterBlock.FACING);
        this.offsetPos = packet.destinationBlockPos().subtract((Vec3i)this.worldPosition).rotate(MSRotationUtil.rotationBetween(facing, Direction.NORTH));
        this.setChanged();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getChunkSource().blockChanged(this.getBlockPos());
        }
    }

    private void sendUpdateToPosition() {
        BlockPos destBlockPos = this.getDestinationBlockPosFromOffset();
        if (destBlockPos != null && this.level != null && !this.level.isClientSide && this.level.isAreaLoaded(destBlockPos, 1)) {
            ((WirelessRedstoneTransmitterBlock)this.getBlockState().getBlock()).updatePower(this.level, this.getBlockPos());
            BlockState destBlockState = this.level.getBlockState(destBlockPos);
            Block block = destBlockState.getBlock();
            if (block instanceof WirelessRedstoneReceiverBlock) {
                WirelessRedstoneReceiverBlock receiverBlock = (WirelessRedstoneReceiverBlock)block;
                if ((Integer)destBlockState.getValue((Property)WirelessRedstoneReceiverBlock.POWER) < (Integer)this.getBlockState().getValue((Property)WirelessRedstoneTransmitterBlock.POWER)) {
                    receiverBlock.updatePower(this.level, destBlockPos, this.getBlockPos());
                }
            }
        }
    }

    public void sendUpdateToPosition(Level level, BlockPos destBlockPos) {
        if (destBlockPos != null && level != null && !level.isClientSide && level.isAreaLoaded(destBlockPos, 1)) {
            if (destBlockPos.equals((Object)this.getDestinationBlockPosFromOffset())) {
                BlockState blockStateIn = level.getBlockState(destBlockPos);
                Block block = blockStateIn.getBlock();
                if (block instanceof WirelessRedstoneReceiverBlock) {
                    WirelessRedstoneReceiverBlock receiverBlock = (WirelessRedstoneReceiverBlock)block;
                    receiverBlock.updatePower(level, destBlockPos, this.getBlockPos());
                }
            } else {
                BlockState newState;
                BlockState blockStateIn = level.getBlockState(destBlockPos);
                if (blockStateIn.getBlock() instanceof WirelessRedstoneReceiverBlock && blockStateIn != (newState = WirelessRedstoneReceiverBlock.setPower(blockStateIn, 0))) {
                    level.setBlock(destBlockPos, newState, 3);
                }
            }
        }
    }

    public BlockPos findReceiver() {
        if (this.level != null) {
            for (BlockPos blockPos : BlockPos.betweenClosed((BlockPos)this.getBlockPos().offset(24, 24, 24), (BlockPos)this.getBlockPos().offset(-24, -24, -24))) {
                Block block = this.level.getBlockState(blockPos).getBlock();
                if (!(block instanceof WirelessRedstoneReceiverBlock)) continue;
                return blockPos;
            }
        }
        return null;
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.loadAdditional(compound, provider);
        this.tickCycle = compound.getInt("tickCycle");
        int offsetX = compound.getInt("offsetX");
        int offsetY = compound.getInt("offsetY");
        int offsetZ = compound.getInt("offsetZ");
        this.offsetPos = new BlockPos(offsetX, offsetY, offsetZ);
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider provider) {
        super.saveAdditional(compound, provider);
        compound.putInt("tickCycle", this.tickCycle);
        compound.putInt("offsetX", this.offsetPos.getX());
        compound.putInt("offsetY", this.offsetPos.getY());
        compound.putInt("offsetZ", this.offsetPos.getZ());
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        return this.saveWithoutMetadata(provider);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }
}

