/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client;

import com.mraof.minestuck.network.LandTypesDataPacket;
import com.mraof.minestuck.world.lands.LandProperties;
import com.mraof.minestuck.world.lands.LandTypePair;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class ClientDimensionData {
    private static final Map<ResourceKey<Level>, LandTypePair> landTypes = new HashMap<ResourceKey<Level>, LandTypePair>();
    private static LandProperties properties;
    private static ResourceKey<Level> currentWorld;

    public static LandTypePair getLandTypes(ResourceKey<Level> level) {
        return landTypes.get(level);
    }

    public static boolean isLand(ResourceKey<Level> level) {
        return landTypes.containsKey(level);
    }

    public static LandProperties getProperties(ClientLevel level) {
        if (level == null) {
            return null;
        }
        ResourceKey key = level.dimension();
        if (currentWorld != key) {
            currentWorld = key;
            LandTypePair pair = ClientDimensionData.getLandTypes((ResourceKey<Level>)key);
            properties = pair != null ? LandProperties.create(pair) : null;
        }
        return properties;
    }

    @SubscribeEvent
    public static void onLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        landTypes.clear();
        currentWorld = null;
        properties = null;
    }

    public static void receivePacket(LandTypesDataPacket packet) {
        landTypes.clear();
        currentWorld = null;
        properties = null;
        landTypes.putAll(packet.types());
    }
}

