/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client;

import com.mojang.blaze3d.shaders.FogShape;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.blockentity.MSBlockEntityTypes;
import com.mraof.minestuck.client.DerseSpecialEffects;
import com.mraof.minestuck.client.LandRenderInfo;
import com.mraof.minestuck.client.ProspitSpecialEffects;
import com.mraof.minestuck.client.VeilSpecialEffects;
import com.mraof.minestuck.client.gui.computer.DiskBurnerGui;
import com.mraof.minestuck.client.gui.computer.ProgramGui;
import com.mraof.minestuck.client.gui.computer.SburbClientGui;
import com.mraof.minestuck.client.gui.computer.SburbServerGui;
import com.mraof.minestuck.client.gui.computer.SettingsAppGui;
import com.mraof.minestuck.client.model.MSModelLayers;
import com.mraof.minestuck.client.model.armor.AmphibeanieModel;
import com.mraof.minestuck.client.model.armor.ArmorModels;
import com.mraof.minestuck.client.model.armor.CrumplyHatModel;
import com.mraof.minestuck.client.model.armor.DreamerPajamasModel;
import com.mraof.minestuck.client.model.armor.NostrildamusModel;
import com.mraof.minestuck.client.model.armor.PonytailModel;
import com.mraof.minestuck.client.model.entity.BishopModel;
import com.mraof.minestuck.client.model.entity.RookModel;
import com.mraof.minestuck.client.particles.ExhaustParticle;
import com.mraof.minestuck.client.particles.PlasmaParticle;
import com.mraof.minestuck.client.particles.TransportalizerParticle;
import com.mraof.minestuck.client.renderer.blockentity.AlchemiterRenderer;
import com.mraof.minestuck.client.renderer.blockentity.GateRenderer;
import com.mraof.minestuck.client.renderer.blockentity.HolopadRenderer;
import com.mraof.minestuck.client.renderer.blockentity.HorseClockRenderer;
import com.mraof.minestuck.client.renderer.blockentity.ReturnNodeRenderer;
import com.mraof.minestuck.client.renderer.blockentity.SkaiaPortalRenderer;
import com.mraof.minestuck.client.renderer.blockentity.TotemLatheRenderer;
import com.mraof.minestuck.client.renderer.entity.ConsortRenderer;
import com.mraof.minestuck.client.renderer.entity.DecoyRenderer;
import com.mraof.minestuck.client.renderer.entity.GristRenderer;
import com.mraof.minestuck.client.renderer.entity.LotusFlowerRenderer;
import com.mraof.minestuck.client.renderer.entity.MetalBoatRenderer;
import com.mraof.minestuck.client.renderer.entity.PawnRenderer;
import com.mraof.minestuck.client.renderer.entity.PosterRenderer;
import com.mraof.minestuck.client.renderer.entity.ServerCursorRenderer;
import com.mraof.minestuck.client.renderer.entity.SimpleTexturedEntityRenderer;
import com.mraof.minestuck.client.renderer.entity.UnderlingRenderer;
import com.mraof.minestuck.client.renderer.entity.VitalityGelRenderer;
import com.mraof.minestuck.client.renderer.entity.frog.FrogRenderer;
import com.mraof.minestuck.client.util.MSKeyHandler;
import com.mraof.minestuck.computer.ProgramTypes;
import com.mraof.minestuck.entity.FrogEntity;
import com.mraof.minestuck.entity.MSEntityTypes;
import com.mraof.minestuck.entity.carapacian.EnumEntityKingdom;
import com.mraof.minestuck.entity.consort.EnumConsort;
import com.mraof.minestuck.fluid.MSFluids;
import com.mraof.minestuck.item.BoondollarsItem;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.StructureScannerItem;
import com.mraof.minestuck.item.armor.MSArmorItem;
import com.mraof.minestuck.item.components.CardStoredItemComponent;
import com.mraof.minestuck.item.components.FrogTraitsComponent;
import com.mraof.minestuck.item.components.MSItemComponents;
import com.mraof.minestuck.item.components.StoneTabletTextComponent;
import com.mraof.minestuck.item.weapon.MusicPlayerWeapon;
import com.mraof.minestuck.util.MSParticleType;
import com.mraof.minestuck.world.MSDimensions;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.HangingSignRenderer;
import net.minecraft.client.renderer.blockentity.SignRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.item.CompassItemPropertyFunction;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.renderer.item.ItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.event.EntityRenderersEvent;
import net.neoforged.neoforge.client.event.RegisterDimensionSpecialEffectsEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.IClientBlockExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.registries.DeferredItem;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector3f;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD, modid="minestuck")
public class ClientProxy {
    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        MSKeyHandler.registerKeys(event);
    }

    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        EntityRenderers.register(MSEntityTypes.FROG.get(), FrogRenderer::new);
        EntityRenderers.register(MSEntityTypes.LOTUS_FLOWER.get(), LotusFlowerRenderer::new);
        EntityRenderers.register(MSEntityTypes.SERVER_CURSOR.get(), ServerCursorRenderer::new);
        EntityRenderers.register(MSEntityTypes.NAKAGATOR.get(), context -> new ConsortRenderer(context, EnumConsort.NAKAGATOR));
        EntityRenderers.register(MSEntityTypes.SALAMANDER.get(), context -> new ConsortRenderer(context, EnumConsort.SALAMANDER));
        EntityRenderers.register(MSEntityTypes.IGUANA.get(), context -> new ConsortRenderer(context, EnumConsort.IGUANA));
        EntityRenderers.register(MSEntityTypes.TURTLE.get(), context -> new ConsortRenderer(context, EnumConsort.TURTLE));
        EntityRenderers.register(MSEntityTypes.IMP.get(), context -> new UnderlingRenderer(context, "imp"));
        EntityRenderers.register(MSEntityTypes.OGRE.get(), context -> new UnderlingRenderer(context, "ogre"));
        EntityRenderers.register(MSEntityTypes.BASILISK.get(), context -> new UnderlingRenderer(context, "basilisk"));
        EntityRenderers.register(MSEntityTypes.LICH.get(), context -> new UnderlingRenderer(context, "lich"));
        EntityRenderers.register(MSEntityTypes.GICLOPS.get(), context -> new UnderlingRenderer(context, "giclops"));
        EntityRenderers.register(MSEntityTypes.PROSPITIAN_BISHOP.get(), manager -> new SimpleTexturedEntityRenderer(manager, new BishopModel(manager.bakeLayer(MSModelLayers.BISHOP)), 1.8f, MSEntityTypes.PROSPITIAN_BISHOP.get()));
        EntityRenderers.register(MSEntityTypes.DERSITE_BISHOP.get(), manager -> new SimpleTexturedEntityRenderer(manager, new BishopModel(manager.bakeLayer(MSModelLayers.BISHOP)), 1.8f, MSEntityTypes.DERSITE_BISHOP.get()));
        EntityRenderers.register(MSEntityTypes.PROSPITIAN_ROOK.get(), manager -> new SimpleTexturedEntityRenderer(manager, new RookModel(manager.bakeLayer(MSModelLayers.ROOK)), 2.5f, MSEntityTypes.PROSPITIAN_ROOK.get()));
        EntityRenderers.register(MSEntityTypes.DERSITE_ROOK.get(), manager -> new SimpleTexturedEntityRenderer(manager, new RookModel(manager.bakeLayer(MSModelLayers.ROOK)), 2.5f, MSEntityTypes.DERSITE_ROOK.get()));
        EntityRenderers.register(MSEntityTypes.PROSPITIAN_PAWN.get(), context -> new PawnRenderer(context, EnumEntityKingdom.PROSPITIAN));
        EntityRenderers.register(MSEntityTypes.DERSITE_PAWN.get(), context -> new PawnRenderer(context, EnumEntityKingdom.DERSITE));
        EntityRenderers.register(MSEntityTypes.GRIST.get(), GristRenderer::new);
        EntityRenderers.register(MSEntityTypes.VITALITY_GEL.get(), VitalityGelRenderer::new);
        EntityRenderers.register(MSEntityTypes.PLAYER_DECOY.get(), DecoyRenderer::new);
        EntityRenderers.register(MSEntityTypes.METAL_BOAT.get(), MetalBoatRenderer::new);
        EntityRenderers.register(MSEntityTypes.BARBASOL_BOMB.get(), ThrownItemRenderer::new);
        EntityRenderers.register(MSEntityTypes.CONSUMABLE_PROJECTILE.get(), ThrownItemRenderer::new);
        EntityRenderers.register(MSEntityTypes.RETURNING_PROJECTILE.get(), ThrownItemRenderer::new);
        EntityRenderers.register(MSEntityTypes.BOUNCING_PROJECTILE.get(), ThrownItemRenderer::new);
        EntityRenderers.register(MSEntityTypes.POSTER.get(), PosterRenderer::new);
        ProgramGui.Registry.register(ProgramTypes.SBURB_CLIENT, SburbClientGui::new);
        ProgramGui.Registry.register(ProgramTypes.SBURB_SERVER, SburbServerGui::new);
        ProgramGui.Registry.register(ProgramTypes.DISK_BURNER, DiskBurnerGui::new);
        ProgramGui.Registry.register(ProgramTypes.SETTINGS, SettingsAppGui::new);
        ClientProxy.registerArmorModels();
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)MSFluids.OIL.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)MSFluids.FLOWING_OIL.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)MSFluids.BLOOD.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)MSFluids.FLOWING_BLOOD.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)MSFluids.BRAIN_JUICE.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)MSFluids.FLOWING_BRAIN_JUICE.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)MSFluids.WATER_COLORS.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)MSFluids.FLOWING_WATER_COLORS.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)MSFluids.LIGHT_WATER.get()), (RenderType)RenderType.translucent());
        ItemBlockRenderTypes.setRenderLayer((Fluid)((Fluid)MSFluids.FLOWING_LIGHT_WATER.get()), (RenderType)RenderType.translucent());
        ItemPropertyFunction encoded = (stack, level, holder, seed) -> stack.has(MSItemComponents.ENCODED_ITEM) ? 1.0f : 0.0f;
        ItemProperties.register((Item)((Item)MSItems.CRUXITE_DOWEL.get()), (ResourceLocation)Minestuck.id("content"), (ItemPropertyFunction)encoded);
        ItemProperties.register((Item)((Item)MSItems.SHUNT.get()), (ResourceLocation)Minestuck.id("content"), (ItemPropertyFunction)encoded);
        ItemProperties.register((Item)((Item)MSItems.CAPTCHA_CARD.get()), (ResourceLocation)Minestuck.id("punched"), (ItemPropertyFunction)encoded);
        ItemProperties.register((Item)((Item)MSItems.CAPTCHA_CARD.get()), (ResourceLocation)Minestuck.id("content"), (stack, level, holder, seed) -> stack.has(MSItemComponents.CARD_STORED_ITEM) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)MSItems.CAPTCHA_CARD.get()), (ResourceLocation)Minestuck.id("ghost"), (stack, level, holder, seed) -> ((CardStoredItemComponent)stack.getOrDefault(MSItemComponents.CARD_STORED_ITEM, (Object)CardStoredItemComponent.EMPTY)).isGhostItem() ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)MSItems.BOONDOLLARS.get()), (ResourceLocation)Minestuck.id("count"), (stack, level, holder, seed) -> BoondollarsItem.getCount(stack));
        ItemProperties.register((Item)((Item)MSItems.FROG.get()), (ResourceLocation)Minestuck.id("type"), (stack, level, holder, seed) -> stack.has(MSItemComponents.FROG_TRAITS) ? (float)((FrogTraitsComponent)stack.get(MSItemComponents.FROG_TRAITS)).variant().orElse(FrogEntity.FrogVariants.DEFAULT).ordinal() : (float)FrogEntity.FrogVariants.DEFAULT.ordinal());
        ItemProperties.register((Item)((Item)MSItems.STONE_TABLET.get()), (ResourceLocation)Minestuck.id("carved"), (stack, level, holder, seed) -> StoneTabletTextComponent.hasText(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)MSItems.MUSIC_SWORD.get()), (ResourceLocation)Minestuck.id("has_cassette"), (stack, level, holder, seed) -> MusicPlayerWeapon.hasCassette(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)MSItems.BOOMBOX_BEATER.get()), (ResourceLocation)Minestuck.id("has_cassette"), (stack, level, holder, seed) -> MusicPlayerWeapon.hasCassette(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)((Item)MSItems.TEMPLE_SCANNER.get()), (ResourceLocation)Minestuck.id("angle"), (ItemPropertyFunction)new CompassItemPropertyFunction((level, stack, entity) -> (GlobalPos)stack.get(MSItemComponents.TARGET_LOCATION)));
        ItemProperties.register((Item)((Item)MSItems.TEMPLE_SCANNER.get()), (ResourceLocation)Minestuck.id("powered"), (stack, level, entity, seed) -> StructureScannerItem.isPowered(stack) ? 1.0f : 0.0f);
    }

    @SubscribeEvent
    public static void registerBER(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer(MSBlockEntityTypes.SKAIA_PORTAL.get(), SkaiaPortalRenderer::new);
        event.registerBlockEntityRenderer(MSBlockEntityTypes.GATE.get(), GateRenderer::new);
        event.registerBlockEntityRenderer(MSBlockEntityTypes.RETURN_NODE.get(), ReturnNodeRenderer::new);
        event.registerBlockEntityRenderer(MSBlockEntityTypes.HOLOPAD.get(), HolopadRenderer::new);
        event.registerBlockEntityRenderer(MSBlockEntityTypes.TOTEM_LATHE_DOWEL.get(), TotemLatheRenderer::new);
        event.registerBlockEntityRenderer(MSBlockEntityTypes.ALCHEMITER.get(), AlchemiterRenderer::new);
        event.registerBlockEntityRenderer(MSBlockEntityTypes.HORSE_CLOCK.get(), HorseClockRenderer::new);
        event.registerBlockEntityRenderer(MSBlockEntityTypes.SIGN.get(), SignRenderer::new);
        event.registerBlockEntityRenderer(MSBlockEntityTypes.HANGING_SIGN.get(), HangingSignRenderer::new);
    }

    @SubscribeEvent
    public static void registerDimensionEffects(RegisterDimensionSpecialEffectsEvent event) {
        event.register(MSDimensions.LAND_EFFECTS, (DimensionSpecialEffects)new LandRenderInfo());
        event.register(MSDimensions.PROSPIT_EFFECTS, (DimensionSpecialEffects)new ProspitSpecialEffects());
        event.register(MSDimensions.DERSE_EFFECTS, (DimensionSpecialEffects)new DerseSpecialEffects());
        event.register(MSDimensions.VEIL_EFFECTS, (DimensionSpecialEffects)new VeilSpecialEffects());
    }

    private static void registerArmorModels() {
        ArmorModels.register((MSArmorItem)((Object)MSItems.CRUMPLY_HAT.get()), new HumanoidModel(CrumplyHatModel.createBodyLayer().bakeRoot()));
        ArmorModels.register((MSArmorItem)((Object)MSItems.AMPHIBEANIE.get()), new HumanoidModel(AmphibeanieModel.createBodyLayer().bakeRoot()));
        ArmorModels.register((MSArmorItem)((Object)MSItems.NOSTRILDAMUS.get()), new HumanoidModel(NostrildamusModel.createBodyLayer().bakeRoot()));
        ArmorModels.register((MSArmorItem)((Object)MSItems.PONYTAIL.get()), new HumanoidModel(PonytailModel.createBodyLayer().bakeRoot()));
        HumanoidModel pajamasModel = new HumanoidModel(DreamerPajamasModel.createBodyLayer().bakeRoot());
        ArmorModels.register((MSArmorItem)((Object)MSItems.PROSPIT_CIRCLET.get()), pajamasModel);
        ArmorModels.register((MSArmorItem)((Object)MSItems.PROSPIT_SHIRT.get()), pajamasModel);
        ArmorModels.register((MSArmorItem)((Object)MSItems.PROSPIT_PANTS.get()), pajamasModel);
        ArmorModels.register((MSArmorItem)((Object)MSItems.PROSPIT_SHOES.get()), pajamasModel);
        ArmorModels.register((MSArmorItem)((Object)MSItems.DERSE_CIRCLET.get()), pajamasModel);
        ArmorModels.register((MSArmorItem)((Object)MSItems.DERSE_SHIRT.get()), pajamasModel);
        ArmorModels.register((MSArmorItem)((Object)MSItems.DERSE_PANTS.get()), pajamasModel);
        ArmorModels.register((MSArmorItem)((Object)MSItems.DERSE_SHOES.get()), pajamasModel);
    }

    @SubscribeEvent
    public static void registerFactories(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)MSParticleType.TRANSPORTALIZER.get(), TransportalizerParticle.Provider::new);
        event.registerSpriteSet((ParticleType)MSParticleType.PLASMA.get(), PlasmaParticle.Provider::new);
        event.registerSpriteSet((ParticleType)MSParticleType.EXHAUST.get(), ExhaustParticle.Provider::new);
    }

    @SubscribeEvent
    private static void registerExtensions(RegisterClientExtensionsEvent event) {
        event.registerBlock(new IClientBlockExtensions(){

            public boolean addDestroyEffects(BlockState state, Level level, BlockPos pos, ParticleEngine manager) {
                return true;
            }
        }, new Holder[]{MSBlocks.GATE, MSBlocks.GATE_MAIN, MSBlocks.RETURN_NODE, MSBlocks.RETURN_NODE_MAIN});
        event.registerFluidType(ClientProxy.commonFluidExtension(MSFluids.OIL_TYPE.getId(), new Vector3f(0.0f, 0.0f, 0.0f), 0.8f), new Holder[]{MSFluids.OIL_TYPE});
        event.registerFluidType(ClientProxy.commonFluidExtension(MSFluids.LIGHT_WATER_TYPE.getId(), new Vector3f(0.2f, 0.3f, 1.0f), 0.2f), new Holder[]{MSFluids.LIGHT_WATER_TYPE});
        event.registerFluidType(ClientProxy.commonFluidExtension(MSFluids.BLOOD_TYPE.getId(), new Vector3f(0.8f, 0.0f, 0.0f), 0.35f), new Holder[]{MSFluids.BLOOD_TYPE});
        event.registerFluidType(ClientProxy.commonFluidExtension(MSFluids.BRAIN_JUICE_TYPE.getId(), new Vector3f(0.55f, 0.25f, 0.7f), 0.25f), new Holder[]{MSFluids.BRAIN_JUICE_TYPE});
        event.registerFluidType(new IClientFluidTypeExtensions(){
            private final ResourceLocation stillTexture = MSFluids.WATER_COLORS_TYPE.getId().withPrefix("block/still_");
            private final ResourceLocation flowingTexture = MSFluids.WATER_COLORS_TYPE.getId().withPrefix("block/flowing_");

            public ResourceLocation getStillTexture() {
                return this.stillTexture;
            }

            public ResourceLocation getFlowingTexture() {
                return this.flowingTexture;
            }

            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                Vector3f colorValue = new Vector3f(0.0f, 20.0f, 30.0f).rotateY((float)(camera.getEntity().getX() / 2.0)).rotateX((float)(camera.getEntity().getZ() / 2.0)).rotateY((float)camera.getEntity().getY()).normalize();
                return new Vector3f(colorValue.x % 1.0f, colorValue.y % 1.0f, colorValue.z % 1.0f);
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.setShaderFogStart((float)-8.0f);
                RenderSystem.setShaderFogEnd((float)24.0f);
                RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
            }
        }, new Holder[]{MSFluids.WATER_COLORS_TYPE});
        event.registerFluidType(ClientProxy.commonFluidExtension(MSFluids.ENDER_TYPE.getId(), new Vector3f(0.0f, 0.35f, 0.35f), Float.MAX_VALUE), new Holder[]{MSFluids.ENDER_TYPE});
        event.registerFluidType(ClientProxy.commonFluidExtension(MSFluids.CAULK_TYPE.getId(), new Vector3f(0.79f, 0.74f, 0.63f), 0.8f), new Holder[]{MSFluids.CAULK_TYPE});
        event.registerFluidType(ClientProxy.commonFluidExtension(MSFluids.MOLTEN_AMBER_TYPE.getId(), new Vector3f(2.21f, 1.29f, 0.0f), 0.9f), new Holder[]{MSFluids.MOLTEN_AMBER_TYPE});
        for (final DeferredItem armorItem : Arrays.asList(MSItems.PROSPIT_CIRCLET, MSItems.PROSPIT_SHIRT, MSItems.PROSPIT_PANTS, MSItems.PROSPIT_SHOES, MSItems.DERSE_CIRCLET, MSItems.DERSE_SHIRT, MSItems.DERSE_PANTS, MSItems.DERSE_SHOES, MSItems.AMPHIBEANIE, MSItems.NOSTRILDAMUS, MSItems.PONYTAIL, MSItems.CRUMPLY_HAT)) {
            event.registerItem(new IClientItemExtensions(){

                @NotNull
                public HumanoidModel<?> getHumanoidArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
                    ArmorItem.Type type = ((MSArmorItem)((Object)armorItem.get())).getType();
                    if (equipmentSlot != type.getSlot()) {
                        return original;
                    }
                    HumanoidModel<?> model = ArmorModels.get((Item)armorItem.get());
                    if (model == null) {
                        return original;
                    }
                    model.rightLeg.visible = type == ArmorItem.Type.LEGGINGS || type == ArmorItem.Type.BOOTS;
                    model.leftLeg.visible = type == ArmorItem.Type.LEGGINGS || type == ArmorItem.Type.BOOTS;
                    model.body.visible = type == ArmorItem.Type.CHESTPLATE;
                    model.leftArm.visible = type == ArmorItem.Type.CHESTPLATE;
                    model.rightArm.visible = type == ArmorItem.Type.CHESTPLATE;
                    model.head.visible = type == ArmorItem.Type.HELMET;
                    model.hat.visible = type == ArmorItem.Type.HELMET;
                    model.crouching = original.crouching;
                    model.riding = original.riding;
                    model.young = original.young;
                    model.rightArmPose = original.rightArmPose;
                    model.leftArmPose = original.leftArmPose;
                    return model;
                }
            }, new Holder[]{armorItem});
        }
    }

    private static IClientFluidTypeExtensions commonFluidExtension(final ResourceLocation baseId, final Vector3f fogColor, final float fogDensity) {
        return new IClientFluidTypeExtensions(){
            private final ResourceLocation stillTexture;
            private final ResourceLocation flowingTexture;
            {
                this.stillTexture = baseId.withPrefix("block/still_");
                this.flowingTexture = baseId.withPrefix("block/flowing_");
            }

            public ResourceLocation getStillTexture() {
                return this.stillTexture;
            }

            public ResourceLocation getFlowingTexture() {
                return this.flowingTexture;
            }

            public Vector3f modifyFogColor(Camera camera, float partialTick, ClientLevel level, int renderDistance, float darkenWorldAmount, Vector3f fluidFogColor) {
                return fogColor;
            }

            public void modifyFogRender(Camera camera, FogRenderer.FogMode mode, float renderDistance, float partialTick, float nearDistance, float farDistance, FogShape shape) {
                RenderSystem.setShaderFogStart((float)-8.0f);
                RenderSystem.setShaderFogEnd((float)(4.8f / fogDensity));
                RenderSystem.setShaderFogShape((FogShape)FogShape.SPHERE);
            }
        };
    }

    @Nullable
    public static Player getClientPlayer() {
        Minecraft mc = Minecraft.getInstance();
        return mc.player;
    }
}

