/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client;

import com.mraof.minestuck.block.MSBlocks;
import com.mraof.minestuck.client.renderer.BlockColorCruxite;
import com.mraof.minestuck.entity.FrogEntity;
import com.mraof.minestuck.item.FrogItem;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.FrogTraitsComponent;
import com.mraof.minestuck.item.components.MSItemComponents;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StemBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterColorHandlersEvent;

@EventBusSubscriber(modid="minestuck", bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public final class ColorHandler {
    @SubscribeEvent
    public static void onItemColors(RegisterColorHandlersEvent.Item event) {
        event.register((stack, tintIndex) -> BlockColorCruxite.handleColorTint(com.mraof.minestuck.util.ColorHandler.getColorFromStack(stack), tintIndex), new ItemLike[]{(ItemLike)MSBlocks.CRUXITE_DOWEL.get(), (ItemLike)MSItems.CRUXITE_APPLE.get(), (ItemLike)MSItems.CRUXITE_POTION.get()});
        event.register((ItemColor)new FrogItemColor(), new ItemLike[]{(ItemLike)MSItems.FROG.get()});
    }

    @SubscribeEvent
    public static void initBlockColors(RegisterColorHandlersEvent.Block event) {
        event.register((BlockColor)new BlockColorCruxite(), new Block[]{(Block)MSBlocks.ALCHEMITER.TOTEM_PAD.get(), (Block)MSBlocks.TOTEM_LATHE.DOWEL_ROD.get(), (Block)MSBlocks.CRUXITE_DOWEL.get(), (Block)MSBlocks.EMERGING_CRUXITE_DOWEL.get()});
        event.register((state, worldIn, pos, tintIndex) -> ColorHandler.stemColor((Integer)state.getValue((Property)StemBlock.AGE)), new Block[]{(Block)MSBlocks.STRAWBERRY_STEM.get()});
        event.register((state, worldIn, pos, tintIndex) -> ColorHandler.stemColor(7), new Block[]{(Block)MSBlocks.ATTACHED_STRAWBERRY_STEM.get()});
    }

    public static int stemColor(int age) {
        int red = age * 32;
        int green = 255 - age * 8;
        int blue = age * 4;
        return red << 16 | green << 8 | blue;
    }

    protected static class FrogItemColor
    implements ItemColor {
        protected FrogItemColor() {
        }

        public int getColor(ItemStack stack, int tintIndex) {
            if (stack.has(MSItemComponents.FROG_TRAITS) && ((FrogTraitsComponent)stack.get(MSItemComponents.FROG_TRAITS)).variant().orElse(FrogEntity.FrogVariants.DEFAULT) == FrogEntity.FrogVariants.DEFAULT) {
                return (switch (tintIndex) {
                    case 0 -> FrogItem.getSkinColor(stack);
                    case 1 -> FrogItem.getEyeColor(stack);
                    case 2 -> FrogItem.getBellyColor(stack);
                    default -> -1;
                }) | 0xFF000000;
            }
            return -1;
        }
    }
}

