/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client;

import com.mraof.minestuck.entry.EntryBlockIterator;
import com.mraof.minestuck.network.EntryEffectPackets;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import org.joml.Vector3f;

@EventBusSubscriber(modid="minestuck", value={Dist.CLIENT})
public final class EntryEffect {
    public static final DustParticleOptions PARTICLE = new DustParticleOptions(new Vector3f(0.5f, 0.5f, 1.0f), 1.0f);
    public static final int VISIBLE_DISTANCE = 16;
    @Nullable
    private static EffectLocation location;

    public static void handlePacket(EntryEffectPackets.Effect packet) {
        location = new EffectLocation(packet.level(), packet.center(), packet.range());
    }

    public static void reset() {
        location = null;
    }

    @SubscribeEvent
    public static void onLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        EntryEffect.reset();
    }

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Pre event) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null || location == null || player.level().dimension() != location.level()) {
            return;
        }
        Level level = player.level();
        RandomSource rand = level.random;
        for (BlockPos blockPos : EntryBlockIterator.get(EntryEffect.location.center.getX(), EntryEffect.location.center.getY(), EntryEffect.location.center.getZ(), EntryEffect.location.range)) {
            if (!(player.distanceToSqr((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5) <= 256.0) || !level.getBlockState(blockPos).isAir()) continue;
            EntryEffect.particleAtPos(level, rand, blockPos);
        }
    }

    private static void particleAtPos(Level level, RandomSource rand, BlockPos pos) {
        if (rand.nextInt(200) == 0) {
            level.addParticle((ParticleOptions)PARTICLE, (double)pos.getX() + rand.nextDouble(), (double)pos.getY() + rand.nextDouble(), (double)pos.getZ() + rand.nextDouble(), rand.nextDouble() * 0.1, rand.nextDouble() * 0.1, rand.nextDouble() * 0.1);
        }
    }

    public record EffectLocation(ResourceKey<Level> level, BlockPos center, int range) {
    }
}

