/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client;

import com.mraof.minestuck.client.ClientDimensionData;
import com.mraof.minestuck.util.MSSoundEvents;
import com.mraof.minestuck.world.lands.LandTypePair;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.sound.PlaySoundEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@EventBusSubscriber(modid="minestuck", value={Dist.CLIENT})
public class MSMusicTicker {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean wasInLand = false;
    private static int ticksUntilMusic;
    private static SoundInstance currentMusic;

    @SubscribeEvent
    public static void clientTick(ClientTickEvent.Post event) {
        if (!Minecraft.getInstance().isPaused()) {
            MSMusicTicker.tick(Minecraft.getInstance());
        }
    }

    @SubscribeEvent
    public static void playSound(PlaySoundEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.level != null && ClientDimensionData.isLand((ResourceKey<Level>)mc.level.dimension()) && event.getSound().getLocation().equals((Object)((SoundEvent)mc.getSituationalMusic().getEvent().value()).getLocation())) {
            event.setSound(null);
        }
    }

    private static void tick(Minecraft mc) {
        LandTypePair types;
        LandTypePair landTypePair = types = mc.level != null ? ClientDimensionData.getLandTypes((ResourceKey<Level>)mc.level.dimension()) : null;
        if (types != null) {
            if (!wasInLand) {
                ticksUntilMusic = Mth.nextInt((RandomSource)mc.level.random, (int)0, (int)6000);
                LOGGER.debug("Entered a land. Land music scheduled to play in {} ticks", (Object)ticksUntilMusic);
            }
            if (currentMusic == null) {
                if (--ticksUntilMusic < 0) {
                    currentMusic = SimpleSoundInstance.forMusic((SoundEvent)MSMusicTicker.getLandSoundEvent(mc.level.random, types));
                    mc.getSoundManager().play(currentMusic);
                    LOGGER.debug("Land music started.");
                }
            } else if (!mc.getSoundManager().isActive(currentMusic)) {
                currentMusic = null;
                ticksUntilMusic = Mth.nextInt((RandomSource)mc.level.random, (int)12000, (int)24000);
                LOGGER.debug("Land music finished playing. Scheduling music to be played again in {} ticks.", (Object)ticksUntilMusic);
            }
            wasInLand = true;
        } else {
            wasInLand = false;
            if (currentMusic != null) {
                mc.getSoundManager().stop(currentMusic);
                currentMusic = null;
                LOGGER.debug("Left land, stopped music.");
            }
        }
    }

    private static SoundEvent getLandSoundEvent(RandomSource rand, LandTypePair pair) {
        if (rand.nextInt(5) == 0) {
            return MSSoundEvents.MUSIC_UNIVERSAL.get();
        }
        if (rand.nextBoolean()) {
            return pair.getTerrain().getBackgroundMusic();
        }
        return pair.getTitle().getBackgroundMusic();
    }
}

