/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.blockentity.machine.AlchemiterBlockEntity;
import com.mraof.minestuck.client.gui.GristSelectorScreen;
import com.mraof.minestuck.client.util.GuiUtil;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.EncodedItemComponent;
import com.mraof.minestuck.network.block.TriggerAlchemiterPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public final class AlchemiterScreen
extends Screen {
    public static final String TITLE = "minestuck.alchemiter";
    private static final ResourceLocation guiBackground = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/large_alchemiter.png");
    private static final int guiWidth = 159;
    private static final int guiHeight = 102;
    private final AlchemiterBlockEntity alchemiter;
    private int itemQuantity;

    AlchemiterScreen(AlchemiterBlockEntity be) {
        super((Component)Component.translatable((String)TITLE));
        this.alchemiter = be;
        this.itemQuantity = 1;
    }

    public AlchemiterBlockEntity getAlchemiter() {
        return this.alchemiter;
    }

    protected void init() {
        int xOffset = (this.width - 159) / 2;
        int yOffset = (this.height - 102) / 2;
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(xOffset + 29, yOffset + 110, 100, 20, (Component)Component.literal((String)"ALCHEMIZE"), button -> this.alchemize()));
        GristSet cost = this.alchemiter.getGristCost(1);
        if (cost != null && !cost.isEmpty()) {
            this.addRenderableWidget((GuiEventListener)new ExtendedButton(xOffset + 10, yOffset + 10, 18, 18, (Component)Component.literal((String)"^"), button -> this.changeAmount(100)));
            this.addRenderableWidget((GuiEventListener)new ExtendedButton(xOffset + 31, yOffset + 10, 18, 18, (Component)Component.literal((String)"^"), button -> this.changeAmount(10)));
            this.addRenderableWidget((GuiEventListener)new ExtendedButton(xOffset + 52, yOffset + 10, 18, 18, (Component)Component.literal((String)"^"), button -> this.changeAmount(1)));
            this.addRenderableWidget((GuiEventListener)new ExtendedButton(xOffset + 10, yOffset + 74, 18, 18, (Component)Component.literal((String)"v"), button -> this.changeAmount(-100)));
            this.addRenderableWidget((GuiEventListener)new ExtendedButton(xOffset + 31, yOffset + 74, 18, 18, (Component)Component.literal((String)"v"), button -> this.changeAmount(-10)));
            this.addRenderableWidget((GuiEventListener)new ExtendedButton(xOffset + 52, yOffset + 74, 18, 18, (Component)Component.literal((String)"v"), button -> this.changeAmount(-1)));
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int xOffset = (this.width - 159) / 2;
        int yOffset = (this.height - 102) / 2;
        guiGraphics.blit(guiBackground, xOffset, yOffset, 0, 0, 159, 102);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, Integer.toString((int)((double)this.itemQuantity / Math.pow(10.0, 2.0)) % 10), (float)(this.width - 159) / 2.0f + 15.0f, (float)(this.height - 102) / 2.0f + 46.0f, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, Integer.toString((int)((double)this.itemQuantity / Math.pow(10.0, 1.0)) % 10), (float)(this.width - 159) / 2.0f + 36.0f, (float)(this.height - 102) / 2.0f + 46.0f, 0xFFFFFF, false);
        guiGraphics.drawString(this.font, Integer.toString((int)((double)this.itemQuantity / Math.pow(10.0, 0.0)) % 10), (float)(this.width - 159) / 2.0f + 57.0f, (float)(this.height - 102) / 2.0f + 46.0f, 0xFFFFFF, false);
        GristSet set = this.alchemiter.getGristCost(this.itemQuantity);
        GuiUtil.GristboardMode boardMode = EncodedItemComponent.getEncodedOrBlank(this.alchemiter.getDowel()).is(MSItems.CAPTCHA_CARD) ? GuiUtil.GristboardMode.LARGE_ALCHEMITER_SELECT : GuiUtil.GristboardMode.LARGE_ALCHEMITER;
        GuiUtil.drawGristBoard(guiGraphics, set, boardMode, (this.width - 159) / 2 + 88, (this.height - 102) / 2 + 13, this.font);
        Component tooltip = GuiUtil.getGristboardTooltip(set, GuiUtil.GristboardMode.LARGE_ALCHEMITER, mouseX, mouseY, 9, 45, this.font);
        if (tooltip != null) {
            guiGraphics.renderTooltip(this.font, tooltip, mouseX, mouseY);
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    private void alchemize() {
        PacketDistributor.sendToServer((CustomPacketPayload)new TriggerAlchemiterPacket(this.itemQuantity, this.alchemiter.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.minecraft.setScreen(null);
    }

    private void changeAmount(int change) {
        int result = this.itemQuantity + change;
        int maxCount = Math.min(999, this.alchemiter.getOutput().getMaxStackSize() * (Integer)MinestuckConfig.SERVER.alchemiterMaxStacks.get());
        this.itemQuantity = Mth.clamp((int)result, (int)1, (int)maxCount);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        float xOffset = (float)(this.width - 159) / 2.0f;
        float yOffset = (float)(this.height - 102) / 2.0f;
        if (mouseButton == 0 && !this.alchemiter.getDowel().isEmpty() && EncodedItemComponent.getEncodedOrBlank(this.alchemiter.getDowel()).is(MSItems.CAPTCHA_CARD) && (double)(xOffset + 80.0f) <= mouseX && mouseX < (double)(xOffset + 150.0f) && (double)(yOffset + 8.0f) <= mouseY && mouseY < (double)(yOffset + 93.0f)) {
            this.minecraft.pushGuiLayer((Screen)new GristSelectorScreen(this.getAlchemiter().getBlockPos()));
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }
}

