/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.api.alchemy.GristAmount;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.blockentity.machine.AnthvilBlockEntity;
import com.mraof.minestuck.client.gui.MachineScreen;
import com.mraof.minestuck.client.util.GuiUtil;
import com.mraof.minestuck.inventory.AnthvilMenu;
import com.mraof.minestuck.network.block.TriggerAnthvilPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class AnthvilScreen
extends AbstractContainerScreen<AnthvilMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/anthvil.png");
    private static final ResourceLocation FUEL_STATUS = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/progress/uranium_level.png");
    private static final int FUEL_STATUS_X = 133;
    private static final int FUEL_STATUS_Y = 7;
    private static final int STATUS_WIDTH = 35;
    private static final int STATUS_HEIGHT = 39;
    private static final int BUTTON_X = 12;
    private static final int BUTTON_Y = 38;
    private final AnthvilMenu screenContainer;

    AnthvilScreen(AnthvilMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.screenContainer = screenContainer;
    }

    public void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.leftPos + 12, this.topPos + 38, 30, 12, (Component)Component.literal((String)"MEND"), button -> this.mend()));
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.leftPos + 12, this.topPos + 38 + 16, 30, 12, (Component)Component.literal((String)"DONE"), button -> this.finish()));
    }

    private void mend() {
        PacketDistributor.sendToServer((CustomPacketPayload)new TriggerAnthvilPacket(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void finish() {
        this.onClose();
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        ItemStack stack;
        GristSet fullSet;
        super.render(graphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(graphics, mouseX, mouseY);
        if (this.minecraft != null && this.minecraft.level != null && (fullSet = GristCostRecipe.findCostForItem(stack = this.screenContainer.getSlot(0).getItem(), null, false, (Level)this.minecraft.level)) != null && !fullSet.isEmpty()) {
            GristAmount pickedGrist = AnthvilBlockEntity.getUsedGrist(fullSet);
            GuiUtil.drawGristBoard(graphics, pickedGrist, GuiUtil.GristboardMode.ALCHEMITER, (this.width - this.leftPos) / 2 - 4, (this.height - this.topPos) / 2 - 48, this.font, 2.0f);
            Component tooltip = GuiUtil.getGristboardTooltip(pickedGrist, GuiUtil.GristboardMode.ALCHEMITER, mouseX, mouseY, (this.width - this.leftPos) / 2 - 4, (this.height - this.topPos) / 2 - 48, this.font, 2.0f);
            if (tooltip != null) {
                graphics.renderTooltip(this.font, tooltip, mouseX, mouseY);
            }
        }
    }

    protected void renderLabels(GuiGraphics graphics, int mouseX, int mouseY) {
        graphics.drawString(this.font, this.title, 8, 6, 0x404040, false);
        graphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    protected void renderBg(GuiGraphics graphics, float par1, int par2, int par3) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int fuelHeight = MachineScreen.getScaledValue(((AnthvilMenu)this.menu).getFuel(), 128, 39);
        graphics.blit(FUEL_STATUS, this.leftPos + 133, this.topPos + 7 + 39 - fuelHeight, 0.0f, (float)(39 - fuelHeight), 35, fuelHeight, 35, 39);
    }
}

