/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mraof.minestuck.block.redstone.AreaEffectBlock;
import com.mraof.minestuck.blockentity.redstone.AreaEffectBlockEntity;
import com.mraof.minestuck.network.block.AreaEffectSettingsPacket;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class AreaEffectScreen
extends Screen {
    public static final String TITLE = "minestuck.area_effect";
    public static final String MIN_POS_MESSAGE = "minestuck.area_effect.min_pose_message";
    public static final String MAX_POS_MESSAGE = "minestuck.area_effect.max_pose_message";
    public static final String X_MIN_MESSAGE = "minestuck.area_effect.x_min_message";
    public static final String Y_MIN_MESSAGE = "minestuck.area_effect.Y_min_message";
    public static final String Z_MIN_MESSAGE = "minestuck.area_effect.z_min_message";
    public static final String X_MAX_MESSAGE = "minestuck.area_effect.x_max_message";
    public static final String Y_MAX_MESSAGE = "minestuck.area_effect.y_max_message";
    public static final String Z_MAX_MESSAGE = "minestuck.area_effect.z_max_message";
    public static final String CURRENT_EFFECT_MESSAGE = "minestuck.area_effect.current_effect";
    public static final String CURRENT_EFFECT_AMPLIFIER_MESSAGE = "minestuck.area_effect.current_effect_amplifier";
    public static final String DONE_MESSAGE = "minestuck.area_effect.done";
    public static final String ALL_MOBS_MESSAGE = "minestuck.area_effect.all_mobs";
    public static final String JUST_PLAYERS_MESSAGE = "minestuck.area_effect.just_players";
    private static final ResourceLocation GUI_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/generic_large.png");
    private static final int GUI_WIDTH = 150;
    private static final int GUI_HEIGHT = 132;
    private final AreaEffectBlockEntity be;
    private EditBox minPosDestinationTextFieldX;
    private EditBox minPosDestinationTextFieldY;
    private EditBox minPosDestinationTextFieldZ;
    private EditBox maxPosDestinationTextFieldX;
    private EditBox maxPosDestinationTextFieldY;
    private EditBox maxPosDestinationTextFieldZ;
    private EditBox effectTextField;
    private EditBox effectAmplifierTextField;
    private boolean isAllMobs;
    private boolean validInput = true;
    private Button allMobsButton;

    AreaEffectScreen(AreaEffectBlockEntity be) {
        super((Component)Component.translatable((String)TITLE));
        this.be = be;
        this.isAllMobs = (Boolean)be.getBlockState().getValue((Property)AreaEffectBlock.ALL_MOBS);
    }

    public void init() {
        int yOffset = this.height / 2 - 66;
        this.minPosDestinationTextFieldX = new EditBox(this.font, this.width / 2 - 60, yOffset + 15, 40, 20, (Component)Component.translatable((String)X_MIN_MESSAGE));
        this.minPosDestinationTextFieldX.setValue(String.valueOf(this.be.getMinAreaOffset().getX()));
        this.addRenderableWidget((GuiEventListener)this.minPosDestinationTextFieldX);
        this.minPosDestinationTextFieldY = new EditBox(this.font, this.width / 2 - 20, yOffset + 15, 40, 20, (Component)Component.translatable((String)Y_MIN_MESSAGE));
        this.minPosDestinationTextFieldY.setValue(String.valueOf(this.be.getMinAreaOffset().getY()));
        this.addRenderableWidget((GuiEventListener)this.minPosDestinationTextFieldY);
        this.minPosDestinationTextFieldZ = new EditBox(this.font, this.width / 2 + 20, yOffset + 15, 40, 20, (Component)Component.translatable((String)Z_MIN_MESSAGE));
        this.minPosDestinationTextFieldZ.setValue(String.valueOf(this.be.getMinAreaOffset().getZ()));
        this.addRenderableWidget((GuiEventListener)this.minPosDestinationTextFieldZ);
        this.maxPosDestinationTextFieldX = new EditBox(this.font, this.width / 2 - 60, yOffset + 50, 40, 20, (Component)Component.translatable((String)X_MAX_MESSAGE));
        this.maxPosDestinationTextFieldX.setValue(String.valueOf(this.be.getMaxAreaOffset().getX()));
        this.addRenderableWidget((GuiEventListener)this.maxPosDestinationTextFieldX);
        this.maxPosDestinationTextFieldY = new EditBox(this.font, this.width / 2 - 20, yOffset + 50, 40, 20, (Component)Component.translatable((String)Y_MAX_MESSAGE));
        this.maxPosDestinationTextFieldY.setValue(String.valueOf(this.be.getMaxAreaOffset().getY()));
        this.addRenderableWidget((GuiEventListener)this.maxPosDestinationTextFieldY);
        this.maxPosDestinationTextFieldZ = new EditBox(this.font, this.width / 2 + 20, yOffset + 50, 40, 20, (Component)Component.translatable((String)Z_MAX_MESSAGE));
        this.maxPosDestinationTextFieldZ.setValue(String.valueOf(this.be.getMaxAreaOffset().getZ()));
        this.addRenderableWidget((GuiEventListener)this.maxPosDestinationTextFieldZ);
        this.effectTextField = new EditBox(this.font, this.width / 2 - 65, yOffset + 79, 105, 18, (Component)Component.translatable((String)CURRENT_EFFECT_MESSAGE));
        this.effectTextField.setValue(String.valueOf(BuiltInRegistries.MOB_EFFECT.getKey((Object)this.be.getEffect())));
        this.addRenderableWidget((GuiEventListener)this.effectTextField);
        this.effectAmplifierTextField = new EditBox(this.font, this.width / 2 + 45, yOffset + 79, 20, 18, (Component)Component.translatable((String)CURRENT_EFFECT_AMPLIFIER_MESSAGE));
        this.effectAmplifierTextField.setValue(String.valueOf(this.be.getEffectAmplifier()));
        this.addRenderableWidget((GuiEventListener)this.effectAmplifierTextField);
        this.allMobsButton = new ExtendedButton(this.width / 2 - 65, yOffset + 105, 85, 20, this.getAllMobsButtonMessage(), button -> this.cycleIsAllMobs());
        this.addRenderableWidget((GuiEventListener)this.allMobsButton);
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 2 + 25, yOffset + 105, 40, 20, (Component)Component.translatable((String)DONE_MESSAGE), button -> this.finish()));
    }

    private Component getAllMobsButtonMessage() {
        return this.isAllMobs ? Component.translatable((String)ALL_MOBS_MESSAGE) : Component.translatable((String)JUST_PLAYERS_MESSAGE);
    }

    private void cycleIsAllMobs() {
        this.isAllMobs = !this.isAllMobs;
        this.allMobsButton.setMessage(this.getAllMobsButtonMessage());
    }

    @Nullable
    private Holder<MobEffect> getEffect(String stringInput) {
        return ResourceLocation.read((String)stringInput).result().flatMap(arg_0 -> ((Registry)BuiltInRegistries.MOB_EFFECT).getHolder(arg_0)).orElse(null);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int yOffset = this.height / 2 - 66;
        guiGraphics.blit(GUI_BACKGROUND, this.width / 2 - 75, yOffset, 0, 0, 150, 132);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int yOffset = this.height / 2 - 66;
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)MIN_POS_MESSAGE), this.width / 2 - this.font.width((FormattedText)Component.translatable((String)MIN_POS_MESSAGE)) / 2, yOffset + 5, 0x404040, false);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)MAX_POS_MESSAGE), this.width / 2 - this.font.width((FormattedText)Component.translatable((String)MAX_POS_MESSAGE)) / 2, yOffset + 40, 0x404040, false);
    }

    private void finish() {
        this.validInput = true;
        int minX = this.parseInt(this.minPosDestinationTextFieldX);
        int minY = this.parseInt(this.minPosDestinationTextFieldY);
        int minZ = this.parseInt(this.minPosDestinationTextFieldZ);
        int maxX = this.parseInt(this.maxPosDestinationTextFieldX);
        int maxY = this.parseInt(this.maxPosDestinationTextFieldY);
        int maxZ = this.parseInt(this.maxPosDestinationTextFieldZ);
        BlockPos minOffsetPos = new BlockPos(minX, minY, minZ);
        BlockPos maxOffsetPos = new BlockPos(maxX, maxY, maxZ);
        Holder<MobEffect> effect = this.getEffect(this.effectTextField.getValue());
        if (this.validInput && effect != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new AreaEffectSettingsPacket(effect, Mth.clamp((int)this.parseInt(this.effectAmplifierTextField), (int)0, (int)255), this.isAllMobs, minOffsetPos, maxOffsetPos, this.be.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.onClose();
        }
    }

    private int parseInt(EditBox widget) {
        int parsedValue = 0;
        try {
            parsedValue = Integer.parseInt(widget.getValue());
            widget.setTextColor(0xFFFFFF);
        }
        catch (NumberFormatException ignored) {
            this.validInput = false;
            widget.setTextColor(0xFF0000);
        }
        return parsedValue;
    }
}

