/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mraof.minestuck.blockentity.redstone.BlockTeleporterBlockEntity;
import com.mraof.minestuck.network.block.BlockTeleporterSettingsPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class BlockTeleporterScreen
extends Screen {
    public static final String TITLE = "minestuck.block_teleporter";
    public static final String X_MESSAGE = "minestuck.block_teleporter.x_message";
    public static final String Y_MESSAGE = "minestuck.block_teleporter.y_message";
    public static final String Z_MESSAGE = "minestuck.block_teleporter.z_message";
    public static final String DONE_MESSAGE = "minestuck.block_teleporter.done";
    private static final ResourceLocation GUI_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/generic_medium.png");
    private static final int GUI_WIDTH = 150;
    private static final int GUI_HEIGHT = 98;
    private final BlockTeleporterBlockEntity be;
    private EditBox xPosOffsetTextField;
    private EditBox yPosOffsetTextField;
    private EditBox zPosOffsetTextField;
    private boolean validInput = true;

    BlockTeleporterScreen(BlockTeleporterBlockEntity be) {
        super((Component)Component.translatable((String)TITLE));
        this.be = be;
    }

    public void init() {
        int yOffset = this.height / 2 - 49;
        this.xPosOffsetTextField = new EditBox(this.font, this.width / 2 - 60, yOffset + 15, 40, 20, (Component)Component.translatable((String)X_MESSAGE));
        this.xPosOffsetTextField.setValue(String.valueOf(this.be.getTeleportOffset().getX()));
        this.addRenderableWidget((GuiEventListener)this.xPosOffsetTextField);
        this.yPosOffsetTextField = new EditBox(this.font, this.width / 2 - 20, yOffset + 15, 40, 20, (Component)Component.translatable((String)Y_MESSAGE));
        this.yPosOffsetTextField.setValue(String.valueOf(this.be.getTeleportOffset().getY()));
        this.addRenderableWidget((GuiEventListener)this.yPosOffsetTextField);
        this.zPosOffsetTextField = new EditBox(this.font, this.width / 2 + 20, yOffset + 15, 40, 20, (Component)Component.translatable((String)Z_MESSAGE));
        this.zPosOffsetTextField.setValue(String.valueOf(this.be.getTeleportOffset().getZ()));
        this.addRenderableWidget((GuiEventListener)this.zPosOffsetTextField);
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 2 - 20, yOffset + 70, 40, 20, (Component)Component.translatable((String)DONE_MESSAGE), button -> this.finish()));
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int yOffset = this.height / 2 - 49;
        guiGraphics.blit(GUI_BACKGROUND, this.width / 2 - 75, yOffset, 0, 0, 150, 98);
    }

    private void finish() {
        int x = this.parseInt(this.xPosOffsetTextField);
        int y = this.parseInt(this.yPosOffsetTextField);
        int z = this.parseInt(this.zPosOffsetTextField);
        BlockPos offsetPos = new BlockPos(x, y, z);
        if (this.validInput) {
            PacketDistributor.sendToServer((CustomPacketPayload)new BlockTeleporterSettingsPacket(offsetPos, this.be.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.onClose();
        }
        this.validInput = true;
    }

    private int parseInt(EditBox widget) {
        int parsedValue = 0;
        try {
            parsedValue = Integer.parseInt(widget.getValue());
            widget.setTextColor(0xFFFFFF);
        }
        catch (NumberFormatException ignored) {
            this.validInput = false;
            widget.setTextColor(0xFF0000);
        }
        return parsedValue;
    }
}

