/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.client.gui.computer.ComputerScreen;
import com.mraof.minestuck.player.ClientPlayerData;
import com.mraof.minestuck.util.ColorHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.client.gui.widget.ExtendedSlider;

@ParametersAreNonnullByDefault
public class ColorSelectorScreen
extends Screen {
    public static final String TITLE = "minestuck.color_selector";
    public static final String ADVANCED_TAB = "minestuck.color_selector.advanced_tab";
    public static final String BASIC_TAB = "minestuck.color_selector.basic_tab";
    public static final String CHOOSE_MESSAGE = "minestuck.color_selector.choose";
    public static final String SELECT_COLOR = "minestuck.color_selector.select_color";
    public static final String COLOR_SELECTED = "minestuck.color_selector.color_selected";
    public static final String DEFAULT_COLOR_SELECTED = "minestuck.color_selector.default_color_selected";
    private static final ResourceLocation guiBackground = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/color_selector.png");
    private static final int guiWidth = 176;
    private static final int guiHeight = 157;
    private static final List<ColorSelector> canonColors = new ArrayList<ColorSelector>();
    private static int xOffset;
    private static int yOffset;
    private final boolean firstTime;
    private int selectedIndex = -1;
    private ExtendedSlider redSlider;
    private ExtendedSlider greenSlider;
    private ExtendedSlider blueSlider;
    private ExtendedButton tabButton;
    private EditBox hexBox;
    private Tab tab = Tab.Canon;
    @Nullable
    private ComputerBlockEntity be;

    public ColorSelectorScreen(boolean firstTime) {
        super((Component)Component.translatable((String)TITLE));
        this.firstTime = firstTime;
        for (ColorSelector colorSelector : canonColors) {
            if (ClientPlayerData.getPlayerColor() != colorSelector.getColor()) continue;
            this.selectedIndex = colorSelector.id;
        }
    }

    public ColorSelectorScreen(ComputerBlockEntity blockEntity) {
        super((Component)Component.translatable((String)TITLE));
        this.firstTime = false;
        this.be = blockEntity;
        for (ColorSelector colorSelector : canonColors) {
            if (ClientPlayerData.getPlayerColor() != colorSelector.getColor()) continue;
            this.selectedIndex = colorSelector.id;
        }
    }

    public void init() {
        xOffset = (this.width - 176) / 2;
        yOffset = (this.height - 157) / 2;
        this.redSlider = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)new ColorSlider(ColorSlider.ColorComp.R));
        this.greenSlider = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)new ColorSlider(ColorSlider.ColorComp.G));
        this.blueSlider = (ExtendedSlider)this.addRenderableWidget((GuiEventListener)new ColorSlider(ColorSlider.ColorComp.B));
        this.hexBox = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.minecraft.font, xOffset + 23, yOffset + 109, 80, 15, (Component)Component.empty()));
        this.hexBox.setResponder(this::onBoxUpdate);
        this.hexBox.setFilter(text -> Pattern.matches("^[0-9a-fA-F]+$", text) || text.isEmpty());
        this.hexBox.setMaxLength(6);
        this.tabButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton(xOffset + 20, yOffset + 130, 65, 20, (Component)Component.translatable((String)ADVANCED_TAB), button -> this.setTab(this.tab == Tab.RGB ? Tab.Canon : Tab.RGB)));
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(xOffset + 91, yOffset + 130, 65, 20, (Component)Component.translatable((String)CHOOSE_MESSAGE), button -> this.selectColor()));
        this.setTab(this.tab);
    }

    public void resize(Minecraft mc, int width, int height) {
        String hexPrev = this.hexBox.getValue();
        double redPrev = this.redSlider.getValue();
        double greenPrev = this.greenSlider.getValue();
        double bluePrev = this.blueSlider.getValue();
        super.resize(mc, width, height);
        this.redSlider.setValue(redPrev);
        this.greenSlider.setValue(greenPrev);
        this.blueSlider.setValue(bluePrev);
        this.hexBox.setValue(hexPrev);
    }

    private int getPlayerColorComponent(int comp) {
        return ClientPlayerData.getPlayerColor() >> comp * 8 & 0xFF;
    }

    private void setTab(Tab tab) {
        this.tab = tab;
        this.hexBox.visible = tab == Tab.RGB;
        this.blueSlider.visible = this.hexBox.visible;
        this.greenSlider.visible = this.hexBox.visible;
        this.redSlider.visible = this.hexBox.visible;
        if (tab == Tab.RGB && this.selectedIndex != -1) {
            int color = ColorHandler.BuiltinColors.getColor(this.selectedIndex);
            this.redSlider.setValue((double)(color >> 16 & 0xFF));
            this.greenSlider.setValue((double)(color >> 8 & 0xFF));
            this.blueSlider.setValue((double)(color & 0xFF));
            this.hexBox.setValue(ColorSelectorScreen.toFormattedHex(color));
        } else if (tab == Tab.RGB) {
            this.hexBox.setValue(ColorSelectorScreen.toFormattedHex(this.getSlidersValue()));
        }
        this.tabButton.setMessage((Component)(tab == Tab.RGB ? Component.translatable((String)BASIC_TAB) : Component.translatable((String)ADVANCED_TAB)));
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.blit(guiBackground, xOffset, yOffset, 0, 0, 176, 157);
        if (this.tab == Tab.RGB) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.blit(guiBackground, xOffset + 20, yOffset + 31, 0, 157, 138, 98);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        String cacheMessage = I18n.get((String)SELECT_COLOR, (Object[])new Object[0]);
        guiGraphics.drawString(this.font, cacheMessage, (float)this.width / 2.0f - (float)this.font.width(cacheMessage) / 2.0f, (float)(yOffset + 12), 0x404040, false);
        if (this.tab == Tab.RGB) {
            RenderSystem.setShaderColor((float)((float)this.redSlider.getValue() / 255.0f), (float)((float)this.greenSlider.getValue() / 255.0f), (float)((float)this.blueSlider.getValue() / 255.0f), (float)0.5f);
            guiGraphics.blit(guiBackground, xOffset + 106, yOffset + 57, 47, 47, 176.0f, 20.0f, 64, 64, 256, 256);
        } else {
            for (ColorSelector canonColor : canonColors) {
                canonColor.draw(guiGraphics);
                if (this.selectedIndex != canonColor.id) continue;
                this.drawSelectionBox(guiGraphics, canonColor);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.tab == Tab.Canon) {
            for (ColorSelector canonColor : canonColors) {
                if (!canonColor.pointWithin(mouseX, mouseY)) continue;
                guiGraphics.renderTooltip(this.font, canonColor.getName(), mouseX, mouseY);
            }
        }
    }

    private void drawSelectionBox(GuiGraphics guiGraphics, ColorSelector canonColor) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(guiBackground, xOffset + canonColor.x - 2, yOffset + canonColor.y - 2, 176, 0, 36, 20);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0 && this.tab == Tab.Canon) {
            for (ColorSelector canonColor : canonColors) {
                if (!canonColor.pointWithin(mouseX, mouseY)) continue;
                this.selectedIndex = this.selectedIndex != canonColor.id ? canonColor.id : -1;
                return true;
            }
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private int getSlidersValue() {
        return this.redSlider.getValueInt() << 16 | this.greenSlider.getValueInt() << 8 | this.blueSlider.getValueInt();
    }

    private static String toFormattedHex(int color) {
        return String.format("%6s", Integer.toHexString(color)).replace(' ', '0');
    }

    private void onBoxUpdate(String hex) {
        if (hex.length() != 6) {
            return;
        }
        this.redSlider.setValue((double)Integer.parseInt(hex.substring(0, 2), 16));
        this.greenSlider.setValue((double)Integer.parseInt(hex.substring(2, 4), 16));
        this.blueSlider.setValue((double)Integer.parseInt(hex.substring(4, 6), 16));
    }

    private void selectColor() {
        if (this.tab != Tab.RGB) {
            ClientPlayerData.selectColor(this.selectedIndex);
        } else if (this.hexBox.getValue().length() != 6) {
            ClientPlayerData.selectColorRGB(this.getSlidersValue());
        } else {
            ClientPlayerData.selectColorRGB(Integer.parseInt(this.hexBox.getValue(), 16));
        }
        if (this.be != null) {
            this.minecraft.setScreen((Screen)new ComputerScreen(this.minecraft, this.be));
        } else {
            this.onClose();
        }
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            if (this.be != null) {
                this.minecraft.setScreen((Screen)new ComputerScreen(this.minecraft, this.be));
            } else {
                this.onClose();
            }
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void removed() {
        if (this.firstTime && this.minecraft != null && this.minecraft.player != null) {
            this.minecraft.player.sendSystemMessage((Component)Component.literal((String)"[Minestuck] ").append((Component)(ClientPlayerData.getPlayerColor() == 10542335 ? Component.translatable((String)DEFAULT_COLOR_SELECTED) : Component.translatable((String)COLOR_SELECTED))));
        }
    }

    static {
        int i = 0;
        int offset = 0;
        for (int yIndex = 0; yIndex < 5; ++yIndex) {
            if (yIndex == 1) {
                offset += 3;
            }
            if (yIndex == 2) {
                offset += 3;
            }
            for (int xIndex = 0; xIndex < 4; ++xIndex) {
                canonColors.add(new ColorSelector(21 + 34 * xIndex, 32 + 18 * yIndex + offset, i++));
            }
        }
    }

    private static enum Tab {
        Canon,
        RGB;

    }

    private record ColorSelector(int x, int y, int id) {
        public static final int WIDTH = 32;
        public static final int HEIGHT = 16;

        public Component getName() {
            return ColorHandler.BuiltinColors.getName(this.id);
        }

        public int getColor() {
            return ColorHandler.BuiltinColors.getColor(this.id);
        }

        public void draw(GuiGraphics guiGraphics) {
            guiGraphics.fill(xOffset + this.x, yOffset + this.y, xOffset + this.x + 32, yOffset + this.y + 16, ColorHandler.BuiltinColors.getColor(this.id) | 0xFF000000);
        }

        public boolean pointWithin(double mouseX, double mouseY) {
            return mouseX >= (double)(this.x + xOffset) && mouseX < (double)(this.x + 32 + xOffset) && mouseY >= (double)(this.y + yOffset) && mouseY < (double)(this.y + 16 + yOffset);
        }
    }

    private class ColorSlider
    extends ExtendedSlider {
        ColorComp color;

        public ColorSlider(ColorComp color) {
            super(xOffset + 23, yOffset + color.yBonus, 80, 20, color.prefix, (Component)Component.empty(), 0.0, 255.0, (double)ColorSelectorScreen.this.getPlayerColorComponent(color.ordinal()), true);
            this.color = color;
        }

        protected void applyValue() {
            String hex = ColorSelectorScreen.toFormattedHex(ColorSelectorScreen.this.getSlidersValue());
            if (!ColorSelectorScreen.this.hexBox.getValue().equalsIgnoreCase(hex)) {
                ColorSelectorScreen.this.hexBox.setValue(hex);
            }
        }

        public static enum ColorComp {
            R(34, (Component)Component.literal((String)"r: ").withStyle(ChatFormatting.RED)),
            G(59, (Component)Component.literal((String)"g: ").withStyle(ChatFormatting.GREEN)),
            B(84, (Component)Component.literal((String)"b: ").withStyle(ChatFormatting.BLUE));

            public final int yBonus;
            public final Component prefix;

            private ColorComp(int yBonus, Component prefix) {
                this.yBonus = yBonus;
                this.prefix = prefix;
            }
        }
    }
}

