/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import java.util.List;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;

@MethodsReturnNonnullByDefault
public class DialogueButton
extends Button {
    public static final int TEXT_SPACING = 9;
    public static final int NORMAL_DEFAULT_HEIGHT = 17;
    private final ResourceLocation gui;
    private final boolean isResponse;
    private final List<FormattedCharSequence> messageLines;
    public final int trueHeight;
    public boolean wasHoveredOrFocused = false;

    public DialogueButton(ResourceLocation gui, boolean isResponse, int xPos, int yPos, int width, int defaultHeight, Component displayString, Button.OnPress handler) {
        super(xPos, yPos, width, defaultHeight, displayString, handler, DEFAULT_NARRATION);
        this.gui = gui;
        this.isResponse = isResponse;
        Minecraft mc = Minecraft.getInstance();
        this.messageLines = mc.font.split((FormattedText)this.getMessage(), this.width - 12);
        this.trueHeight = defaultHeight + (this.messageLines.size() - 1) * 9;
    }

    protected boolean clicked(double pMouseX, double pMouseY) {
        return this.activeAndVisible() && this.mouseOvertop(pMouseX, pMouseY);
    }

    public boolean isMouseOver(double pMouseX, double pMouseY) {
        return this.activeAndVisible() && this.mouseOvertop(pMouseX, pMouseY);
    }

    private boolean mouseOvertop(double pMouseX, double pMouseY) {
        return pMouseX >= (double)this.getX() && pMouseY >= (double)this.getY() && pMouseX < (double)(this.getX() + this.width) && pMouseY < (double)(this.getY() + this.trueHeight);
    }

    private boolean activeAndVisible() {
        return this.active && this.visible;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int hoverFocusShift;
        int k;
        this.isHovered = this.mouseOvertop(mouseX, mouseY);
        Minecraft mc = Minecraft.getInstance();
        boolean hoveredOrFocused = this.isHoveredOrFocused();
        int n = !this.active ? 0 : (k = hoveredOrFocused ? 2 : 1);
        int n2 = this.isResponse ? (hoveredOrFocused ? 7 : 0) : (hoverFocusShift = 0);
        if (hoveredOrFocused && !this.wasHoveredOrFocused && this.active) {
            Minecraft.getInstance().player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.2f, 2.0f);
        }
        this.wasHoveredOrFocused = this.isMouseOver(mouseX, mouseY) || this.isFocused();
        guiGraphics.blitWithBorder(this.gui, this.getX() + hoverFocusShift, this.getY(), 0, 176 + k * 20, this.width, this.trueHeight, 200, 20, 3, 3, 3, 3);
        int textX = this.getX() + hoverFocusShift + (this.isResponse ? 12 : 4);
        int pY = this.getY() + 5;
        if (this.getMessage().getString().equals("=>")) {
            guiGraphics.drawString(mc.font, this.getMessage(), textX, pY, this.getFGColor(), false);
            return;
        }
        for (int i = 0; i < this.messageLines.size(); ++i) {
            if (this.isResponse && i == 0) {
                guiGraphics.drawString(mc.font, (Component)Component.literal((String)">"), textX - 6, pY, this.getFGColor(), false);
            }
            guiGraphics.drawString(mc.font, this.messageLines.get(i), textX, pY, this.getFGColor(), false);
            pY += 9;
        }
    }
}

