/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.client.gui.DialogueButton;
import com.mraof.minestuck.entity.dialogue.Dialogue;
import com.mraof.minestuck.entity.dialogue.DialogueAnimationData;
import com.mraof.minestuck.network.DialoguePackets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.neoforged.neoforge.network.PacketDistributor;
import software.bernie.geckolib.cache.texture.AnimatableTexture;

public class DialogueScreen
extends Screen {
    private static final int GUI_WIDTH = 224;
    private static final int GUI_HEIGHT = 176;
    private static final int BUTTON_GAP = 2;
    private final int dialogueId;
    private final Dialogue.DialogueData dialogueData;
    private final DialogueAnimationData animationData;
    private int xOffset;
    private int yOffset;
    private List<FormattedCharSequence> messageLines;
    private final List<List<DialogueButton>> responseButtonPages = new ArrayList<List<DialogueButton>>();
    private int responsePage = 0;
    private DialogueButton previousButton;
    private DialogueButton nextButton;
    private int animationTick = 0;

    DialogueScreen(int dialogueId, Dialogue.DialogueData dialogueData) {
        super((Component)Component.empty());
        this.dialogueId = dialogueId;
        this.dialogueData = dialogueData;
        this.animationData = dialogueData.animationData();
    }

    public void init() {
        this.yOffset = this.height / 2 - 88;
        this.xOffset = this.width / 2 - 112 - this.animationData.spriteWidth() / 2 - this.animationData.xOffset();
        Function<Object, Object> messageStyler = (Boolean)MinestuckConfig.CLIENT.npcDialogueTextColors.get() != false ? Function.identity() : message -> message.copy().withStyle(style -> style.withColor((TextColor)null));
        this.messageLines = this.dialogueData.messages().stream().map(messageStyler).flatMap(message -> this.font.split((FormattedText)message, 204).stream()).toList();
        this.recreateResponseButtons();
    }

    public void recreateResponseButtons() {
        this.responseButtonPages.forEach(dialogueButtons -> dialogueButtons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0)));
        this.responseButtonPages.clear();
        int startY = this.yOffset + 22 + 9 * this.messageLines.size();
        int cumulativeButtonHeight = 0;
        ArrayList<DialogueButton> pageButtons = new ArrayList<DialogueButton>();
        for (Dialogue.ResponseData data : this.dialogueData.responses()) {
            DialogueButton entryButton = new DialogueButton(this.dialogueData.guiBackground(), true, this.xOffset + 16, startY + cumulativeButtonHeight, 190, 17, data.message(), button -> this.clickResponse(data));
            int entryHeight = entryButton.trueHeight + 2;
            data.conditionFailure().ifPresent(failure -> {
                entryButton.setTooltip(Tooltip.create((Component)DialogueScreen.conditionFailMessage(failure.causes())));
                entryButton.active = false;
            });
            if ((cumulativeButtonHeight += entryHeight) > 95) {
                this.responseButtonPages.add(pageButtons);
                pageButtons = new ArrayList();
                cumulativeButtonHeight = entryHeight;
                entryButton.setY(startY);
            }
            pageButtons.add((DialogueButton)this.addRenderableWidget((GuiEventListener)entryButton));
        }
        if (!pageButtons.isEmpty()) {
            this.responseButtonPages.add(pageButtons);
        }
        this.previousButton = new DialogueButton(this.dialogueData.guiBackground(), false, this.xOffset + 112 - 21, this.yOffset + 146, 16, 16, (Component)Component.literal((String)"<"), button -> this.prevPage());
        this.nextButton = new DialogueButton(this.dialogueData.guiBackground(), false, this.xOffset + 112 + 5, this.yOffset + 146, 16, 16, (Component)Component.literal((String)">"), button -> this.nextPage());
        this.addRenderableWidget((GuiEventListener)this.nextButton);
        this.addRenderableWidget((GuiEventListener)this.previousButton);
        this.updateButtonStates();
    }

    private void prevPage() {
        --this.responsePage;
        this.updateButtonStates();
    }

    private void nextPage() {
        ++this.responsePage;
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        this.responseButtonPages.forEach(pageButtons -> pageButtons.forEach(button -> {
            button.visible = false;
        }));
        boolean hasPages = !this.responseButtonPages.isEmpty();
        boolean showButtons = hasPages && this.responsePage >= 0 && this.responsePage < this.responseButtonPages.size();
        this.previousButton.active = this.responsePage > 0;
        this.nextButton.active = this.responsePage < this.responseButtonPages.size() - 1;
        this.previousButton.visible = this.responseButtonPages.size() > 1;
        boolean bl = this.nextButton.visible = this.responseButtonPages.size() > 1;
        if (showButtons) {
            List<DialogueButton> currentPageButtons = this.responseButtonPages.get(this.responsePage);
            currentPageButtons.forEach(button -> {
                button.visible = true;
            });
        }
    }

    private static MutableComponent conditionFailMessage(Component causes) {
        return Component.literal((String)"Cannot be picked because:").append("\n").append(causes);
    }

    private void clickResponse(Dialogue.ResponseData responseData) {
        if (responseData.shouldClose()) {
            Objects.requireNonNull(this.minecraft).popGuiLayer();
        }
        PacketDistributor.sendToServer((CustomPacketPayload)new DialoguePackets.TriggerResponse(responseData.index(), this.dialogueId), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void onClose() {
        PacketDistributor.sendToServer((CustomPacketPayload)new DialoguePackets.OnCloseScreen(this.dialogueId), (CustomPacketPayload[])new CustomPacketPayload[0]);
        super.onClose();
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.blit(this.dialogueData.guiBackground(), this.xOffset, this.yOffset, 0, 0, 224, 176);
        this.renderAnimation(guiGraphics);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int pY = this.yOffset + 20;
        for (FormattedCharSequence line : this.messageLines) {
            guiGraphics.drawString(this.font, line, this.xOffset + 10, pY, 0, false);
            pY += 9;
        }
    }

    private void renderAnimation(GuiGraphics guiGraphics) {
        ResourceLocation sprite = this.animationData.getRenderPath(this.dialogueData.spriteType());
        float scale = this.animationData.scale();
        int moddedWidth = (int)((float)this.animationData.spriteWidth() * scale);
        int moddedHeight = (int)((float)this.animationData.spriteHeight() * scale);
        AnimatableTexture.setAndUpdate((ResourceLocation)sprite, (int)this.animationTick++);
        guiGraphics.blit(sprite, this.xOffset + 224 + this.animationData.xOffset(), this.height / 2 - this.animationData.spriteHeight() / 2, 0.0f, 0.0f, moddedWidth, moddedHeight, moddedWidth, moddedHeight);
    }

    public boolean isPauseScreen() {
        return false;
    }
}

