/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mraof.minestuck.client.gui.MinestuckScreen;
import com.mraof.minestuck.client.gui.playerStats.InventoryEditmodeScreen;
import com.mraof.minestuck.client.gui.playerStats.PlayerStatsScreen;
import com.mraof.minestuck.computer.editmode.ClientEditmodeData;
import com.mraof.minestuck.computer.editmode.EditmodeLocations;
import com.mraof.minestuck.network.editmode.EditmodeTeleportPacket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public final class EditmodeSettingsScreen
extends MinestuckScreen {
    public static final String TITLE = "minestuck.editmode_settings";
    public static final String EDITMODE_LOCATIONS = "minestuck.editmode_locations";
    public static final String RETURN = "minestuck.editmode_settings.return";
    public static final String INTERACTION_MODE_UNAVAILABLE = "minestuck.editmode_settings.interaction_mode_unavailable";
    public static final String NOCLIP_UNAVAILABLE = "minestuck.editmode_settings.noclip_unavailable";
    private static final ResourceLocation GUI_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/generic_extra_large.png");
    private static final ResourceLocation INTERACT_SINGLE_MODE_ICON = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/editmode/interact_single_mode.png");
    private static final ResourceLocation INTERACT_MULTIPLE_MODE_ICON = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/editmode/interact_multiple_mode.png");
    private static final ResourceLocation NOCLIP_ACTIVE_ICON = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/editmode/noclip_active.png");
    private static final ResourceLocation NOCLIP_INACTIVE_ICON = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/editmode/noclip_inactive.png");
    private static final int GUI_WIDTH = 224;
    private static final int GUI_HEIGHT = 176;
    private static final int SETTINGS_X = 169;
    private static final int SETTINGS_Y = 120;
    private static final int SETTINGS_SIZE = 16;
    private static final int INTERACT_ICON_X = 165;
    private static final int INTERACT_ICON_Y = 45;
    private static final int NOCLIP_ICON_X = 165;
    private static final int NOCLIP_ICON_Y = 85;
    private static final int TOGGLE_ICON_SIZE = 24;
    private static final int ENTRIES_PER_PAGE = 6;
    private final ResourceKey<Level> level;
    private int page = 0;
    private Button previousButton;
    private Button nextButton;
    private int xOffset;
    private int yOffset;
    private final List<Button> entryButtons = new ArrayList<Button>();

    public EditmodeSettingsScreen(Player player) {
        super((Component)Component.translatable((String)TITLE));
        this.level = player.level().dimension();
    }

    public void init() {
        super.init();
        this.yOffset = this.height / 2 - 88;
        this.xOffset = this.width / 2 - 112;
        this.previousButton = new ExtendedButton(this.xOffset + 10, this.yOffset + 25, 16, 16, (Component)Component.literal((String)"<"), button -> this.prevPage());
        this.nextButton = new ExtendedButton(this.xOffset + 35, this.yOffset + 25, 16, 16, (Component)Component.literal((String)">"), button -> this.nextPage());
        this.addRenderableWidget((GuiEventListener)this.nextButton);
        this.addRenderableWidget((GuiEventListener)this.previousButton);
        this.recreateTeleportButtons();
    }

    public void recreateTeleportButtons() {
        this.entryButtons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.entryButtons.clear();
        EditmodeLocations locations = ClientEditmodeData.getLocations();
        List locationEntries = locations == null ? Collections.emptyList() : locations.getSortedPositions(this.level, ClientEditmodeData.getClientLand());
        for (int i = 0; i < locationEntries.size(); ++i) {
            BlockPos entryPos = (BlockPos)locationEntries.get(i);
            int positionOffset = 20 * (i % 6);
            MutableComponent buttonComponent = Component.literal((String)(entryPos.getX() + " | " + entryPos.getY() + " | " + entryPos.getZ()));
            ExtendedButton entryButton = new ExtendedButton(this.xOffset + 10, this.yOffset + 45 + positionOffset, 120, 16, (Component)buttonComponent, button -> this.teleport(entryPos));
            this.entryButtons.add((Button)this.addRenderableWidget((GuiEventListener)entryButton));
        }
        this.updateButtonStates();
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(graphics, mouseX, mouseY, partialTicks);
        graphics.blit(GUI_BACKGROUND, this.xOffset, this.yOffset, 0, 0, 224, 176);
    }

    public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.render(graphics, mouseX, mouseY, partialTicks);
        graphics.drawString(this.font, this.title, this.xOffset + 10, this.yOffset + 10, 0x404040, false);
        graphics.drawString(this.font, (Component)Component.translatable((String)EDITMODE_LOCATIONS), this.xOffset + 55, this.yOffset + 30, 0x898989, false);
        graphics.blit(InventoryEditmodeScreen.SETTINGS_ICON, this.xOffset + 169, this.yOffset + 120, 16, 16, 0.0f, 0.0f, 16, 16, 16, 16);
        if (InventoryEditmodeScreen.overtopSettingsIconBounds(mouseX, mouseY, this.xOffset, this.yOffset, 169, 120)) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)RETURN), mouseX, mouseY);
        }
        graphics.blit(INTERACT_MULTIPLE_MODE_ICON, this.xOffset + 165, this.yOffset + 45, 24, 24, 0.0f, 0.0f, 24, 24, 24, 24);
        if (EditmodeSettingsScreen.overtopToggleableIconBounds(mouseX, mouseY, this.xOffset, this.yOffset, 165, 45)) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)INTERACTION_MODE_UNAVAILABLE), mouseX, mouseY);
        }
        graphics.blit(NOCLIP_INACTIVE_ICON, this.xOffset + 165, this.yOffset + 85, 24, 24, 0.0f, 0.0f, 24, 24, 24, 24);
        if (EditmodeSettingsScreen.overtopToggleableIconBounds(mouseX, mouseY, this.xOffset, this.yOffset, 165, 85)) {
            graphics.renderTooltip(this.font, (Component)Component.translatable((String)NOCLIP_UNAVAILABLE), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (InventoryEditmodeScreen.overtopSettingsIconBounds(pMouseX, pMouseY, this.xOffset, this.yOffset, 169, 120)) {
            this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            this.minecraft.setScreen(null);
            PlayerStatsScreen.editmodeTab = PlayerStatsScreen.EditmodeGuiType.DEPLOY_LIST;
            PlayerStatsScreen.openGui(true);
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    private void teleport(BlockPos pos) {
        EditmodeTeleportPacket packet = new EditmodeTeleportPacket(pos);
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void prevPage() {
        --this.page;
        this.updateButtonStates();
    }

    private void nextPage() {
        ++this.page;
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        int startElement = this.page * 6;
        this.previousButton.active = 0 < startElement;
        this.nextButton.active = startElement + 6 < this.entryButtons.size();
        for (int i = 0; i < this.entryButtons.size(); ++i) {
            Button button = this.entryButtons.get(i);
            button.visible = startElement <= i && i < startElement + 6;
        }
    }

    public static boolean overtopToggleableIconBounds(double xPos, double yPos, int xOffset, int yOffset, int ICON_X, int ICON_Y) {
        boolean inYRange = yPos >= (double)(yOffset + ICON_Y) && yPos < (double)(yOffset + ICON_Y + 24);
        boolean inXRange = xPos >= (double)(xOffset + ICON_X) && xPos < (double)(xOffset + ICON_X + 24);
        return inYRange && inXRange;
    }
}

