/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mraof.minestuck.inventory.MachineContainerMenu;
import com.mraof.minestuck.network.block.MachinePackets;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

@MethodsReturnNonnullByDefault
public class GoButton
extends ExtendedButton {
    public static final String GO = "minestuck.button.go";
    public static final String STOP = "minestuck.button.stop";
    private static final Component GO_COMPONENT = Component.translatable((String)"minestuck.button.go");
    private static final Component STOP_COMPONENT = Component.translatable((String)"minestuck.button.stop");
    private final MachineContainerMenu menu;
    private final boolean allowsLooping;

    public GoButton(int x, int y, int widthIn, int heightIn, MachineContainerMenu menu, boolean allowsLooping) {
        super(x, y, widthIn, heightIn, null, null);
        this.menu = menu;
        this.allowsLooping = allowsLooping;
    }

    public Component getMessage() {
        return this.menu.isRunning() ? STOP_COMPONENT : GO_COMPONENT;
    }

    protected boolean isValidClickButton(int mouseKey) {
        return mouseKey == 0 || mouseKey == 1 && this.allowsLooping;
    }

    public void onPress() {
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseKey) {
        if (this.active && this.visible) {
            boolean flag;
            if (this.isValidClickButton(mouseKey) && (flag = this.clicked(mouseX, mouseY))) {
                this.playDownSound(Minecraft.getInstance().getSoundManager());
                this.onClick(mouseKey);
                return true;
            }
            return false;
        }
        return false;
    }

    private void onClick(int mouseKey) {
        if (mouseKey == 0) {
            this.onRegularClick();
        } else if (mouseKey == 1 && this.allowsLooping) {
            this.onLoopClick();
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.active && this.visible && (keyCode == 257 || keyCode == 335)) {
            this.playDownSound(Minecraft.getInstance().getSoundManager());
            if (this.allowsLooping && Screen.hasShiftDown()) {
                this.onLoopClick();
            } else {
                this.onRegularClick();
            }
            return true;
        }
        return false;
    }

    private void onRegularClick() {
        PacketDistributor.sendToServer((CustomPacketPayload)new MachinePackets.SetRunning(!this.menu.isRunning()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private void onLoopClick() {
        PacketDistributor.sendToServer((CustomPacketPayload)new MachinePackets.SetLooping(!this.menu.isLooping()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

