/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.client.gui.MinestuckScreen;
import com.mraof.minestuck.network.block.SetWildcardGristPacket;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

public class GristSelectorScreen
extends MinestuckScreen {
    public static final String TITLE = "minestuck.grist_selector";
    public static final String SELECT_GRIST = "minestuck.select_grist";
    private static final ResourceLocation guiGristcache = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/grist_cache.png");
    private static final int guiWidth = 226;
    private static final int guiHeight = 190;
    private final BlockPos gristHolderPos;
    private int page = 0;
    private ExtendedButton previousButton;
    private ExtendedButton nextButton;

    public GristSelectorScreen(BlockPos gristHolderPos) {
        super((Component)Component.translatable((String)TITLE));
        this.gristHolderPos = gristHolderPos;
    }

    public void init() {
        super.init();
        int xOffset = (this.width - 226) / 2;
        int yOffset = (this.height - 190) / 2;
        this.previousButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width + 8, yOffset + 8, 16, 16, (Component)Component.literal((String)"<"), button -> this.prevPage()));
        this.nextButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton(xOffset + 226 - 24, yOffset + 8, 16, 16, (Component)Component.literal((String)">"), button -> this.nextPage()));
        this.previousButton.visible = false;
        this.nextButton.visible = GristTypes.REGISTRY.size() > 21;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int xOffset = (this.width - 226) / 2;
        int yOffset = (this.height - 190) / 2;
        guiGraphics.blit(guiGristcache, xOffset, yOffset, 0, 0, 226, 190);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int xOffset = (this.width - 226) / 2;
        int yOffset = (this.height - 190) / 2;
        String cacheMessage = I18n.get((String)SELECT_GRIST, (Object[])new Object[0]);
        guiGraphics.drawString(this.font, cacheMessage, (float)this.width / 2.0f - (float)this.minecraft.font.width(cacheMessage) / 2.0f, (float)(yOffset + 12), 0x404040, false);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
        this.drawGrist(guiGraphics, xOffset, yOffset, mouseX, mouseY, this.page);
    }

    public boolean mouseClicked(double xcor, double ycor, int mouseButton) {
        super.mouseClicked(xcor, ycor, mouseButton);
        if (mouseButton == 0) {
            int xOffset = (this.width - 226) / 2;
            int yOffset = (this.height - 190) / 2;
            List types = GristTypes.REGISTRY.stream().sorted().skip(this.page * 7 * 3).limit(21L).toList();
            int offset = 0;
            for (GristType type : types) {
                int column = offset % 3;
                int gristXOffset = xOffset + 21 + (66 * column - column);
                int row = offset / 3;
                int gristYOffset = yOffset + 32 + (21 * row - row);
                if (this.isPointInRegion(gristXOffset, gristYOffset, 16, 16, xcor, ycor)) {
                    this.onClose();
                    PacketDistributor.sendToServer((CustomPacketPayload)new SetWildcardGristPacket(this.gristHolderPos, type), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    return true;
                }
                ++offset;
            }
        }
        return false;
    }

    protected boolean isPointInRegion(int regionX, int regionY, int regionWidth, int regionHeight, double pointX, double pointY) {
        return pointX >= (double)regionX && pointX < (double)(regionX + regionWidth) && pointY >= (double)regionY && pointY < (double)(regionY + regionHeight);
    }

    private void prevPage() {
        if (this.page > 0) {
            --this.page;
            if (this.page == 0) {
                this.previousButton.visible = false;
            }
            this.nextButton.visible = true;
        }
    }

    private void nextPage() {
        int maxPage = (GristTypes.REGISTRY.size() - 1) / 21;
        if (this.page < maxPage) {
            ++this.page;
            if (this.page == maxPage) {
                this.nextButton.visible = false;
            }
            this.previousButton.visible = true;
        }
    }
}

