/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.blockentity.machine.GristWidgetBlockEntity;
import com.mraof.minestuck.client.gui.GoButton;
import com.mraof.minestuck.client.gui.MachineScreen;
import com.mraof.minestuck.client.util.GuiUtil;
import com.mraof.minestuck.inventory.GristWidgetMenu;
import com.mraof.minestuck.inventory.MachineContainerMenu;
import com.mraof.minestuck.player.ClientPlayerData;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
public class GristWidgetScreen
extends MachineScreen<GristWidgetMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/widget.png");
    private static final ResourceLocation PROGRESS_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/progress/widget.png");
    private static final int PROGRESS_BAR_X = 54;
    private static final int PROGRESS_BAR_Y = 23;
    private static final int PROGRESS_BAR_WIDTH = 71;
    private static final int PROGRESS_BAR_HEIGHT = 10;
    private static final int BUTTON_X = 72;
    private static final int BUTTON_Y = 31;

    public GristWidgetScreen(GristWidgetMenu screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Objects.requireNonNull(this.minecraft);
        super.renderLabels(guiGraphics, mouseX, mouseY);
        if (((GristWidgetMenu)this.menu).getSlot(0).hasItem()) {
            GristSet set = GristWidgetBlockEntity.getGristWidgetResult(((GristWidgetMenu)this.menu).getSlot(0).getItem(), (Level)this.minecraft.level);
            GuiUtil.drawGristBoard(guiGraphics, set, GuiUtil.GristboardMode.GRIST_WIDGET, 9, 45, this.font);
            int cost = GristWidgetBlockEntity.getGristWidgetBoondollarValue(set);
            long has = ClientPlayerData.getBoondollars();
            String costText = GuiUtil.addSuffix(cost) + "\u00a3(" + GuiUtil.addSuffix(has) + ")";
            guiGraphics.drawString(this.font, costText, this.imageWidth - 9 - this.font.width(costText), this.imageHeight - 96 + 3, (long)cost > has ? 0xFF0000 : 65280, false);
            Component tooltip = GuiUtil.getGristboardTooltip(set, GuiUtil.GristboardMode.GRIST_WIDGET, mouseX - this.leftPos, mouseY - this.topPos, 9, 45, this.font);
            if (tooltip != null) {
                guiGraphics.renderTooltip(this.font, tooltip, mouseX - this.leftPos, mouseY - this.topPos);
            } else if (mouseY - this.topPos >= this.imageHeight - 96 + 3) {
                Objects.requireNonNull(this.font);
                if (mouseY - this.topPos < this.imageHeight - 96 + 3 + 9) {
                    if (!GuiUtil.addSuffix(cost).equals(String.valueOf(cost)) && mouseX - this.leftPos < this.imageWidth - 9 - this.font.width("\u00a3(" + GuiUtil.addSuffix(has) + ")") && mouseX - this.leftPos >= this.imageWidth - 9 - this.font.width(costText)) {
                        guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)String.valueOf(cost)), mouseX - this.leftPos, mouseY - this.topPos);
                    } else if (!GuiUtil.addSuffix(has).equals(String.valueOf(has)) && mouseX - this.leftPos < this.imageWidth - 9 - this.font.width(")") && mouseX - this.leftPos >= this.imageWidth - 9 - this.font.width(GuiUtil.addSuffix(has) + ")")) {
                        guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)String.valueOf(has)), mouseX - this.leftPos, mouseY - this.topPos);
                    }
                }
            }
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float par1, int par2, int par3) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int width = GristWidgetScreen.getScaledValue(((GristWidgetMenu)this.menu).getProgress(), 100, 71);
        guiGraphics.blit(PROGRESS_BAR_TEXTURE, this.leftPos + 54, this.topPos + 23, 0.0f, 0.0f, width, 10, 71, 10);
    }

    public void init() {
        super.init();
        this.goButton = (GoButton)this.addRenderableWidget((GuiEventListener)new GoButton(this.leftPos + 72, this.topPos + 31, 30, 12, (MachineContainerMenu)this.menu, true));
        if (((Boolean)MinestuckConfig.SERVER.disableGristWidget.get()).booleanValue()) {
            this.goButton.active = false;
        }
    }
}

