/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.google.common.collect.Maps;
import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.blockentity.TransportalizerBlockEntity;
import com.mraof.minestuck.blockentity.machine.AlchemiterBlockEntity;
import com.mraof.minestuck.blockentity.machine.PunchDesignixBlockEntity;
import com.mraof.minestuck.blockentity.redstone.AreaEffectBlockEntity;
import com.mraof.minestuck.blockentity.redstone.BlockTeleporterBlockEntity;
import com.mraof.minestuck.blockentity.redstone.RemoteObserverBlockEntity;
import com.mraof.minestuck.blockentity.redstone.StatStorerBlockEntity;
import com.mraof.minestuck.blockentity.redstone.StructureCoreBlockEntity;
import com.mraof.minestuck.blockentity.redstone.SummonerBlockEntity;
import com.mraof.minestuck.blockentity.redstone.WirelessRedstoneTransmitterBlockEntity;
import com.mraof.minestuck.client.gui.AlchemiterScreen;
import com.mraof.minestuck.client.gui.AnthvilScreen;
import com.mraof.minestuck.client.gui.AreaEffectScreen;
import com.mraof.minestuck.client.gui.BlockTeleporterScreen;
import com.mraof.minestuck.client.gui.CassetteContainerScreen;
import com.mraof.minestuck.client.gui.ConsortShopScreen;
import com.mraof.minestuck.client.gui.DialogueScreen;
import com.mraof.minestuck.client.gui.GristWidgetScreen;
import com.mraof.minestuck.client.gui.MiniAlchemiterScreen;
import com.mraof.minestuck.client.gui.MiniCruxtruderScreen;
import com.mraof.minestuck.client.gui.MiniPunchDesignixScreen;
import com.mraof.minestuck.client.gui.MiniTotemLatheScreen;
import com.mraof.minestuck.client.gui.PunchDesignixScreen;
import com.mraof.minestuck.client.gui.ReadableSburbCodeScreen;
import com.mraof.minestuck.client.gui.RemoteObserverScreen;
import com.mraof.minestuck.client.gui.SendificatorScreen;
import com.mraof.minestuck.client.gui.StatStorerScreen;
import com.mraof.minestuck.client.gui.StoneTabletScreen;
import com.mraof.minestuck.client.gui.StructureCoreScreen;
import com.mraof.minestuck.client.gui.SummonerScreen;
import com.mraof.minestuck.client.gui.TitleSelectorScreen;
import com.mraof.minestuck.client.gui.TransportalizerScreen;
import com.mraof.minestuck.client.gui.UraniumCookerScreen;
import com.mraof.minestuck.client.gui.WirelessRedstoneTransmitterScreen;
import com.mraof.minestuck.client.gui.captchalouge.HashMapSylladexScreen;
import com.mraof.minestuck.client.gui.captchalouge.QueueSylladexScreen;
import com.mraof.minestuck.client.gui.captchalouge.QueuestackSylladexScreen;
import com.mraof.minestuck.client.gui.captchalouge.SetSylladexScreen;
import com.mraof.minestuck.client.gui.captchalouge.StackSylladexScreen;
import com.mraof.minestuck.client.gui.captchalouge.SylladexScreen;
import com.mraof.minestuck.client.gui.captchalouge.TreeSylladexScreen;
import com.mraof.minestuck.client.gui.computer.ComputerScreen;
import com.mraof.minestuck.entity.dialogue.Dialogue;
import com.mraof.minestuck.inventory.MSMenuTypes;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.inventory.captchalogue.ModusType;
import com.mraof.minestuck.inventory.captchalogue.ModusTypes;
import com.mraof.minestuck.player.Title;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;

@EventBusSubscriber(value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD, modid="minestuck")
public class MSScreenFactories {
    private static final Map<ModusType<?>, Function<Modus, ? extends SylladexScreen>> SYLLADEX_FACTORIES = Maps.newHashMap();

    @SubscribeEvent
    public static void registerScreenFactories(RegisterMenuScreensEvent event) {
        event.register(MSMenuTypes.MINI_CRUXTRUDER.get(), MiniCruxtruderScreen::new);
        event.register(MSMenuTypes.MINI_TOTEM_LATHE.get(), MiniTotemLatheScreen::new);
        event.register(MSMenuTypes.MINI_ALCHEMITER.get(), MiniAlchemiterScreen::new);
        event.register(MSMenuTypes.MINI_PUNCH_DESIGNIX.get(), MiniPunchDesignixScreen::new);
        event.register(MSMenuTypes.SENDIFICATOR.get(), SendificatorScreen::new);
        event.register(MSMenuTypes.GRIST_WIDGET.get(), GristWidgetScreen::new);
        event.register(MSMenuTypes.URANIUM_COOKER.get(), UraniumCookerScreen::new);
        event.register(MSMenuTypes.ANTHVIL.get(), AnthvilScreen::new);
        event.register(MSMenuTypes.CONSORT_MERCHANT.get(), ConsortShopScreen::new);
        event.register(MSMenuTypes.CASSETTE_CONTAINER.get(), CassetteContainerScreen::new);
        MSScreenFactories.registerSylladexFactory(ModusTypes.STACK, StackSylladexScreen::new);
        MSScreenFactories.registerSylladexFactory(ModusTypes.QUEUE, QueueSylladexScreen::new);
        MSScreenFactories.registerSylladexFactory(ModusTypes.QUEUE_STACK, QueuestackSylladexScreen::new);
        MSScreenFactories.registerSylladexFactory(ModusTypes.TREE, TreeSylladexScreen::new);
        MSScreenFactories.registerSylladexFactory(ModusTypes.HASH_MAP, HashMapSylladexScreen::new);
        MSScreenFactories.registerSylladexFactory(ModusTypes.SET, SetSylladexScreen::new);
    }

    public static void registerSylladexFactory(Supplier<? extends ModusType<?>> type, Function<Modus, ? extends SylladexScreen> factory) {
        MSScreenFactories.registerSylladexFactory(type.get(), factory);
    }

    public static void registerSylladexFactory(ModusType<?> type, Function<Modus, ? extends SylladexScreen> factory) {
        SYLLADEX_FACTORIES.put(type, factory);
    }

    public static void displayComputerScreen(ComputerBlockEntity blockEntity) {
        Minecraft.getInstance().setScreen((Screen)new ComputerScreen(Minecraft.getInstance(), blockEntity));
    }

    public static void displayTransportalizerScreen(TransportalizerBlockEntity blockEntity) {
        Minecraft.getInstance().setScreen((Screen)new TransportalizerScreen(blockEntity));
    }

    public static void displayAreaEffectScreen(AreaEffectBlockEntity blockEntity) {
        Minecraft.getInstance().setScreen((Screen)new AreaEffectScreen(blockEntity));
    }

    public static void displayWirelessRedstoneTransmitterScreen(WirelessRedstoneTransmitterBlockEntity blockEntity) {
        Minecraft.getInstance().setScreen((Screen)new WirelessRedstoneTransmitterScreen(blockEntity));
    }

    public static void displayStatStorerScreen(StatStorerBlockEntity blockEntity) {
        Minecraft.getInstance().setScreen((Screen)new StatStorerScreen(blockEntity));
    }

    public static void displayRemoteObserverScreen(RemoteObserverBlockEntity blockEntity) {
        Minecraft.getInstance().setScreen((Screen)new RemoteObserverScreen(blockEntity));
    }

    public static void displaySummonerScreen(SummonerBlockEntity blockEntity) {
        Minecraft.getInstance().setScreen((Screen)new SummonerScreen(blockEntity));
    }

    public static void displayStructureCoreScreen(StructureCoreBlockEntity blockEntity) {
        Minecraft.getInstance().setScreen((Screen)new StructureCoreScreen(blockEntity));
    }

    public static void displayBlockTeleporterScreen(BlockTeleporterBlockEntity blockEntity) {
        Minecraft.getInstance().setScreen((Screen)new BlockTeleporterScreen(blockEntity));
    }

    public static void displayAlchemiterScreen(AlchemiterBlockEntity blockEntity) {
        Minecraft.getInstance().setScreen((Screen)new AlchemiterScreen(blockEntity));
    }

    public static void displayPunchDesignixScreen(PunchDesignixBlockEntity blockEntity) {
        Minecraft.getInstance().setScreen((Screen)new PunchDesignixScreen(blockEntity));
    }

    public static void displayStoneTabletScreen(Player playerIn, InteractionHand handIn, String text, boolean canEdit) {
        Minecraft.getInstance().setScreen((Screen)new StoneTabletScreen(playerIn, handIn, text, canEdit));
    }

    public static void displayReadableSburbCodeScreen(Set<Block> blockList, boolean paradoxCode) {
        Minecraft.getInstance().setScreen((Screen)new ReadableSburbCodeScreen(blockList, paradoxCode));
    }

    public static void displayTitleSelectScreen(Title title) {
        Minecraft.getInstance().setScreen((Screen)new TitleSelectorScreen(title));
    }

    public static void displaySylladexScreen(Modus modus) {
        if (SYLLADEX_FACTORIES.containsKey(modus.getType())) {
            SylladexScreen screen = SYLLADEX_FACTORIES.get(modus.getType()).apply(modus);
            Minecraft.getInstance().setScreen((Screen)screen);
        }
    }

    public static void displayDialogueScreen(int dialogueId, Dialogue.DialogueData dialogueData) {
        Minecraft.getInstance().setScreen((Screen)new DialogueScreen(dialogueId, dialogueData));
    }

    public static void closeDialogueScreen() {
        Minecraft minecraft = Minecraft.getInstance();
        if (minecraft.screen instanceof DialogueScreen) {
            minecraft.setScreen(null);
        }
    }

    public static void updateSylladexScreen() {
        Screen screen = Minecraft.getInstance().screen;
        if (screen instanceof SylladexScreen) {
            SylladexScreen screen2 = (SylladexScreen)screen;
            screen2.updateContent();
        }
    }
}

