/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.GristType;
import com.mraof.minestuck.api.alchemy.GristTypes;
import com.mraof.minestuck.client.util.GuiUtil;
import com.mraof.minestuck.computer.editmode.ClientEditmodeData;
import com.mraof.minestuck.player.ClientPlayerData;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class MinestuckScreen
extends Screen {
    protected static final int gristIconX = 21;
    protected static final int gristIconY = 32;
    protected static final int gristDisplayXOffset = 66;
    protected static final int gristDisplayYOffset = 21;
    protected static final int gristCountX = 44;
    protected static final int gristCountY = 36;
    protected static final int rows = 7;
    protected static final int columns = 3;
    private static final ResourceLocation barCovers = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/bar_covers.png");

    protected MinestuckScreen(Component titleIn) {
        super(titleIn);
    }

    public void drawGrist(GuiGraphics guiGraphics, int xOffset, int yOffset, int xcor, int ycor, int page) {
        if (this.minecraft == null) {
            return;
        }
        boolean showName = false;
        GristType tooltipType = null;
        ClientPlayerData.ClientCache cache = ClientPlayerData.getGristCache(ClientEditmodeData.isInEditmode() ? ClientPlayerData.CacheSource.EDITMODE : ClientPlayerData.CacheSource.PLAYER);
        GristSet clientGrist = cache.set();
        long cacheLimit = cache.limit();
        List types = GristTypes.REGISTRY.stream().sorted().skip((long)page * 7L * 3L).limit(21L).toList();
        int offset = 0;
        for (GristType type : types) {
            int column = offset % 3;
            int row = offset / 3;
            int gristXOffset = xOffset + (66 * column - column);
            int gristYOffset = yOffset + (21 * row - row);
            String amount = GuiUtil.addSuffix(clientGrist.getGrist(type));
            if (this.isPointInRegion(gristXOffset + 21, gristYOffset + 32, 16, 16, xcor, ycor)) {
                guiGraphics.fillGradient(gristXOffset + 21, gristYOffset + 32, gristXOffset + 21 + 16, gristYOffset + 32 + 17, -2130706433, -2130706433);
                tooltipType = type;
                showName = true;
            }
            if (!String.valueOf(clientGrist.getGrist(type)).equals(amount) && this.isPointInRegion(gristXOffset + 44 - 1, gristYOffset + 36 - 1, 35, 10, xcor, ycor)) {
                tooltipType = type;
                showName = false;
            }
            this.drawIcon(gristXOffset + 21, gristYOffset + 32, type.getIcon());
            guiGraphics.drawString(this.font, amount, gristXOffset + 44 - 2, gristYOffset + 36 + 10, 1684463, false);
            double gristFraction = Math.min(1.0, (double)clientGrist.getGrist(type) / (double)cacheLimit);
            guiGraphics.fill(gristXOffset + 44 - 1, gristYOffset + 36 - 1, (int)((double)(gristXOffset + 44) + 34.0 * gristFraction), gristYOffset + 45, -15092753);
            guiGraphics.fill(gristXOffset + 44 - 1, gristYOffset + 36 - 1, (int)((double)(gristXOffset + 44) + 34.0 * gristFraction), gristYOffset + 38, -8464155);
            ++offset;
        }
        if (tooltipType != null) {
            if (showName) {
                guiGraphics.renderTooltip(this.font, tooltipType.getNameWithSuffix(), xcor, ycor);
            } else {
                guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)String.valueOf(clientGrist.getGrist(tooltipType))), xcor, ycor);
            }
        }
    }

    private void drawCovers(int x, int y, ResourceLocation barCovers) {
        if (barCovers == null || this.minecraft == null) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)barCovers);
        float scale = 0.0625f;
        int iconX = 48;
        int iconY = 22;
        int iconU = 0;
        int iconV = 0;
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex((float)x, (float)(y + iconY), 0.0f).setUv((float)iconU * scale, (float)(iconV + iconY) * scale);
        buffer.addVertex((float)(x + iconX), (float)(y + iconY), 0.0f).setUv((float)(iconU + iconX) * scale, (float)(iconV + iconY) * scale);
        buffer.addVertex((float)(x + iconX), (float)y, 0.0f).setUv((float)(iconU + iconX) * scale, (float)iconV * scale);
        buffer.addVertex((float)x, (float)y, 0.0f).setUv((float)iconU * scale, (float)iconV * scale);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    private void drawIcon(int x, int y, ResourceLocation icon) {
        if (icon == null || this.minecraft == null) {
            return;
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)icon);
        float scale = 0.0625f;
        int iconX = 16;
        int iconY = 16;
        int iconU = 0;
        int iconV = 0;
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
        buffer.addVertex((float)x, (float)(y + iconY), 0.0f).setUv((float)iconU * scale, (float)(iconV + iconY) * scale);
        buffer.addVertex((float)(x + iconX), (float)(y + iconY), 0.0f).setUv((float)(iconU + iconX) * scale, (float)(iconV + iconY) * scale);
        buffer.addVertex((float)(x + iconX), (float)y, 0.0f).setUv((float)(iconU + iconX) * scale, (float)iconV * scale);
        buffer.addVertex((float)x, (float)y, 0.0f).setUv((float)iconU * scale, (float)iconV * scale);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
    }

    protected boolean isPointInRegion(int regionX, int regionY, int regionWidth, int regionHeight, int pointX, int pointY) {
        return pointX >= regionX && pointX < regionX + regionWidth && pointY >= regionY && pointY < regionY + regionHeight;
    }
}

