/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.api.alchemy.GristSet;
import com.mraof.minestuck.api.alchemy.recipe.GristCostRecipe;
import com.mraof.minestuck.client.gui.GoButton;
import com.mraof.minestuck.client.gui.GristSelectorScreen;
import com.mraof.minestuck.client.gui.MachineScreen;
import com.mraof.minestuck.client.util.GuiUtil;
import com.mraof.minestuck.inventory.MachineContainerMenu;
import com.mraof.minestuck.inventory.MiniAlchemiterMenu;
import com.mraof.minestuck.item.MSItems;
import com.mraof.minestuck.item.components.EncodedItemComponent;
import com.mraof.minestuck.item.components.MSItemComponents;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

@ParametersAreNonnullByDefault
public class MiniAlchemiterScreen
extends MachineScreen<MiniAlchemiterMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/alchemiter.png");
    private static final ResourceLocation PROGRESS_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/progress/alchemiter.png");
    private static final int PROGRESS_BAR_X = 54;
    private static final int PROGRESS_BAR_Y = 23;
    private static final int PROGRESS_BAR_WIDTH = 71;
    private static final int PROGRESS_BAR_HEIGHT = 10;
    private static final int BUTTON_X = 72;
    private static final int BUTTON_Y = 31;

    public MiniAlchemiterScreen(MiniAlchemiterMenu screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        Objects.requireNonNull(this.minecraft);
        super.renderLabels(guiGraphics, mouseX, mouseY);
        if (((MiniAlchemiterMenu)this.menu).getSlot(0).hasItem()) {
            ItemStack stack = EncodedItemComponent.getEncodedOrBlank(((MiniAlchemiterMenu)this.menu).getSlot(0).getItem());
            Optional<GristCostRecipe> recipe = GristCostRecipe.findRecipeForItem(stack, (Level)this.minecraft.level);
            GristSet set = recipe.map(recipe1 -> recipe1.getGristCost(stack, ((MiniAlchemiterMenu)this.menu).getWildcardType(), false)).orElse(null);
            boolean useWildcard = recipe.map(GristCostRecipe::canPickWildcard).orElse(false);
            GuiUtil.drawGristBoard(guiGraphics, set, useWildcard ? GuiUtil.GristboardMode.ALCHEMITER_SELECT : GuiUtil.GristboardMode.ALCHEMITER, 9, 45, this.font);
            Component tooltip = GuiUtil.getGristboardTooltip(set, useWildcard ? GuiUtil.GristboardMode.ALCHEMITER_SELECT : GuiUtil.GristboardMode.ALCHEMITER, mouseX - this.leftPos, mouseY - this.topPos, 9, 45, this.font);
            if (tooltip != null) {
                guiGraphics.renderTooltip(this.font, tooltip, mouseX - this.leftPos, mouseY - this.topPos);
            }
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int width = MiniAlchemiterScreen.getScaledValue(((MiniAlchemiterMenu)this.menu).getProgress(), 100, 71);
        guiGraphics.blit(PROGRESS_BAR_TEXTURE, this.leftPos + 54, this.topPos + 23, 0.0f, 0.0f, width, 10, 71, 10);
    }

    protected void init() {
        super.init();
        this.goButton = (GoButton)this.addRenderableWidget((GuiEventListener)new GoButton(this.leftPos + 72, this.topPos + 31, 30, 12, (MachineContainerMenu)this.menu, true));
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        EncodedItemComponent encodedItemComponent;
        Objects.requireNonNull(this.minecraft);
        boolean b = super.mouseClicked(mouseX, mouseY, button);
        if (button == 0 && ((MiniAlchemiterMenu)this.menu).getCarried().isEmpty() && mouseX >= (double)(this.leftPos + 9) && mouseX < (double)(this.leftPos + 167) && mouseY >= (double)(this.topPos + 45) && mouseY < (double)(this.topPos + 70) && (encodedItemComponent = (EncodedItemComponent)((MiniAlchemiterMenu)this.menu).getSlot(0).getItem().get(MSItemComponents.ENCODED_ITEM)) != null && encodedItemComponent.item() == MSItems.CAPTCHA_CARD.get()) {
            this.minecraft.pushGuiLayer((Screen)new GristSelectorScreen(((MiniAlchemiterMenu)this.getMenu()).machinePos));
            return true;
        }
        return b;
    }
}

