/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mraof.minestuck.blockentity.machine.PunchDesignixBlockEntity;
import com.mraof.minestuck.network.block.TriggerPunchDesignixPacket;
import java.util.regex.Pattern;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

public class PunchDesignixScreen
extends Screen {
    public static final String TITLE = "minestuck.punch_designix";
    public static final String ENTER_CAPTCHA_MESSAGE = "minestuck.punch_designix.enter_captcha";
    public static final String PUNCH_MESSAGE = "minestuck.punch_designix.punch";
    private static final ResourceLocation guiBackground = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/generic_small.png");
    private static final int guiWidth = 126;
    private static final int guiHeight = 98;
    PunchDesignixBlockEntity be;
    private EditBox captchaTextField;
    private Button doneButton;

    PunchDesignixScreen(PunchDesignixBlockEntity be) {
        super((Component)Component.translatable((String)TITLE));
        this.be = be;
    }

    public void init() {
        int yOffset = this.height / 2 - 49;
        this.captchaTextField = new EditBox(this.font, this.width / 2 - 40, yOffset + 25, 80, 20, (Component)Component.translatable((String)ENTER_CAPTCHA_MESSAGE));
        this.captchaTextField.setCanLoseFocus(false);
        String storedCaptcha = this.be.getCaptcha();
        if (storedCaptcha != null) {
            this.captchaTextField.setValue(storedCaptcha);
        }
        this.captchaTextField.setMaxLength(8);
        this.captchaTextField.setFilter(text -> Pattern.matches("^[0-9a-zA-Z!#?]+$", text) || text.isEmpty());
        this.captchaTextField.setResponder(s -> {
            this.doneButton.active = s.length() == 8;
        });
        this.addRenderableWidget((GuiEventListener)this.captchaTextField);
        this.setInitialFocus((GuiEventListener)this.captchaTextField);
        this.doneButton = new ExtendedButton(this.width / 2 - 20, yOffset + 50, 40, 20, (Component)Component.translatable((String)PUNCH_MESSAGE), button -> this.finish());
        this.addRenderableWidget((GuiEventListener)this.doneButton);
        this.doneButton.active = this.captchaTextField.getValue().length() == 8;
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(graphics, mouseX, mouseY, partialTicks);
        int yOffset = this.height / 2 - 49;
        int xOffset = this.width / 2 - 63;
        graphics.blit(guiBackground, xOffset, yOffset, 0, 0, 126, 98);
    }

    private void finish() {
        if (this.captchaTextField.getValue().length() == 8) {
            String captcha = this.captchaTextField.getValue();
            this.be.setCaptcha(captcha);
            PacketDistributor.sendToServer((CustomPacketPayload)new TriggerPunchDesignixPacket(captcha, this.be.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.minecraft.setScreen(null);
        }
    }
}

