/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mojang.logging.LogUtils;
import com.mraof.minestuck.util.MSTags;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

@ParametersAreNonnullByDefault
public class ReadableSburbCodeScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation BOOK_TEXTURES_01A = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/sburb_book_01a.png");
    private static final ResourceLocation BOOK_TEXTURES_01B = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/sburb_book_01b.png");
    private static final ResourceLocation BOOK_TEXTURES_02 = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/sburb_book_02.png");
    private static final ResourceLocation BOOK_TEXTURES_03 = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/sburb_book_03.png");
    private final boolean[] hieroglyphValidityArray;
    private final List<List<String>> listOfPages = new ArrayList<List<String>>();
    private PageButton forwardButton;
    private PageButton backButton;
    private List<String> textList = null;
    private int linesPerBlock = 27;
    private int totalPages = 8;
    private int currentPage = 0;
    private static final int GUI_WIDTH = 192;
    private static final int GUI_HEIGHT = 192;
    private static final int TEXT_WIDTH = 288;
    private static final int TEXT_OFFSET_X = 36;
    private static final int TEXT_OFFSET_Y = 32;
    private static final int CUSTOM_LINE_HEIGHT = 3;
    private static final int LINES_PER_PAGE = 40;
    private final List<Block> FULL_HIEROGLYPH_LIST = BuiltInRegistries.BLOCK.getTag(MSTags.Blocks.GREEN_HIEROGLYPHS).stream().flatMap(HolderSet.ListBacked::stream).map(Holder::value).toList();
    private final int MAX_HIEROGLYPH_COUNT = this.FULL_HIEROGLYPH_LIST.size() + 1;
    private static final String EMPTY_SPACE = " ".repeat(48);

    public ReadableSburbCodeScreen(Set<Block> recordedBlockList, boolean paradoxCode) {
        super(GameNarrator.NO_TITLE);
        this.hieroglyphValidityArray = this.checkForValidity(recordedBlockList, paradoxCode);
    }

    protected void init() {
        super.init();
        this.createMenuControls();
        this.createPageControlButtons();
        BufferedReader reader = null;
        try {
            reader = this.minecraft.getResourceManager().openAsReader(ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"texts/rana_temporaria_sec22b.txt"));
            BufferedReader bufferedReader = new BufferedReader(reader);
            this.textList = bufferedReader.lines().collect(Collectors.toList());
            this.linesPerBlock = this.textList.size() / this.MAX_HIEROGLYPH_COUNT;
            this.totalPages = Math.round((float)(this.textList.size() + 1) / 40.0f);
        }
        catch (Exception e) {
            try {
                LOGGER.error("Couldn't load book nucleotides", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                throw throwable;
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        IOUtils.closeQuietly((Reader)reader);
        if (this.textList != null) {
            this.makeUnrecordedSectionsBlank();
            this.sortIntoPages();
        }
    }

    private void makeUnrecordedSectionsBlank() {
        for (int sectionIterate = 0; sectionIterate < this.hieroglyphValidityArray.length; ++sectionIterate) {
            int fromSectionIndex = sectionIterate * this.linesPerBlock;
            int toSectionIndex = Math.min(sectionIterate * this.linesPerBlock + this.linesPerBlock - 1, this.textList.size());
            if (this.hieroglyphValidityArray[sectionIterate]) continue;
            if (sectionIterate == this.hieroglyphValidityArray.length - 1) {
                toSectionIndex = this.textList.size() - 1;
            }
            for (int iterate = fromSectionIndex; iterate < toSectionIndex + 1; ++iterate) {
                this.textList.set(iterate, EMPTY_SPACE);
            }
        }
    }

    private void sortIntoPages() {
        for (int pageIterate = 0; pageIterate < this.totalPages + 1; ++pageIterate) {
            int fromIndex = Math.min(40 * pageIterate, this.textList.size());
            int toIndex = Math.min(40 * pageIterate + 40, this.textList.size());
            this.listOfPages.add(this.textList.subList(fromIndex, toIndex));
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        ResourceLocation pageTexture;
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.currentPage == 0) {
            pageTexture = BOOK_TEXTURES_01A;
        } else {
            switch (this.currentPage % 3) {
                case 0: {
                    pageTexture = BOOK_TEXTURES_01B;
                    break;
                }
                case 1: {
                    pageTexture = BOOK_TEXTURES_02;
                    break;
                }
                default: {
                    pageTexture = BOOK_TEXTURES_03;
                }
            }
        }
        int topX = (this.width - 192) / 2;
        int topY = 2;
        guiGraphics.blit(pageTexture, topX, topY, 0, 0, 192, 192);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.setFocused(null);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.textList != null) {
            guiGraphics.pose().pushPose();
            float subtractScale = 0.4f;
            float scale = 1.0f / subtractScale;
            guiGraphics.pose().scale(subtractScale, subtractScale, subtractScale);
            MutableInt lineY = new MutableInt();
            for (String text : this.listOfPages.get(this.currentPage)) {
                this.font.getSplitter().splitLines(text, 288, Style.EMPTY, true, (style, start, end) -> {
                    if (this.stillValidLine(lineY.intValue())) {
                        MutableComponent line = Component.literal((String)text.substring(start, end)).setStyle(style);
                        guiGraphics.drawString(this.font, line.getVisualOrderText(), ((float)(this.width - 192) / 2.0f + 36.0f) * scale, (float)(lineY.intValue() + 32) * scale, 41728, false);
                        lineY.add(3);
                    }
                });
            }
            guiGraphics.pose().popPose();
        }
    }

    private boolean[] checkForValidity(Set<Block> recordedBlockList, boolean paradoxCode) {
        boolean[] booleans = new boolean[this.MAX_HIEROGLYPH_COUNT];
        booleans[0] = paradoxCode;
        if (!recordedBlockList.isEmpty()) {
            for (int blockIndex = 0; blockIndex < this.FULL_HIEROGLYPH_LIST.size(); ++blockIndex) {
                booleans[blockIndex + 1] = recordedBlockList.contains(this.FULL_HIEROGLYPH_LIST.get(blockIndex));
            }
        }
        return booleans;
    }

    private boolean stillValidLine(int lineY) {
        return lineY < 120;
    }

    protected void createMenuControls() {
        if (this.minecraft != null) {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), button -> this.minecraft.setScreen(null)).pos(this.width / 2 - 100, 196).size(200, 20).build());
        }
    }

    protected void createPageControlButtons() {
        int i = (this.width - 192) / 2;
        this.forwardButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(i + 116, 159, true, button -> this.pageForward(), true));
        this.backButton = (PageButton)this.addRenderableWidget((GuiEventListener)new PageButton(i + 43, 159, false, button -> this.pageBack(), true));
        this.updateButtonVisibility();
    }

    protected void pageBack() {
        if (this.currentPage > 0) {
            --this.currentPage;
        }
        this.updateButtonVisibility();
    }

    protected void pageForward() {
        if (this.currentPage < this.totalPages) {
            ++this.currentPage;
        }
        this.updateButtonVisibility();
    }

    private void updateButtonVisibility() {
        this.forwardButton.visible = this.currentPage < this.totalPages;
        this.backButton.visible = this.currentPage > 0;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (super.keyPressed(pKeyCode, pScanCode, pModifiers)) {
            return true;
        }
        switch (pKeyCode) {
            case 266: {
                this.backButton.onPress();
                return true;
            }
            case 267: {
                this.forwardButton.onPress();
                return true;
            }
        }
        return false;
    }
}

