/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mraof.minestuck.blockentity.redstone.RemoteObserverBlockEntity;
import com.mraof.minestuck.network.block.RemoteObserverSettingsPacket;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

public class RemoteObserverScreen
extends Screen {
    public static final String TITLE = "minestuck.remote_observer";
    public static final String CURRENT_ENTITY_TYPE_MESSAGE = "minestuck.remote_observer.current_entity_type";
    private static final ResourceLocation GUI_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/generic_medium.png");
    private static final int GUI_WIDTH = 150;
    private static final int GUI_HEIGHT = 98;
    private final RemoteObserverBlockEntity be;
    private RemoteObserverBlockEntity.ActiveType activeType;
    private int observingRange;
    private Button typeButton;
    private Button incrementButton;
    private Button decrementButton;
    private Button largeIncrementButton;
    private Button largeDecrementButton;
    private EditBox entityTypeTextField;

    RemoteObserverScreen(RemoteObserverBlockEntity be) {
        super((Component)Component.translatable((String)TITLE));
        this.be = be;
        this.activeType = be.getActiveType();
        this.observingRange = be.getObservingRange();
    }

    public void init() {
        int yOffset = this.height / 2 - 49;
        this.typeButton = new ExtendedButton(this.width / 2 - 67, (this.height - 98) / 2 + 5, 135, 20, (Component)Component.literal((String)this.activeType.getNameNoSpaces()), button -> this.changeActiveType());
        this.addRenderableWidget((GuiEventListener)this.typeButton);
        this.entityTypeTextField = new EditBox(this.font, this.width / 2 - 53, yOffset + 29, 105, 18, (Component)Component.translatable((String)CURRENT_ENTITY_TYPE_MESSAGE));
        this.entityTypeTextField.setValue(EntityType.getKey(this.be.getCurrentEntityType()).toString());
        this.addRenderableWidget((GuiEventListener)this.entityTypeTextField);
        this.entityTypeTextField.setVisible(this.activeType == RemoteObserverBlockEntity.ActiveType.CURRENT_ENTITY_PRESENT);
        this.incrementButton = new ExtendedButton(this.width / 2 + 20, (this.height - 98) / 2 + 51, 20, 20, (Component)Component.literal((String)"+"), button -> this.changeRange(1));
        this.addRenderableWidget((GuiEventListener)this.incrementButton);
        this.decrementButton = new ExtendedButton(this.width / 2 - 40, (this.height - 98) / 2 + 51, 20, 20, (Component)Component.literal((String)"-"), button -> this.changeRange(-1));
        this.addRenderableWidget((GuiEventListener)this.decrementButton);
        this.largeIncrementButton = new ExtendedButton(this.width / 2 + 45, (this.height - 98) / 2 + 51, 20, 20, (Component)Component.literal((String)"++"), button -> this.changeRange(10));
        this.addRenderableWidget((GuiEventListener)this.largeIncrementButton);
        this.largeDecrementButton = new ExtendedButton(this.width / 2 - 65, (this.height - 98) / 2 + 51, 20, 20, (Component)Component.literal((String)"--"), button -> this.changeRange(-10));
        this.addRenderableWidget((GuiEventListener)this.largeDecrementButton);
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 2 - 20, yOffset + 73, 40, 20, (Component)Component.literal((String)"DONE"), button -> this.finish()));
    }

    private void changeActiveType() {
        this.activeType = RemoteObserverBlockEntity.ActiveType.fromInt(this.activeType.ordinal() < RemoteObserverBlockEntity.ActiveType.values().length - 1 ? this.activeType.ordinal() + 1 : 0);
        this.typeButton.setMessage((Component)Component.literal((String)this.activeType.getNameNoSpaces()));
        this.entityTypeTextField.setVisible(this.activeType == RemoteObserverBlockEntity.ActiveType.CURRENT_ENTITY_PRESENT);
    }

    private void changeRange(int change) {
        this.observingRange = Mth.clamp((int)(this.observingRange + change), (int)1, (int)64);
        this.incrementButton.active = this.observingRange < 64;
        this.decrementButton.active = this.observingRange > 1;
        this.largeIncrementButton.active = this.observingRange < 64;
        this.largeDecrementButton.active = this.observingRange > 1;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int yOffset = this.height / 2 - 49;
        guiGraphics.blit(GUI_BACKGROUND, this.width / 2 - 75, yOffset, 0, 0, 150, 98);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, Integer.toString(this.observingRange), this.width / 2 - 5, (this.height - 98) / 2 + 55, 0x404040, false);
    }

    private void finish() {
        boolean isValidAndObservableEntityType;
        Optional attemptedEntityType = EntityType.byString((String)this.entityTypeTextField.getValue());
        boolean isCurrentEntityActiveType = this.activeType == RemoteObserverBlockEntity.ActiveType.CURRENT_ENTITY_PRESENT;
        boolean bl = isValidAndObservableEntityType = attemptedEntityType.isPresent() && RemoteObserverBlockEntity.entityCanBeObserved((EntityType)attemptedEntityType.get());
        if (!isCurrentEntityActiveType || isValidAndObservableEntityType) {
            EntityType entityType = this.be.getCurrentEntityType();
            if (isValidAndObservableEntityType) {
                entityType = (EntityType)attemptedEntityType.get();
            }
            PacketDistributor.sendToServer((CustomPacketPayload)new RemoteObserverSettingsPacket(this.activeType, this.observingRange, this.be.getBlockPos(), Optional.ofNullable(entityType)), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.onClose();
        } else {
            this.entityTypeTextField.setTextColor(0xFF0000);
        }
    }
}

