/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.client.gui.GoButton;
import com.mraof.minestuck.client.gui.MachineScreen;
import com.mraof.minestuck.inventory.MachineContainerMenu;
import com.mraof.minestuck.inventory.SendificatorMenu;
import com.mraof.minestuck.network.block.SetSendificatorDestinationPacket;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class SendificatorScreen
extends MachineScreen<SendificatorMenu> {
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/sendificator.png");
    private static final ResourceLocation PROGRESS_BAR_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/progress/uranium_level.png");
    private static final int PROGRESS_BAR_X = 52;
    private static final int PROGRESS_BAR_Y = 24;
    private static final int PROGRESS_BAR_WIDTH = 35;
    private static final int PROGRESS_BAR_HEIGHT = 39;
    private static final int BUTTON_X = 115;
    private static final int BUTTON_Y = 60;
    private EditBox destinationTextFieldX;
    private EditBox destinationTextFieldY;
    private EditBox destinationTextFieldZ;
    private ExtendedButton updateButton;
    private ExtendedButton goButton;
    @Nullable
    private BlockPos parsedPos;

    SendificatorScreen(SendificatorMenu screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
    }

    public void init() {
        super.init();
        this.updateButton = (ExtendedButton)this.addRenderableWidget((GuiEventListener)new ExtendedButton((this.width - this.imageWidth) / 2 + 105, this.topPos + 40, 50, 12, (Component)Component.literal((String)"Update"), button -> this.updateDestinationPos()));
        this.destinationTextFieldX = new EditBox(this.font, this.width / 2 - 10, this.topPos + 10, 35, 15, (Component)Component.literal((String)"X value of destination block pos"));
        this.destinationTextFieldX.setMaxLength(10);
        this.addRenderableWidget((GuiEventListener)this.destinationTextFieldX);
        this.destinationTextFieldX.setResponder(s -> this.onTextFieldChange());
        this.destinationTextFieldY = new EditBox(this.font, this.width / 2 + 25, this.topPos + 10, 20, 15, (Component)Component.literal((String)"Y value of destination block pos"));
        this.destinationTextFieldY.setMaxLength(3);
        this.addRenderableWidget((GuiEventListener)this.destinationTextFieldY);
        this.destinationTextFieldY.setResponder(s -> this.onTextFieldChange());
        this.destinationTextFieldZ = new EditBox(this.font, this.width / 2 + 45, this.topPos + 10, 35, 15, (Component)Component.literal((String)"Z value of destination block pos"));
        this.destinationTextFieldZ.setMaxLength(10);
        this.addRenderableWidget((GuiEventListener)this.destinationTextFieldZ);
        this.destinationTextFieldZ.setResponder(s -> this.onTextFieldChange());
        this.goButton = new GoButton(this.leftPos + 115, this.topPos + 60, 30, 12, (MachineContainerMenu)this.menu, true);
        this.addRenderableWidget((GuiEventListener)this.goButton);
        BlockPos destination = ((SendificatorMenu)this.menu).getDestination();
        if (destination != null) {
            this.destinationTextFieldX.setValue(String.valueOf(destination.getX()));
            this.destinationTextFieldY.setValue(String.valueOf(destination.getY()));
            this.destinationTextFieldZ.setValue(String.valueOf(destination.getZ()));
        }
        this.updateButton.active = false;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.goButton.active = ((SendificatorMenu)this.menu).hasDestination();
        this.updateButton.active = this.parsedPos != null && !this.parsedPos.equals((Object)((SendificatorMenu)this.menu).getDestination());
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, 8, 6, 0x404040, false);
        guiGraphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 96 + 2, 0x404040, false);
    }

    protected void renderBg(GuiGraphics guiGraphics, float par1, int par2, int par3) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(BACKGROUND_TEXTURE, this.leftPos, this.topPos, 0, 0, this.imageWidth, this.imageHeight);
        int height = SendificatorScreen.getScaledValue(((SendificatorMenu)this.menu).getFuel(), 128, 39);
        guiGraphics.blit(PROGRESS_BAR_TEXTURE, this.leftPos + 52, this.topPos + 24 + 39 - height, 0.0f, (float)(39 - height), 35, height, 35, 39);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String destX = this.destinationTextFieldX.getValue();
        String destY = this.destinationTextFieldY.getValue();
        String destZ = this.destinationTextFieldZ.getValue();
        this.init(minecraft, width, height);
        this.destinationTextFieldX.setValue(destX);
        this.destinationTextFieldY.setValue(destY);
        this.destinationTextFieldZ.setValue(destZ);
    }

    private void updateDestinationPos() {
        if (this.parsedPos != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SetSendificatorDestinationPacket(this.parsedPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void onTextFieldChange() {
        try {
            this.parsedPos = this.parseBlockPos();
        }
        catch (NumberFormatException ignored) {
            this.parsedPos = null;
        }
    }

    private BlockPos parseBlockPos() throws NumberFormatException {
        int x = Integer.parseInt(this.destinationTextFieldX.getValue());
        int y = Integer.parseInt(this.destinationTextFieldY.getValue());
        int z = Integer.parseInt(this.destinationTextFieldZ.getValue());
        return new BlockPos(x, y, z);
    }
}

