/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mraof.minestuck.blockentity.redstone.StatStorerBlockEntity;
import com.mraof.minestuck.network.block.StatStorerSettingsPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class StatStorerScreen
extends Screen {
    public static final String TITLE = "minestuck.stat_storer";
    public static final String DIVIDE_VALUE_MESSAGE = "minestuck.stat_storer.divide_value";
    public static final String DIVIDE_COMPARATOR_MESSAGE = "minestuck.stat_storer.divide_comparator";
    public static final String DONE_MESSAGE = "minestuck.stat_storer.done";
    private static final ResourceLocation GUI_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/generic_medium.png");
    private static final int GUI_WIDTH = 150;
    private static final int GUI_HEIGHT = 98;
    private final StatStorerBlockEntity be;
    private StatStorerBlockEntity.ActiveType activeType;
    private Button typeButton;
    private EditBox divideTextField;

    StatStorerScreen(StatStorerBlockEntity be) {
        super((Component)Component.translatable((String)TITLE));
        this.be = be;
        this.activeType = be.getActiveType();
    }

    public void init() {
        this.typeButton = new ExtendedButton(this.width / 2 - 67, (this.height - 98) / 2 + 15, 135, 20, (Component)Component.literal((String)this.activeType.getNameNoSpaces()), button -> this.changeActiveType());
        this.addRenderableWidget((GuiEventListener)this.typeButton);
        int yOffset = this.height / 2 - 49;
        this.divideTextField = new EditBox(this.font, this.width / 2 - 18, yOffset + 50, 40, 18, (Component)Component.translatable((String)DIVIDE_COMPARATOR_MESSAGE));
        this.divideTextField.setValue(String.valueOf(this.be.getDivideValueBy()));
        this.addRenderableWidget((GuiEventListener)this.divideTextField);
        this.setInitialFocus((GuiEventListener)this.divideTextField);
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 2 - 18, yOffset + 70, 40, 20, (Component)Component.translatable((String)DONE_MESSAGE), button -> this.finish()));
    }

    private void changeActiveType() {
        this.activeType = StatStorerBlockEntity.ActiveType.fromInt(this.activeType.ordinal() < StatStorerBlockEntity.ActiveType.values().length - 1 ? this.activeType.ordinal() + 1 : 0);
        this.typeButton.setMessage((Component)Component.literal((String)this.activeType.getNameNoSpaces()));
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int yOffset = this.height / 2 - 49;
        guiGraphics.blit(GUI_BACKGROUND, this.width / 2 - 75, yOffset, 0, 0, 150, 98);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int yOffset = this.height / 2 - 49;
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)DIVIDE_VALUE_MESSAGE), this.width / 2 - this.font.width((FormattedText)Component.translatable((String)DIVIDE_VALUE_MESSAGE)) / 2, yOffset + 40, 0x404040, false);
    }

    private void finish() {
        PacketDistributor.sendToServer((CustomPacketPayload)new StatStorerSettingsPacket(this.activeType, this.textToInt(), this.be.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }

    private int textToInt() {
        try {
            return Integer.parseInt(this.divideTextField.getValue());
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }
}

