/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mraof.minestuck.client.gui.StoneTabletUtils;
import com.mraof.minestuck.network.CarveStoneTabletPacket;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.StringSplitter;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;
import org.apache.commons.lang3.mutable.MutableInt;

public class StoneTabletScreen
extends Screen {
    public static final ResourceLocation TABLET_TEXTURES = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/stone_tablet.png");
    public static final int GUI_WIDTH = 192;
    public static final int GUI_HEIGHT = 192;
    public static final int TEXT_WIDTH = 114;
    public static final int TEXT_OFFSET_X = 36;
    public static final int TEXT_OFFSET_Y = 32;
    private final boolean canEdit;
    private boolean isModified;
    private String text = "";
    private int updateCount;
    private long lastClickTime;
    private final Player editingPlayer;
    private final InteractionHand hand;
    private final ItemStack tablet;
    private Button buttonDone;
    private Button buttonCancel;
    private final TextFieldHelper pageEditor = new TextFieldHelper(() -> this.text, this::setText, this::getClipboard, this::setClipboard, text -> text.length() < 1024 && this.font.wordWrapHeight(text, 114) <= 128);

    public StoneTabletScreen(Player player, InteractionHand hand, String text2, boolean canEdit) {
        super(GameNarrator.NO_TITLE);
        this.canEdit = canEdit;
        this.hand = hand;
        this.tablet = player.getItemInHand(hand);
        this.editingPlayer = player;
        this.text = text2;
    }

    public void tick() {
        super.tick();
        ++this.updateCount;
    }

    protected void init() {
        if (this.canEdit) {
            this.buttonDone = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), button -> {
                this.minecraft.setScreen(null);
                this.sendTabletToServer();
            }).pos(this.width / 2 - 100, 196).size(98, 20).build());
            this.buttonCancel = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), button -> this.minecraft.setScreen(null)).pos(this.width / 2 + 2, 196).size(98, 20).build());
        } else {
            this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.done"), button -> this.minecraft.setScreen(null)).pos(this.width / 2 - 100, 196).size(200, 20).build());
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int topX = (this.width - 192) / 2;
        int topY = 2;
        guiGraphics.blit(TABLET_TEXTURES, topX, topY, 0, 0, 192, 192);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.setFocused(null);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        MutableInt lineY = new MutableInt();
        this.font.getSplitter().splitLines(this.text, 114, Style.EMPTY, false, (style, start, end) -> {
            MutableComponent line = Component.literal((String)this.text.substring(start, end)).setStyle(style);
            guiGraphics.drawString(this.font, (Component)line, (this.width - 192) / 2 + 36, lineY.intValue() + 32, 0xFFFFFF, false);
            Objects.requireNonNull(this.font);
            lineY.add(9);
        });
        this.highlightSelectedText();
        if (this.canEdit && this.updateCount / 6 % 2 == 0) {
            StoneTabletUtils.Point point = StoneTabletUtils.createPointer(this.font, this.text, this.pageEditor.getCursorPos());
            if (this.font.isBidirectional()) {
                StoneTabletUtils.adjustPointerAForBidi(this.font, point);
                point.x -= 4;
            }
            StoneTabletUtils.pointerToPrecise(point, this.width);
            if (this.pageEditor.getCursorPos() < this.text.length()) {
                int n = point.x;
                int n2 = point.y - 1;
                int n3 = point.x + 1;
                int n4 = point.y;
                Objects.requireNonNull(this.font);
                guiGraphics.fill(n, n2, n3, n4 + 9, 0xFFFFFF);
            } else {
                guiGraphics.drawString(this.font, "_", (float)point.x, (float)point.y, 0, false);
            }
        }
    }

    private void highlightSelectedText() {
        if (this.pageEditor.isSelecting()) {
            int cursor = this.pageEditor.getCursorPos();
            int selection = this.pageEditor.getSelectionPos();
            int selectionStart = Math.min(cursor, selection);
            int selectionEnd = Math.max(cursor, selection);
            MutableInt lineY = new MutableInt();
            this.font.getSplitter().splitLines(this.text, 114, Style.EMPTY, true, (style, start, end) -> {
                if (selectionEnd >= start && selectionStart <= end) {
                    int startIndex = Math.max(selectionStart, start);
                    int endIndex = Math.min(selectionEnd, end);
                    StoneTabletUtils.Point startPos = new StoneTabletUtils.Point(this.font.width(this.text.substring(start, startIndex)), lineY.intValue());
                    int n = this.font.width(this.text.substring(start, endIndex));
                    int n2 = lineY.intValue();
                    Objects.requireNonNull(this.font);
                    StoneTabletUtils.Point endPos = new StoneTabletUtils.Point(n, n2 + 9);
                    this.drawSelectionBox(startPos, endPos);
                }
                Objects.requireNonNull(this.font);
                lineY.add(9);
            });
        }
    }

    private void drawSelectionBox(StoneTabletUtils.Point topLeft, StoneTabletUtils.Point bottomRight) {
        StoneTabletUtils.Point point = new StoneTabletUtils.Point(topLeft.x, topLeft.y);
        StoneTabletUtils.Point point1 = new StoneTabletUtils.Point(bottomRight.x, bottomRight.y);
        if (this.font.isBidirectional()) {
            StoneTabletUtils.adjustPointerAForBidi(this.font, point);
            StoneTabletUtils.adjustPointerAForBidi(this.font, point1);
            int i = point1.x;
            point1.x = point.x;
            point.x = i;
        }
        StoneTabletUtils.pointerToPrecise(point, this.width);
        StoneTabletUtils.pointerToPrecise(point1, this.width);
        RenderSystem.enableColorLogicOp();
        RenderSystem.logicOp((GlStateManager.LogicOp)GlStateManager.LogicOp.OR_REVERSE);
        RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShader(GameRenderer::getPositionShader);
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder bufferbuilder = tesselator.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION);
        bufferbuilder.addVertex((float)point.x, (float)point1.y, 0.0f);
        bufferbuilder.addVertex((float)point1.x, (float)point1.y, 0.0f);
        bufferbuilder.addVertex((float)point1.x, (float)point.y, 0.0f);
        bufferbuilder.addVertex((float)point.x, (float)point.y, 0.0f);
        BufferUploader.drawWithShader((MeshData)bufferbuilder.buildOrThrow());
        RenderSystem.disableColorLogicOp();
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (super.keyPressed(keyCode, scanCode, modifiers)) {
            return true;
        }
        return this.handleSpecialKey(keyCode);
    }

    public boolean charTyped(char keycode, int modifiers) {
        if (super.charTyped(keycode, modifiers)) {
            return true;
        }
        if (StringUtil.isAllowedChatCharacter((char)keycode) && this.canEdit) {
            this.pageEditor.insertText(Character.toString(keycode));
            return true;
        }
        return false;
    }

    private void sendTabletToServer() {
        if (this.isModified && this.text != null) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CarveStoneTabletPacket(this.text, this.hand), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private void setText(String text) {
        this.text = text;
        this.isModified = true;
    }

    private void setClipboard(String str) {
        if (this.minecraft != null) {
            TextFieldHelper.setClipboardContents((Minecraft)this.minecraft, (String)str);
        }
    }

    private String getClipboard() {
        return this.minecraft != null ? TextFieldHelper.getClipboardContents((Minecraft)this.minecraft) : "";
    }

    private int getTextWidth(String text) {
        return this.font.width(this.font.isBidirectional() ? this.font.bidirectionalShaping(text) : text);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 0) {
            long i = Util.getMillis();
            String s = this.text;
            if (!s.isEmpty()) {
                StoneTabletUtils.Point point = new StoneTabletUtils.Point((int)mouseX, (int)mouseY);
                StoneTabletUtils.pointerToRelative(point, this.width);
                StoneTabletUtils.adjustPointerAForBidi(this.font, point);
                int clickedIndex = StoneTabletUtils.getSelectionIndex(this.font, s, point);
                if (clickedIndex >= 0) {
                    if (i - this.lastClickTime < 250L) {
                        if (!this.pageEditor.isSelecting()) {
                            int start = StringSplitter.getWordPosition((String)s, (int)-1, (int)clickedIndex, (boolean)false);
                            int end = StringSplitter.getWordPosition((String)s, (int)1, (int)clickedIndex, (boolean)false);
                            this.pageEditor.setSelectionRange(start, end);
                        } else {
                            this.pageEditor.selectAll();
                        }
                    } else {
                        this.pageEditor.setCursorPos(clickedIndex, Screen.hasShiftDown());
                    }
                }
            }
            this.lastClickTime = i;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dx, double dy) {
        if (button == 0) {
            String s = this.text;
            StoneTabletUtils.Point point = new StoneTabletUtils.Point((int)mouseX, (int)mouseY);
            StoneTabletUtils.pointerToRelative(point, this.width);
            StoneTabletUtils.adjustPointerAForBidi(this.font, point);
            int index = StoneTabletUtils.getSelectionIndex(this.font, s, point);
            if (index >= 0) {
                this.pageEditor.setCursorPos(index, true);
            }
        }
        return super.mouseDragged(mouseX, mouseY, button, dx, dy);
    }

    private boolean handleSpecialKey(int keyCode) {
        if (Screen.isSelectAll((int)keyCode)) {
            this.pageEditor.selectAll();
            return true;
        }
        if (Screen.isCopy((int)keyCode)) {
            this.pageEditor.copy();
            return true;
        }
        if (Screen.isPaste((int)keyCode) && this.canEdit) {
            this.pageEditor.paste();
            return true;
        }
        if (Screen.isCut((int)keyCode) && this.canEdit) {
            this.pageEditor.cut();
            return true;
        }
        if (this.canEdit) {
            switch (keyCode) {
                case 257: 
                case 335: {
                    this.pageEditor.insertText("\n");
                    return true;
                }
                case 259: {
                    this.pageEditor.removeCharsFromCursor(-1);
                    return true;
                }
                case 261: {
                    this.pageEditor.removeCharsFromCursor(1);
                    return true;
                }
                case 262: {
                    this.pageEditor.moveByChars(1, Screen.hasShiftDown());
                    return true;
                }
                case 263: {
                    this.pageEditor.moveByChars(-1, Screen.hasShiftDown());
                    return true;
                }
                case 264: {
                    this.downPressed();
                    return true;
                }
                case 265: {
                    this.upPressed();
                    return true;
                }
                case 268: {
                    this.homePressed();
                    return true;
                }
                case 269: {
                    this.endPressed();
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private void upPressed() {
        if (!this.text.isEmpty()) {
            StoneTabletUtils.Point point = StoneTabletUtils.createPointer(this.font, this.text, this.pageEditor.getCursorPos());
            if (point.y == 0) {
                this.pageEditor.setCursorPos(0, Screen.hasShiftDown());
            } else {
                int n = point.x + StoneTabletUtils.getSelectionWidth(this.font, this.text, this.pageEditor.getCursorPos()) / 3;
                int n2 = point.y;
                Objects.requireNonNull(this.font);
                int index = StoneTabletUtils.getSelectionIndex(this.font, this.text, new StoneTabletUtils.Point(n, n2 - 9));
                if (index >= 0) {
                    this.pageEditor.setCursorPos(index, Screen.hasShiftDown());
                }
            }
        }
    }

    private void downPressed() {
        if (!this.text.isEmpty()) {
            StoneTabletUtils.Point point = StoneTabletUtils.createPointer(this.font, this.text, this.pageEditor.getCursorPos());
            int textHeight = this.font.wordWrapHeight(this.text + String.valueOf(ChatFormatting.BLACK) + "_", 114);
            int n = point.y;
            Objects.requireNonNull(this.font);
            if (n + 9 == textHeight) {
                this.pageEditor.setCursorPos(this.text.length(), Screen.hasShiftDown());
            } else {
                int n2 = point.x + StoneTabletUtils.getSelectionWidth(this.font, this.text, this.pageEditor.getCursorPos()) / 3;
                int n3 = point.y;
                Objects.requireNonNull(this.font);
                int index = StoneTabletUtils.getSelectionIndex(this.font, this.text, new StoneTabletUtils.Point(n2, n3 + 9));
                if (index >= 0) {
                    this.pageEditor.setCursorPos(index, Screen.hasShiftDown());
                }
            }
        }
    }

    private void homePressed() {
        int index = StoneTabletUtils.getSelectionIndex(this.font, this.text, new StoneTabletUtils.Point(0, StoneTabletUtils.createPointer((Font)this.font, (String)this.text, (int)this.pageEditor.getCursorPos()).y));
        this.pageEditor.setCursorPos(index, Screen.hasShiftDown());
    }

    private void endPressed() {
        int index = StoneTabletUtils.getSelectionIndex(this.font, this.text, new StoneTabletUtils.Point(113, StoneTabletUtils.createPointer((Font)this.font, (String)this.text, (int)this.pageEditor.getCursorPos()).y));
        this.pageEditor.setCursorPos(index, Screen.hasShiftDown());
    }
}

