/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import org.apache.commons.lang3.mutable.MutableInt;

public class StoneTabletUtils {
    public static int getTextWidth(Font font, String text) {
        return font.width(font.isBidirectional() ? font.bidirectionalShaping(text) : text);
    }

    public static Point createPointer(Font font, String pageText, int index) {
        Point point = new Point();
        font.getSplitter().splitLines(pageText, 114, Style.EMPTY, false, (style, start, end) -> {
            if (index > end) {
                int n = point.y;
                Objects.requireNonNull(font);
                point.y = n + 9;
                point.x = 0;
            } else if (index >= start) {
                point.x = StoneTabletUtils.getTextWidth(font, pageText.substring(start, index));
            }
        });
        return point;
    }

    public static void adjustPointerAForBidi(Font font, Point pointer) {
        if (font.isBidirectional()) {
            pointer.x = 114 - pointer.x;
        }
    }

    public static void pointerToRelative(Point pointer, int width) {
        pointer.x = pointer.x - (width - 192) / 2 - 36;
        pointer.y -= 32;
    }

    public static void pointerToPrecise(Point pointer, int width) {
        pointer.x = pointer.x + (width - 192) / 2 + 36;
        pointer.y += 32;
    }

    public static int getSelectionX(Font font, String text, int pointerX) {
        if (pointerX < 0) {
            return 0;
        }
        float f1 = 0.0f;
        boolean flag = false;
        String s = text + " ";
        for (int i = 0; i < s.length(); ++i) {
            char c0 = s.charAt(i);
            float f2 = font.width(String.valueOf(c0));
            if (c0 == '\u00a7' && i < s.length() - 1) {
                if ((c0 = s.charAt(++i)) != 'l' && c0 != 'L') {
                    if (c0 == 'r' || c0 == 'R') {
                        flag = false;
                    }
                } else {
                    flag = true;
                }
                f2 = 0.0f;
            }
            float f = f1;
            f1 += f2;
            if (flag && f2 > 0.0f) {
                f1 += 1.0f;
            }
            if (!((float)pointerX >= f) || !((float)pointerX < f1)) continue;
            return i;
        }
        if ((float)pointerX >= f1) {
            return s.length() - 1;
        }
        return -1;
    }

    public static int getSelectionIndex(Font font, String text, Point pointer) {
        Objects.requireNonNull(font);
        int maxY = 16 * 9;
        if (pointer.y >= 0 && pointer.y < maxY) {
            MutableInt lineY = new MutableInt();
            MutableInt index = new MutableInt(text.length());
            font.getSplitter().splitLines(text, 114, Style.EMPTY, true, (style, start, end) -> {
                int n = lineY.intValue();
                Objects.requireNonNull(font);
                int nextLineY = n + 9;
                if (pointer.y >= lineY.intValue() && pointer.y < nextLineY) {
                    int lineIdx = StoneTabletUtils.getSelectionX(font, text.substring(start, end), pointer.x);
                    index.setValue(lineIdx < 0 ? -1 : start + lineIdx);
                }
                lineY.setValue(nextLineY);
            });
            return index.intValue();
        }
        return -1;
    }

    public static int getSelectionWidth(Font font, String pageText, int selectionEnd) {
        return font.width(String.valueOf(pageText.charAt(Mth.clamp((int)selectionEnd, (int)0, (int)(pageText.length() - 1)))));
    }

    public static class Point {
        public int x;
        public int y;

        public Point() {
        }

        public Point(int xIn, int yIn) {
            this.x = xIn;
            this.y = yIn;
        }
    }
}

