/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mraof.minestuck.blockentity.redstone.StructureCoreBlockEntity;
import com.mraof.minestuck.network.block.StructureCoreSettingsPacket;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class StructureCoreScreen
extends Screen {
    public static final String TITLE = "minestuck.structure_core";
    private static final ResourceLocation GUI_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/generic_medium.png");
    private static final int GUI_WIDTH = 150;
    private static final int GUI_HEIGHT = 98;
    private final StructureCoreBlockEntity be;
    private StructureCoreBlockEntity.ActionType actionType;
    private int shutdownRange;
    private Button incrementButton;
    private Button decrementButton;
    private Button largeIncrementButton;
    private Button largeDecrementButton;
    private Button typeButton;

    StructureCoreScreen(StructureCoreBlockEntity be) {
        super((Component)Component.translatable((String)TITLE));
        this.be = be;
        this.actionType = be.getActionType();
        this.shutdownRange = be.getShutdownRange();
    }

    public void init() {
        int yOffset = this.height / 2 - 49;
        this.incrementButton = new ExtendedButton(this.width / 2 + 20, (this.height - 98) / 2 + 12, 20, 20, (Component)Component.literal((String)"+"), button -> this.changeRange(1));
        this.addRenderableWidget((GuiEventListener)this.incrementButton);
        this.decrementButton = new ExtendedButton(this.width / 2 - 40, (this.height - 98) / 2 + 12, 20, 20, (Component)Component.literal((String)"-"), button -> this.changeRange(-1));
        this.addRenderableWidget((GuiEventListener)this.decrementButton);
        this.largeIncrementButton = new ExtendedButton(this.width / 2 + 45, (this.height - 98) / 2 + 12, 20, 20, (Component)Component.literal((String)"++"), button -> this.changeRange(10));
        this.addRenderableWidget((GuiEventListener)this.largeIncrementButton);
        this.largeDecrementButton = new ExtendedButton(this.width / 2 - 65, (this.height - 98) / 2 + 12, 20, 20, (Component)Component.literal((String)"--"), button -> this.changeRange(-10));
        this.addRenderableWidget((GuiEventListener)this.largeDecrementButton);
        this.typeButton = new ExtendedButton(this.width / 2 - 67, yOffset + 40, 135, 20, (Component)Component.literal((String)this.actionType.getNameNoSpaces()), button -> this.changeActionType());
        this.addRenderableWidget((GuiEventListener)this.typeButton);
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 2 - 18, yOffset + 70, 40, 20, (Component)Component.literal((String)"DONE"), button -> this.finish()));
    }

    private void changeActionType() {
        this.actionType = StructureCoreBlockEntity.ActionType.fromInt(this.actionType.ordinal() < StructureCoreBlockEntity.ActionType.values().length - 1 ? this.actionType.ordinal() + 1 : 0);
        this.typeButton.setMessage((Component)Component.literal((String)this.actionType.getNameNoSpaces()));
    }

    private void changeRange(int change) {
        this.shutdownRange = Mth.clamp((int)(this.shutdownRange + change), (int)1, (int)64);
        this.incrementButton.active = this.shutdownRange < 64;
        this.decrementButton.active = this.shutdownRange > 1;
        this.largeIncrementButton.active = this.shutdownRange < 64;
        this.largeDecrementButton.active = this.shutdownRange > 1;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int yOffset = this.height / 2 - 49;
        guiGraphics.blit(GUI_BACKGROUND, this.width / 2 - 75, yOffset, 0, 0, 150, 98);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, Integer.toString(this.shutdownRange), this.width / 2 - 5, (this.height - 98) / 2 + 16, 0x404040, false);
    }

    private void finish() {
        PacketDistributor.sendToServer((CustomPacketPayload)new StructureCoreSettingsPacket(this.actionType, this.shutdownRange, this.be.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }
}

