/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mraof.minestuck.block.redstone.SummonerBlock;
import com.mraof.minestuck.blockentity.redstone.SummonerBlockEntity;
import com.mraof.minestuck.network.block.SummonerSettingsPacket;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class SummonerScreen
extends Screen {
    public static final String TITLE = "minestuck.summoner";
    public static final String CURRENT_ENTITY_TYPE_MESSAGE = "minestuck.current_entity_type";
    public static final String DONE_MESSAGE = "minestuck.summoner.done";
    public static final String UNTRIGGERABLE_MESSAGE = "minestuck.summoner.untriggerable";
    public static final String TRIGGERABLE_MESSAGE = "minestuck.summoner.triggerable";
    private static final ResourceLocation GUI_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/generic_medium.png");
    private static final int GUI_WIDTH = 150;
    private static final int GUI_HEIGHT = 98;
    private final SummonerBlockEntity be;
    private boolean isUntriggerable;
    private int summonRange;
    private Button incrementButton;
    private Button decrementButton;
    private Button largeIncrementButton;
    private Button largeDecrementButton;
    private Button unTriggerableButton;
    private EditBox entityTypeTextField;

    SummonerScreen(SummonerBlockEntity be) {
        super((Component)Component.translatable((String)TITLE));
        this.be = be;
        this.summonRange = be.getSummonRange();
        this.isUntriggerable = (Boolean)be.getBlockState().getValue((Property)SummonerBlock.UNTRIGGERABLE);
    }

    public void init() {
        int yOffset = this.height / 2 - 49;
        this.incrementButton = new ExtendedButton(this.width / 2 + 20, (this.height - 98) / 2 + 12, 20, 20, (Component)Component.literal((String)"+"), button -> this.changeRange(1));
        this.addRenderableWidget((GuiEventListener)this.incrementButton);
        this.decrementButton = new ExtendedButton(this.width / 2 - 40, (this.height - 98) / 2 + 12, 20, 20, (Component)Component.literal((String)"-"), button -> this.changeRange(-1));
        this.addRenderableWidget((GuiEventListener)this.decrementButton);
        this.largeIncrementButton = new ExtendedButton(this.width / 2 + 45, (this.height - 98) / 2 + 12, 20, 20, (Component)Component.literal((String)"++"), button -> this.changeRange(10));
        this.addRenderableWidget((GuiEventListener)this.largeIncrementButton);
        this.largeDecrementButton = new ExtendedButton(this.width / 2 - 65, (this.height - 98) / 2 + 12, 20, 20, (Component)Component.literal((String)"--"), button -> this.changeRange(-10));
        this.addRenderableWidget((GuiEventListener)this.largeDecrementButton);
        this.entityTypeTextField = new EditBox(this.font, this.width / 2 - 60, yOffset + 40, 120, 18, (Component)Component.translatable((String)CURRENT_ENTITY_TYPE_MESSAGE));
        this.entityTypeTextField.setValue(EntityType.getKey(this.be.getSummonedEntity()).toString());
        this.addRenderableWidget((GuiEventListener)this.entityTypeTextField);
        this.unTriggerableButton = new ExtendedButton(this.width / 2 - 65, yOffset + 70, 85, 20, this.getTriggerableButtonMessage(), button -> this.cycleUntriggerable());
        this.addRenderableWidget((GuiEventListener)this.unTriggerableButton);
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 2 + 25, yOffset + 70, 40, 20, (Component)Component.translatable((String)DONE_MESSAGE), button -> this.finish()));
    }

    private void changeRange(int change) {
        this.summonRange = Mth.clamp((int)(this.summonRange + change), (int)1, (int)64);
        this.incrementButton.active = this.summonRange < 64;
        this.decrementButton.active = this.summonRange > 1;
        this.largeIncrementButton.active = this.summonRange < 64;
        this.largeDecrementButton.active = this.summonRange > 1;
    }

    private void cycleUntriggerable() {
        this.isUntriggerable = !this.isUntriggerable;
        this.unTriggerableButton.setMessage(this.getTriggerableButtonMessage());
    }

    private Component getTriggerableButtonMessage() {
        return this.isUntriggerable ? Component.translatable((String)UNTRIGGERABLE_MESSAGE) : Component.translatable((String)TRIGGERABLE_MESSAGE);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.blit(GUI_BACKGROUND, (this.width - 150) / 2, (this.height - 98) / 2, 0, 0, 150, 98);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, Integer.toString(this.summonRange), this.width / 2 - 5, (this.height - 98) / 2 + 16, 0x404040, false);
    }

    private void finish() {
        Optional attemptedEntityType = EntityType.byString((String)this.entityTypeTextField.getValue());
        if (attemptedEntityType.isPresent()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new SummonerSettingsPacket(this.isUntriggerable, this.summonRange, (EntityType)attemptedEntityType.get(), this.be.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.onClose();
        } else {
            this.entityTypeTextField.setTextColor(0xFF0000);
        }
    }
}

