/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mraof.minestuck.network.TitleSelectPackets;
import com.mraof.minestuck.player.EnumAspect;
import com.mraof.minestuck.player.EnumClass;
import com.mraof.minestuck.player.Title;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class TitleSelectorScreen
extends Screen {
    public static final String TITLE = "minestuck.title_selector";
    public static final String SELECT_TITLE = "minestuck.select_title";
    public static final String USED_TITLE = "minestuck.select_title.used";
    public static final String SELECT = "minestuck.select_title.select";
    public static final String RANDOMIZE = "minestuck.select_title.randomize";
    private static final ResourceLocation guiBackground = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/title_selector.png");
    private static final int guiWidth = 186;
    private static final int guiHeight = 157;
    private EnumClass currentClass;
    private EnumAspect currentAspect;
    private final Button[] classButtons = new Button[12];
    private final Button[] aspectButtons = new Button[12];
    private Button selectButton;
    private final Title previous;

    TitleSelectorScreen(Title title) {
        super((Component)Component.translatable((String)TITLE));
        this.previous = title;
    }

    public void init() {
        int i;
        int leftX = (this.width - 186) / 2;
        int topY = (this.height - 157) / 2;
        for (EnumClass enumClass : EnumClass.values()) {
            i = EnumClass.getIntFromClass(enumClass);
            if (i >= 12) continue;
            Component className = enumClass.asTextComponent();
            ExtendedButton button2 = new ExtendedButton(leftX + 4 + i % 2 * 40, topY + 24 + i / 2 * 16, 40, 16, className, button1 -> this.pickClass(c));
            this.addRenderableWidget((GuiEventListener)button2);
            this.classButtons[i] = button2;
        }
        for (Enum enum_ : EnumAspect.values()) {
            i = EnumAspect.getIntFromAspect((EnumAspect)enum_);
            if (i >= 12) continue;
            Component aspectName = ((EnumAspect)enum_).asTextComponent();
            ExtendedButton button2 = new ExtendedButton(leftX + 102 + i % 2 * 40, topY + 24 + i / 2 * 16, 40, 16, aspectName, arg_0 -> this.lambda$init$1((EnumAspect)enum_, arg_0));
            this.addRenderableWidget((GuiEventListener)button2);
            this.aspectButtons[i] = button2;
        }
        this.selectButton = new ExtendedButton(leftX + 24, topY + 128, 60, 20, (Component)Component.translatable((String)SELECT), button -> this.select());
        this.addRenderableWidget((GuiEventListener)this.selectButton);
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(leftX + 102, topY + 128, 60, 20, (Component)Component.translatable((String)RANDOMIZE), button -> this.random()));
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int xOffset = (this.width - 186) / 2;
        int yOffset = (this.height - 157) / 2;
        guiGraphics.blit(guiBackground, xOffset, yOffset, 0, 0, 186, 157);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.selectButton.active = this.currentClass != null && this.currentAspect != null;
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int yOffset = (this.height - 157) / 2;
        String message = this.previous == null ? I18n.get((String)SELECT_TITLE, (Object[])new Object[0]) : I18n.get((String)USED_TITLE, (Object[])new Object[]{this.previous.asTextComponent().getString()});
        guiGraphics.drawString(this.font, message, (float)this.width / 2.0f - (float)this.font.width(message) / 2.0f, (float)(yOffset + 10), 0x404040, false);
        message = I18n.get((String)"title.format", (Object[])new Object[]{"", ""});
        float f = (float)this.width / 2.0f - (float)this.font.width(message) / 2.0f;
        float f2 = yOffset + 72;
        Objects.requireNonNull(this.font);
        guiGraphics.drawString(this.font, message, f, f2 - 9.0f / 2.0f, 0x404040, false);
    }

    private void pickClass(EnumClass c) {
        if (this.currentClass != null) {
            this.classButtons[EnumClass.getIntFromClass((EnumClass)this.currentClass)].active = true;
        }
        this.currentClass = c;
        this.classButtons[EnumClass.getIntFromClass((EnumClass)this.currentClass)].active = false;
    }

    private void pickAspect(EnumAspect a) {
        if (this.currentAspect != null) {
            this.aspectButtons[EnumAspect.getIntFromAspect((EnumAspect)this.currentAspect)].active = true;
        }
        this.currentAspect = a;
        this.aspectButtons[EnumAspect.getIntFromAspect((EnumAspect)this.currentAspect)].active = false;
    }

    private void select() {
        PacketDistributor.sendToServer((CustomPacketPayload)TitleSelectPackets.PickTitle.pick(new Title(this.currentClass, this.currentAspect)), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }

    private void random() {
        PacketDistributor.sendToServer((CustomPacketPayload)TitleSelectPackets.PickTitle.random(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    private /* synthetic */ void lambda$init$1(EnumAspect a, Button button1) {
        this.pickAspect(a);
    }
}

