/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mraof.minestuck.blockentity.TransportalizerBlockEntity;
import com.mraof.minestuck.network.block.TransportalizerPackets;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class TransportalizerScreen
extends Screen {
    public static final String TITLE = "minestuck.transportalizer";
    public static final String DESTINATION_CODE_MESSAGE = "minestuck.transportalizer.destination_code";
    public static final String DONE_MESSAGE = "minestuck.transportalizer.done";
    private static final ResourceLocation guiBackground = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/generic_small.png");
    private static final int guiWidth = 126;
    private static final int guiHeight = 98;
    TransportalizerBlockEntity be;
    private EditBox destinationTextField;
    private Button doneButton;

    TransportalizerScreen(TransportalizerBlockEntity be) {
        super((Component)Component.translatable((String)TITLE));
        this.be = be;
    }

    public void init() {
        int yOffset = this.height / 2 - 49;
        this.destinationTextField = new EditBox(this.font, this.width / 2 - 20, yOffset + 25, 40, 20, (Component)Component.translatable((String)DESTINATION_CODE_MESSAGE));
        this.destinationTextField.setCanLoseFocus(false);
        this.destinationTextField.setMaxLength(4);
        this.destinationTextField.setValue(this.be.getDestId());
        this.destinationTextField.setResponder(s -> {
            this.doneButton.active = s.length() == 4;
        });
        this.addRenderableWidget((GuiEventListener)this.destinationTextField);
        this.setInitialFocus((GuiEventListener)this.destinationTextField);
        this.doneButton = new ExtendedButton(this.width / 2 - 20, yOffset + 50, 40, 20, (Component)Component.translatable((String)DONE_MESSAGE), button -> this.finish());
        this.addRenderableWidget((GuiEventListener)this.doneButton);
        this.doneButton.active = this.destinationTextField.getValue().length() == 4;
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int yOffset = this.height / 2 - 49;
        guiGraphics.blit(guiBackground, this.width / 2 - 63, yOffset, 0, 0, 126, 98);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        int yOffset = this.height / 2 - 49;
        if (!this.be.hasId()) {
            guiGraphics.drawString(this.font, "Enter ID:", (float)this.width / 2.0f - (float)this.font.width("Enter ID:") / 2.0f, (float)(yOffset + 10), 0x404040, false);
        } else {
            guiGraphics.drawString(this.font, this.be.getId(), (float)this.width / 2.0f - (float)this.font.width(this.be.getId()) / 2.0f, (float)(yOffset + 10), this.be.isActive() ? 0x404040 : 0xFF0000, false);
        }
    }

    private void finish() {
        String text = this.destinationTextField.getValue().toUpperCase();
        if (text.length() != 4) {
            return;
        }
        if (this.be.hasId()) {
            TransportalizerPackets.SetDestId packet = new TransportalizerPackets.SetDestId(this.be.getBlockPos(), text);
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.minecraft.setScreen(null);
        } else {
            TransportalizerPackets.SetId packet = new TransportalizerPackets.SetId(this.be.getBlockPos(), text);
            PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
            this.minecraft.setScreen(null);
        }
    }
}

