/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui;

import com.mraof.minestuck.blockentity.redstone.WirelessRedstoneTransmitterBlockEntity;
import com.mraof.minestuck.network.block.WirelessRedstoneTransmitterSettingsPacket;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

public class WirelessRedstoneTransmitterScreen
extends Screen {
    public static final String TITLE = "minestuck.wireless_redstone";
    private static final ResourceLocation GUI_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/generic_medium.png");
    private static final int GUI_WIDTH = 150;
    private static final int GUI_HEIGHT = 98;
    WirelessRedstoneTransmitterBlockEntity be;
    private EditBox destinationTextFieldX;
    private EditBox destinationTextFieldY;
    private EditBox destinationTextFieldZ;

    WirelessRedstoneTransmitterScreen(WirelessRedstoneTransmitterBlockEntity be) {
        super((Component)Component.translatable((String)TITLE));
        this.be = be;
    }

    public void init() {
        int yOffset = this.height / 2 - 49;
        this.destinationTextFieldX = new EditBox(this.font, this.width / 2 - 60, yOffset + 10, 40, 20, (Component)Component.literal((String)"X value of destination block pos"));
        this.destinationTextFieldX.setValue(String.valueOf(this.be.getDestinationBlockPosFromOffset().getX()));
        this.addRenderableWidget((GuiEventListener)this.destinationTextFieldX);
        this.destinationTextFieldY = new EditBox(this.font, this.width / 2 - 20, yOffset + 10, 40, 20, (Component)Component.literal((String)"Y value of destination block pos"));
        this.destinationTextFieldY.setValue(String.valueOf(this.be.getDestinationBlockPosFromOffset().getY()));
        this.addRenderableWidget((GuiEventListener)this.destinationTextFieldY);
        this.destinationTextFieldZ = new EditBox(this.font, this.width / 2 + 20, yOffset + 10, 40, 20, (Component)Component.literal((String)"Z value of destination block pos"));
        this.destinationTextFieldZ.setValue(String.valueOf(this.be.getDestinationBlockPosFromOffset().getZ()));
        this.addRenderableWidget((GuiEventListener)this.destinationTextFieldZ);
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 2 - 45, yOffset + 40, 90, 20, (Component)Component.literal((String)"Find Receiver"), button -> this.findReceiver()));
        this.addRenderableWidget((GuiEventListener)new ExtendedButton(this.width / 2 - 20, yOffset + 70, 40, 20, (Component)Component.literal((String)"DONE"), button -> this.finish()));
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        int yOffset = this.height / 2 - 49;
        guiGraphics.blit(GUI_BACKGROUND, this.width / 2 - 75, yOffset, 0, 0, 150, 98);
    }

    private void findReceiver() {
        BlockPos receiverPos = this.be.findReceiver();
        if (receiverPos != null) {
            this.destinationTextFieldX.setValue(String.valueOf(receiverPos.getX()));
            this.destinationTextFieldY.setValue(String.valueOf(receiverPos.getY()));
            this.destinationTextFieldZ.setValue(String.valueOf(receiverPos.getZ()));
        }
    }

    private void finish() {
        PacketDistributor.sendToServer((CustomPacketPayload)new WirelessRedstoneTransmitterSettingsPacket(this.parseBlockPos(), this.be.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.onClose();
    }

    private static int parseInt(EditBox widget) {
        try {
            return Integer.parseInt(widget.getValue());
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    private BlockPos parseBlockPos() {
        int x = WirelessRedstoneTransmitterScreen.parseInt(this.destinationTextFieldX);
        int y = WirelessRedstoneTransmitterScreen.parseInt(this.destinationTextFieldY);
        int z = WirelessRedstoneTransmitterScreen.parseInt(this.destinationTextFieldZ);
        return new BlockPos(x, y, z);
    }
}

