/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.captchalouge;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.client.gui.captchalouge.SylladexScreen;
import com.mraof.minestuck.inventory.captchalogue.HashMapModus;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.network.CaptchaDeckPackets;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

public class HashMapSylladexScreen
extends SylladexScreen {
    public static final String EJECT_BY_CHAT_ON = "minestuck.eject_by_chat.on";
    public static final String EJECT_BY_CHAT_OFF = "minestuck.eject_by_chat.off";
    private final HashMapModus modus;
    private Button guiButton;

    public HashMapSylladexScreen(Modus modus) {
        this.modus = (HashMapModus)modus;
        this.textureIndex = 4;
    }

    @Override
    public void init() {
        super.init();
        this.guiButton = new ExtendedButton((this.width - 256) / 2 + 15, (this.height - 202) / 2 + 175, 120, 20, (Component)Component.empty(), button -> this.changeSetting());
        this.addRenderableWidget((GuiEventListener)this.guiButton);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
        this.guiButton.setX((this.width - 256) / 2 + 15);
        this.guiButton.setY((this.height - 202) / 2 + 175);
        boolean active = MinestuckConfig.SERVER.hashmapChatModusSetting.get() == MinestuckConfig.AvailableOptions.BOTH ? this.modus.ejectByChat : MinestuckConfig.SERVER.hashmapChatModusSetting.get() == MinestuckConfig.AvailableOptions.ON;
        this.guiButton.setMessage((Component)Component.translatable((String)(active ? EJECT_BY_CHAT_ON : EJECT_BY_CHAT_OFF)));
        this.guiButton.active = MinestuckConfig.SERVER.hashmapChatModusSetting.get() == MinestuckConfig.AvailableOptions.BOTH;
        super.render(guiGraphics, mouseX, mouseY, f);
    }

    @Override
    public void updateContent() {
        NonNullList<ItemStack> stacks = this.modus.getItems();
        this.cards.clear();
        this.maxWidth = Math.max(this.mapWidth, 10 + (stacks.size() * 21 + (stacks.size() - 1) * 5));
        this.maxHeight = this.mapHeight;
        super.updateContent();
        int start = Math.max(5, (this.mapWidth - (stacks.size() * 21 + (stacks.size() - 1) * 5)) / 2);
        for (int i = 0; i < stacks.size(); ++i) {
            this.cards.add(new SylladexScreen.GuiCard(this, (ItemStack)stacks.get(i), this, i, start + i * 26, (this.mapHeight - 26) / 2){

                @Override
                public void onClick(int mouseButton) {
                    if (this.item != null && mouseButton == 1) {
                        PacketDistributor.sendToServer((CustomPacketPayload)new CaptchaDeckPackets.GetItem(this.index, true), (CustomPacketPayload[])new CustomPacketPayload[0]);
                    } else {
                        super.onClick(mouseButton);
                    }
                }
            });
        }
    }

    @Override
    public void updatePosition() {
        this.maxWidth = Math.max(this.mapWidth, 10 + (this.cards.size() * 21 + (this.cards.size() - 1) * 5));
        this.maxHeight = this.mapHeight;
        int start = Math.max(5, (this.mapWidth - (this.cards.size() * 21 + (this.cards.size() - 1) * 5)) / 2);
        for (int i = 0; i < this.cards.size(); ++i) {
            SylladexScreen.GuiCard card = (SylladexScreen.GuiCard)this.cards.get(i);
            card.xPos = start + i * 26;
            card.yPos = (this.mapHeight - 26) / 2;
        }
    }

    @Override
    public void drawGuiMap(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.drawGuiMap(guiGraphics, mouseX, mouseY);
        int n = this.mapHeight / 2 - 13 - 3;
        Objects.requireNonNull(this.font);
        int y = n - 9;
        int start = Math.max(5, (this.mapWidth - (this.cards.size() * 21 + (this.cards.size() - 1) * 5)) / 2);
        for (int i = 0; i < this.cards.size(); ++i) {
            String s = String.valueOf(i);
            int width = this.font.width(s);
            int x = start + i * 26 + 10 - this.mapX - width / 2;
            if (x + width <= 0 || x >= this.mapWidth) continue;
            guiGraphics.drawString(this.font, s, x, y, 0, false);
        }
    }

    private void changeSetting() {
        if (MinestuckConfig.SERVER.hashmapChatModusSetting.get() == MinestuckConfig.AvailableOptions.BOTH) {
            this.modus.ejectByChat = !this.modus.ejectByChat;
            PacketDistributor.sendToServer((CustomPacketPayload)new CaptchaDeckPackets.SetModusParameter(0, this.modus.ejectByChat ? 1 : 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }
}

