/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.captchalouge;

import com.mraof.minestuck.client.gui.captchalouge.SylladexScreen;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.ItemStack;

public class StackSylladexScreen
extends SylladexScreen {
    private final Modus modus;

    public StackSylladexScreen(Modus modus) {
        this.modus = modus;
        this.textureIndex = 0;
    }

    @Override
    public void updateContent() {
        NonNullList<ItemStack> stacks = this.modus.getItems();
        this.cards.clear();
        this.maxWidth = Math.max(this.mapWidth, 10 + (stacks.size() * 21 + (stacks.size() - 1) * 5));
        this.maxHeight = this.mapHeight;
        super.updateContent();
        int start = Math.max(5, (this.mapWidth - (stacks.size() * 21 + (stacks.size() - 1) * 5)) / 2);
        for (int i = 0; i < stacks.size(); ++i) {
            this.cards.add(new SylladexScreen.GuiCard((ItemStack)stacks.get(i), this, i == 0 ? 0 : -1, start + i * 26, (this.mapHeight - 26) / 2));
        }
    }

    @Override
    public void updatePosition() {
        this.maxWidth = Math.max(this.mapWidth, 10 + (this.cards.size() * 21 + (this.cards.size() - 1) * 5));
        this.maxHeight = this.mapHeight;
        int start = Math.max(5, (this.mapWidth - (this.cards.size() * 21 + (this.cards.size() - 1) * 5)) / 2);
        for (int i = 0; i < this.cards.size(); ++i) {
            SylladexScreen.GuiCard card = (SylladexScreen.GuiCard)this.cards.get(i);
            card.xPos = start + i * 26;
            card.yPos = (this.mapHeight - 26) / 2;
        }
    }

    @Override
    public void drawGuiMap(GuiGraphics guiGraphics, int xcor, int ycor) {
        super.drawGuiMap(guiGraphics, xcor, ycor);
        if (!this.cards.isEmpty()) {
            int startX = Math.max(0, ((SylladexScreen.GuiCard)this.cards.get((int)0)).xPos + 21 - this.mapX);
            int endX = Math.min(this.mapWidth, ((SylladexScreen.GuiCard)this.cards.get((int)(this.cards.size() - 1))).xPos - this.mapX);
            int y = this.mapHeight / 2 + 1;
            guiGraphics.fill(startX, y, endX, y + 2, -16777216);
        }
    }
}

