/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.captchalouge;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.client.util.MSKeyHandler;
import com.mraof.minestuck.network.CaptchaDeckPackets;
import com.mraof.minestuck.player.ClientPlayerData;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.ConfirmScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;
import org.joml.Matrix4fStack;

@ParametersAreNonnullByDefault
public abstract class SylladexScreen
extends Screen {
    public static final String TITLE = "minestuck.sylladex";
    public static final String EMPTY_SYLLADEX_1 = "minestuck.empty_sylladex.1";
    public static final String EMPTY_SYLLADEX_2 = "minestuck.empty_sylladex.2";
    public static final String EMPTY_SYLLADEX_BUTTON = "minestuck.empty_sylladex.button";
    protected static final ResourceLocation sylladexFrame = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/sylladex_frame.png");
    protected static final ResourceLocation cardTexture = ResourceLocation.fromNamespaceAndPath((String)"minestuck", (String)"textures/gui/icons.png");
    protected static final int GUI_WIDTH = 256;
    protected static final int GUI_HEIGHT = 202;
    protected static final int MAP_WIDTH = 224;
    protected static final int MAP_HEIGHT = 153;
    protected static final int X_OFFSET = 16;
    protected static final int Y_OFFSET = 17;
    protected static final int CARD_WIDTH = 21;
    protected static final int CARD_HEIGHT = 26;
    protected ArrayList<GuiCard> cards = new ArrayList();
    protected int textureIndex;
    protected int maxWidth;
    protected int maxHeight;
    protected int mapX;
    protected int mapY;
    protected int mapWidth = 224;
    protected int mapHeight = 153;
    protected float scroll = 1.0f;
    protected int mousePosX;
    protected int mousePosY;
    protected boolean mousePressed;
    protected Button emptySylladex;

    public SylladexScreen() {
        super((Component)Component.translatable((String)TITLE));
    }

    public void init() {
        this.emptySylladex = new ExtendedButton((this.width - 256) / 2 + 140, (this.height - 202) / 2 + 175, 100, 20, (Component)Component.translatable((String)EMPTY_SYLLADEX_BUTTON), button -> this.emptySylladex());
        this.addRenderableWidget((GuiEventListener)this.emptySylladex);
        this.updateContent();
    }

    public void render(GuiGraphics guiGraphics, int xcor, int ycor, float f) {
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 202) / 2;
        this.emptySylladex.setX(xOffset + 140);
        this.emptySylladex.setY(yOffset + 175);
        if (this.mousePressed) {
            if (this.isMouseInContainer(xcor, ycor)) {
                if (this.isMouseInContainer(this.mousePosX, this.mousePosY)) {
                    this.mapX = Math.max(0, Math.min(this.maxWidth - this.mapWidth, this.mapX + this.mousePosX - xcor));
                    this.mapY = Math.max(0, Math.min(this.maxHeight - this.mapHeight, this.mapY + this.mousePosY - ycor));
                }
                this.mousePosX = xcor;
                this.mousePosY = ycor;
            }
        } else {
            this.mousePosX = -1;
            this.mousePosY = -1;
        }
        super.render(guiGraphics, xcor, ycor, f);
        Matrix4fStack modelPoseStack = RenderSystem.getModelViewStack();
        modelPoseStack.pushMatrix();
        modelPoseStack.translate((float)(xOffset + 16), (float)(yOffset + 17), 0.0f);
        modelPoseStack.scale(1.0f / this.scroll, 1.0f / this.scroll, 1.0f);
        RenderSystem.applyModelViewMatrix();
        this.drawGuiMap(guiGraphics, xcor, ycor);
        ArrayList<GuiCard> visibleCards = new ArrayList<GuiCard>();
        for (GuiCard card : this.cards) {
            if (card.xPos + 21 <= this.mapX || card.xPos >= this.mapX + this.mapWidth || card.yPos + 26 <= this.mapY || card.yPos >= this.mapY + this.mapHeight) continue;
            visibleCards.add(card);
        }
        for (GuiCard card : visibleCards) {
            card.drawItemBackground(guiGraphics);
        }
        for (GuiCard card : visibleCards) {
            card.drawItem(guiGraphics);
        }
        modelPoseStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableDepthTest();
        guiGraphics.drawString(this.font, this.getTitle().getString(), xOffset + 15, yOffset + 5, 0x404040, false);
        String str = ClientPlayerData.getModus().getName().getString();
        guiGraphics.drawString(this.font, str, xOffset + 256 - this.font.width(str) - 16, yOffset + 5, 0x404040, false);
        if (this.isMouseInContainer(xcor, ycor)) {
            int translX = (int)((float)(xcor - xOffset - 16) * this.scroll);
            int translY = (int)((float)(ycor - yOffset - 17) * this.scroll);
            for (GuiCard card : visibleCards) {
                if (translX < card.xPos + 2 - this.mapX || translX >= card.xPos + 18 - this.mapX || translY < card.yPos + 7 - this.mapY || translY >= card.yPos + 23 - this.mapY) continue;
                card.drawTooltip(guiGraphics, xcor, ycor);
                break;
            }
        }
    }

    protected void renderMenuBackground(GuiGraphics guiGraphics) {
        super.renderMenuBackground(guiGraphics);
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 202) / 2;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(sylladexFrame, xOffset, yOffset, 0, 0, 256, 202);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        float prevScroll = this.scroll;
        if (scrollY < 0.0) {
            this.scroll += 0.25f;
        } else if (scrollY > 0.0) {
            this.scroll -= 0.25f;
        }
        this.scroll = Mth.clamp((float)this.scroll, (float)1.0f, (float)2.0f);
        if (prevScroll != this.scroll) {
            double i1 = (double)this.mapX + (double)this.mapWidth / 2.0;
            double i2 = (double)this.mapY + (double)this.mapHeight / 2.0;
            this.mapWidth = Math.round(224.0f * this.scroll);
            this.mapHeight = Math.round(153.0f * this.scroll);
            this.mapX = (int)(i1 - (double)this.mapWidth / 2.0);
            this.mapY = (int)(i2 - (double)this.mapHeight / 2.0);
            this.updatePosition();
            this.mapX = Math.max(0, Math.min(this.maxWidth - this.mapWidth, this.mapX));
            this.mapY = Math.max(0, Math.min(this.maxHeight - this.mapHeight, this.mapY));
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseReleased(double mouseX, double mouseY, int mouseButton) {
        if (this.mousePressed) {
            this.mousePressed = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (this.isMouseInContainer(mouseX, mouseY)) {
            int xOffset = (this.width - 256) / 2;
            int yOffset = (this.height - 202) / 2;
            int translX = (int)((mouseX - (double)xOffset - 16.0) * (double)this.scroll);
            int translY = (int)((mouseY - (double)yOffset - 17.0) * (double)this.scroll);
            for (GuiCard card : this.cards) {
                if (translX < card.xPos + 2 - this.mapX || translX >= card.xPos + 18 - this.mapX || translY < card.yPos + 7 - this.mapY || translY >= card.yPos + 23 - this.mapY) continue;
                card.onClick(mouseButton);
                return true;
            }
            this.mousePressed = true;
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    private void emptySylladex() {
        this.minecraft.screen = new ConfirmScreen(this::onEmptyConfirm, (Component)Component.translatable((String)EMPTY_SYLLADEX_1), (Component)Component.translatable((String)EMPTY_SYLLADEX_2));
        this.minecraft.screen.init(this.minecraft, this.width, this.height);
    }

    public boolean keyPressed(int keyCode, int scanCode, int i) {
        if (MSKeyHandler.sylladexKey.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.minecraft.setScreen(null);
            return true;
        }
        return super.keyPressed(keyCode, scanCode, i);
    }

    public void onEmptyConfirm(boolean result) {
        if (result) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CaptchaDeckPackets.GetItem(-1, false), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.minecraft.screen = this;
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void drawGuiMap(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.fill(0, 0, this.mapWidth, this.mapHeight, -7631989);
    }

    private boolean isMouseInContainer(double xcor, double ycor) {
        int xOffset = (this.width - 256) / 2;
        int yOffset = (this.height - 202) / 2;
        return xcor >= (double)(xOffset + 16) && xcor < (double)(xOffset + 16 + 224) && ycor >= (double)(yOffset + 17) && ycor < (double)(yOffset + 17 + 153);
    }

    public void updateContent() {
        this.mapX = Math.min(this.mapX, this.maxWidth - this.mapWidth);
        this.mapY = Math.min(this.mapY, this.maxHeight - this.mapHeight);
    }

    public abstract void updatePosition();

    public ResourceLocation getCardTexture(GuiCard card) {
        return cardTexture;
    }

    public int getCardTextureX(GuiCard card) {
        return this.textureIndex * 21;
    }

    public int getCardTextureY(GuiCard card) {
        return 96;
    }

    public static class GuiCard {
        protected SylladexScreen gui;
        public ItemStack item;
        public int index;
        public int xPos;
        public int yPos;

        protected GuiCard() {
            this.item = ItemStack.EMPTY;
        }

        public GuiCard(ItemStack item, SylladexScreen gui, int index, int xPos, int yPos) {
            this.gui = gui;
            this.item = item;
            this.index = index;
            this.xPos = xPos;
            this.yPos = yPos;
        }

        public void onClick(int mouseButton) {
            int toSend = -1;
            if (this.item.isEmpty() && mouseButton == 1) {
                toSend = -2;
            } else if (this.index != -1 && (mouseButton == 0 || mouseButton == 1)) {
                toSend = this.index;
            }
            if (toSend != -1) {
                PacketDistributor.sendToServer((CustomPacketPayload)new CaptchaDeckPackets.GetItem(toSend, mouseButton != 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }

        protected void drawItemBackground(GuiGraphics guiGraphics) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int minX = 0;
            int maxX = 21;
            int minY = 0;
            int maxY = 26;
            if (this.xPos + minX < this.gui.mapX) {
                minX += this.gui.mapX - (this.xPos + minX);
            } else if (this.xPos + maxX > this.gui.mapX + this.gui.mapWidth) {
                maxX -= this.xPos + maxX - (this.gui.mapX + this.gui.mapWidth);
            }
            if (this.yPos + minY < this.gui.mapY) {
                minY += this.gui.mapY - (this.yPos + minY);
            } else if (this.yPos + maxY > this.gui.mapY + this.gui.mapHeight) {
                maxY -= this.yPos + maxY - (this.gui.mapY + this.gui.mapHeight);
            }
            guiGraphics.blit(this.gui.getCardTexture(this), this.xPos + minX - this.gui.mapX, this.yPos + minY - this.gui.mapY, this.gui.getCardTextureX(this) + minX, this.gui.getCardTextureY(this) + minY, maxX - minX, maxY - minY);
        }

        protected void drawItem(GuiGraphics guiGraphics) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!this.item.isEmpty()) {
                int x = this.xPos + 2 - this.gui.mapX;
                int y = this.yPos + 7 - this.gui.mapY;
                if (x >= this.gui.mapWidth || y >= this.gui.mapHeight || x + 16 < 0 || y + 16 < 0) {
                    return;
                }
                guiGraphics.renderItem(this.item, x, y);
                guiGraphics.renderItemDecorations(this.gui.font, this.item, x, y);
            }
        }

        protected void drawTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            if (!this.item.isEmpty()) {
                guiGraphics.renderTooltip(this.gui.font, this.item, mouseX, mouseY);
            }
        }
    }

    public static class ModusSizeCard
    extends GuiCard {
        public int size;

        public ModusSizeCard(SylladexScreen gui, int size, int xPos, int yPos) {
            this.gui = gui;
            this.index = -1;
            this.size = size;
            this.xPos = xPos;
            this.yPos = yPos;
        }

        @Override
        protected void drawTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        }

        @Override
        protected void drawItem(GuiGraphics guiGraphics) {
            block2: {
                int y;
                int x;
                String stackSize;
                block4: {
                    block3: {
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        if (this.size <= 1) break block2;
                        stackSize = String.valueOf(this.size);
                        x = this.xPos - this.gui.mapX + 18 - this.gui.font.width(stackSize);
                        y = this.yPos - this.gui.mapY + 15;
                        if (x >= this.gui.mapWidth || y >= this.gui.mapHeight || x + this.gui.font.width(stackSize) < 0) break block3;
                        Objects.requireNonNull(this.gui.font);
                        if (y + 9 >= 0) break block4;
                    }
                    return;
                }
                RenderSystem.disableDepthTest();
                RenderSystem.disableBlend();
                guiGraphics.drawString(this.gui.font, stackSize, x, y, 0xC6C6C6);
                RenderSystem.enableDepthTest();
                RenderSystem.enableBlend();
            }
        }
    }
}

