/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.captchalouge;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.client.gui.captchalouge.SylladexScreen;
import com.mraof.minestuck.inventory.captchalogue.Modus;
import com.mraof.minestuck.inventory.captchalogue.TreeModus;
import com.mraof.minestuck.network.CaptchaDeckPackets;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

public class TreeSylladexScreen
extends SylladexScreen {
    public static final String AUTOBALANCE_ON = "minestuck.autobalance.on";
    public static final String AUTOBALANCE_OFF = "minestuck.autobalance.off";
    protected TreeModus modus;
    protected int maxDepth;
    protected int xOffset;
    protected int yOffset;
    protected SylladexScreen.GuiCard[] guiIndexList;
    protected Button guiButton;

    public TreeSylladexScreen(Modus modus) {
        this.modus = (TreeModus)modus;
        this.textureIndex = 3;
    }

    @Override
    public void init() {
        super.init();
        this.guiButton = new ExtendedButton((this.width - 256) / 2 + 15, (this.height - 202) / 2 + 175, 120, 20, (Component)Component.empty(), button -> this.changeSetting());
        this.addRenderableWidget((GuiEventListener)this.guiButton);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
        this.guiButton.setX((this.width - 256) / 2 + 15);
        this.guiButton.setY((this.height - 202) / 2 + 175);
        boolean autobalance = MinestuckConfig.SERVER.treeModusSetting.get() == MinestuckConfig.AvailableOptions.BOTH ? this.modus.autoBalance : MinestuckConfig.SERVER.treeModusSetting.get() == MinestuckConfig.AvailableOptions.ON;
        this.guiButton.setMessage((Component)Component.translatable((String)(autobalance ? AUTOBALANCE_ON : AUTOBALANCE_OFF)));
        this.guiButton.active = MinestuckConfig.SERVER.treeModusSetting.get() == MinestuckConfig.AvailableOptions.BOTH;
        super.render(guiGraphics, mouseX, mouseY, f);
    }

    @Override
    public void updateContent() {
        int size;
        this.maxDepth = this.getDepthIndex(this.modus.node);
        int pow = (int)Math.pow(2.0, this.maxDepth);
        this.maxHeight = Math.max(this.mapHeight, 26 * (this.maxDepth + 1) + 20 * this.maxDepth + 20);
        this.maxWidth = Math.max(this.mapWidth, pow * 21 + 20);
        this.xOffset = (this.maxWidth - pow * 21) / 2;
        this.yOffset = (this.maxHeight - 26 * (this.maxDepth + 1) - 20 * this.maxDepth) / 2;
        this.guiIndexList = new SylladexScreen.GuiCard[(int)Math.pow(2.0, this.maxDepth + 1) - 1];
        this.cards.clear();
        this.addNodes(this.modus.node, 0, 0, 0);
        int n = size = this.modus.node == null ? 0 : this.modus.node.getSize();
        if (this.modus.size > size) {
            this.cards.add(new SylladexScreen.ModusSizeCard(this, this.modus.size - size, 10, 10));
        }
        super.updateContent();
    }

    protected int getDepthIndex(TreeModus.TreeNode node) {
        if (node == null || node.node1 == null && node.node2 == null) {
            return 0;
        }
        return Math.max(this.getDepthIndex(node.node1), this.getDepthIndex(node.node2)) + 1;
    }

    @Override
    public void updatePosition() {
        if (this.maxHeight != Math.max(this.mapHeight, 52 * this.maxDepth + 26) || this.maxWidth != Math.max(this.mapWidth, (int)Math.pow(2.0, this.maxDepth - 1) * 21 + 42)) {
            this.updateContent();
        }
    }

    @Override
    public void drawGuiMap(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.drawGuiMap(guiGraphics, mouseX, mouseY);
        if (this.guiIndexList[0] != null) {
            this.drawNodeLines(guiGraphics, 0, 0);
        }
    }

    private void changeSetting() {
        if (MinestuckConfig.SERVER.treeModusSetting.get() == MinestuckConfig.AvailableOptions.BOTH) {
            this.modus.autoBalance = !this.modus.autoBalance;
            PacketDistributor.sendToServer((CustomPacketPayload)new CaptchaDeckPackets.SetModusParameter(0, this.modus.autoBalance ? 1 : 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    protected void drawNodeLines(GuiGraphics guiGraphics, int index, int depth) {
        SylladexScreen.GuiCard other;
        if (depth >= this.maxDepth) {
            return;
        }
        SylladexScreen.GuiCard card = this.guiIndexList[index];
        if (this.guiIndexList[index * 2 + 1] != null) {
            other = this.guiIndexList[index * 2 + 1];
            if (this.mapX < card.xPos + 10 && this.mapX + this.mapWidth > card.xPos + 9 && this.mapY < card.yPos + 26 + 6 && this.mapY + this.mapHeight > card.yPos + 26) {
                guiGraphics.fill(card.xPos + 9 - this.mapX, card.yPos + 26 - this.mapY, card.xPos + 10 - this.mapX, card.yPos + 26 - this.mapY + 6, -16777216);
            }
            if (this.mapX < card.xPos + 10 && this.mapX + this.mapWidth > other.xPos + 10 && this.mapY < card.yPos + 26 + 6 && this.mapY + this.mapHeight > card.yPos + 26 + 5) {
                guiGraphics.fill(Math.max(0, other.xPos - this.mapX + 10), card.yPos + 26 - this.mapY + 5, Math.min(this.mapWidth, card.xPos + 10 - this.mapX), card.yPos + 26 - this.mapY + 6, -16777216);
            }
            if (this.mapX < other.xPos + 11 && this.mapX + this.mapWidth > other.xPos + 10 && this.mapY < other.yPos && this.mapY + this.mapHeight > card.yPos + 26 + 5) {
                guiGraphics.fill(other.xPos + 10 - this.mapX, card.yPos + 26 + 5 - this.mapY, other.xPos + 11 - this.mapX, other.yPos - this.mapY, -16777216);
            }
            this.drawNodeLines(guiGraphics, index * 2 + 1, depth + 1);
        }
        if (this.guiIndexList[index * 2 + 2] != null) {
            other = this.guiIndexList[index * 2 + 2];
            if (this.mapX < card.xPos + 12 && this.mapX + this.mapWidth > card.xPos + 11 && this.mapY < card.yPos + 26 + 6 && this.mapY + this.mapHeight > card.yPos + 26) {
                guiGraphics.fill(card.xPos + 11 - this.mapX, card.yPos + 26 - this.mapY, card.xPos + 12 - this.mapX, card.yPos + 26 - this.mapY + 6, -16777216);
            }
            if (this.mapX < other.xPos + 10 && this.mapX + this.mapWidth > card.xPos + 11 && this.mapY < card.yPos + 26 + 6 && this.mapY + this.mapHeight > card.yPos + 26 + 5) {
                guiGraphics.fill(Math.max(0, card.xPos + 11 - this.mapX), card.yPos + 26 - this.mapY + 5, Math.min(this.mapWidth, other.xPos + 10 - this.mapX), card.yPos + 26 - this.mapY + 6, -16777216);
            }
            if (this.mapX < other.xPos + 10 && this.mapX + this.mapWidth > other.xPos + 9 && this.mapY < other.yPos && this.mapY + this.mapHeight > card.yPos + 26 + 5) {
                guiGraphics.fill(other.xPos + 9 - this.mapX, card.yPos + 26 + 5 - this.mapY, other.xPos + 10 - this.mapX, other.yPos - this.mapY, -16777216);
            }
            this.drawNodeLines(guiGraphics, index * 2 + 1, depth + 1);
        }
        if (this.guiIndexList[index * 2 + 2] != null) {
            this.drawNodeLines(guiGraphics, index * 2 + 2, depth + 1);
        }
    }

    protected void addNodes(TreeModus.TreeNode node, int index, int pos, int depth) {
        if (node == null) {
            return;
        }
        SylladexScreen.GuiCard card = new SylladexScreen.GuiCard(node.stack, this, index, 0, 0);
        this.setPosition(card, pos, depth);
        this.cards.add(card);
        this.guiIndexList[(int)((double)pos + Math.pow((double)2.0, (double)((double)depth)) - 1.0)] = card;
        this.addNodes(node.node1, index + (int)Math.pow(2.0, depth), pos * 2, depth + 1);
        this.addNodes(node.node2, index + (int)Math.pow(2.0, depth + 1), pos * 2 + 1, depth + 1);
    }

    protected void setPosition(SylladexScreen.GuiCard guiCard, int pos, int depth) {
        int invertedPow = (int)Math.pow(2.0, this.maxDepth - depth);
        double xOffset = ((double)invertedPow - 1.0) / 2.0;
        guiCard.xPos = this.xOffset + (int)((xOffset += Math.pow(2.0, this.maxDepth - depth) * (double)pos) * 21.0);
        guiCard.yPos = this.yOffset + depth * 46;
    }
}

