/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.computer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.client.gui.computer.ThemedScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;

public final class ButtonListHelper {
    public static final String CLEAR_BUTTON = "minestuck.clear_button";
    private final Map<Button, Runnable> buttonMap = new HashMap<Button, Runnable>();
    private List<ButtonData> buttonsData = List.of();
    private final List<Button> buttons = new ArrayList<Button>(4);
    private Button upButton;
    private Button downButton;
    private int index = 0;

    private void onButtonPressed(Button button) {
        Runnable runnable = this.buttonMap.get(button);
        if (runnable != null) {
            runnable.run();
        }
        this.updateButtons();
    }

    private void onArrowPressed(boolean reverse) {
        this.index = reverse ? --this.index : ++this.index;
        this.updateButtons();
    }

    public void init(ThemedScreen gui) {
        gui.setOffsets();
        this.buttonMap.clear();
        this.buttons.clear();
        for (int i = 0; i < 4; ++i) {
            ExtendedButton button = new ExtendedButton(gui.xOffset + 14, gui.yOffset + 60 + i * 24, 120, 20, (Component)Component.empty(), this::onButtonPressed);
            gui.addRenderableWidget(button);
            this.buttons.add((Button)button);
        }
        this.upButton = (Button)gui.addRenderableWidget(new ArrowButton(this, true, gui));
        this.downButton = (Button)gui.addRenderableWidget(new ArrowButton(this, false, gui));
    }

    public void updateButtons(List<ButtonData> buttonsDataIn) {
        this.buttonsData = buttonsDataIn;
        this.updateButtons();
    }

    private void updateButtons() {
        this.downButton.active = this.buttonsData.size() >= this.index + 4;
        this.upButton.active = this.index > 0;
        for (int i = 0; i < 4; ++i) {
            Button button = this.buttons.get(i);
            if (this.index + i < this.buttonsData.size()) {
                ButtonData buttonData = this.buttonsData.get(this.index + i);
                button.active = true;
                button.setMessage(buttonData.message);
                this.buttonMap.put(button, buttonData.onClick);
                continue;
            }
            button.active = false;
            button.setMessage((Component)Component.empty());
            this.buttonMap.remove(button);
        }
    }

    private class ArrowButton
    extends ExtendedButton {
        boolean reverse;
        ThemedScreen gui;

        ArrowButton(ButtonListHelper buttonListHelper, boolean reverse, ThemedScreen gui) {
            super((gui.width - 176) / 2 + 140, (gui.height - 166) / 2 + (reverse ? 60 : 132), 20, 20, (Component)Component.empty(), b -> buttonListHelper.onArrowPressed(reverse));
            this.reverse = reverse;
            this.gui = gui;
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.blit(this.gui.selectedTheme.data().texturePath(), this.getX(), this.getY(), 158, this.reverse ? 0 : 20, 20, 20);
        }
    }

    public record ButtonData(Component message, Runnable onClick) {
    }
}

