/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.computer;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mraof.minestuck.Minestuck;
import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.client.gui.computer.ProgramGui;
import com.mraof.minestuck.client.gui.computer.ThemedScreen;
import com.mraof.minestuck.computer.ProgramType;
import com.mraof.minestuck.computer.ProgramTypes;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;

@ParametersAreNonnullByDefault
public class ComputerScreen
extends ThemedScreen {
    public static final String TITLE = "minestuck.computer";
    private final List<ComputerIcon> icons;
    @Nullable
    private TypedProgramGui<?> program;

    public ComputerScreen(Minecraft mc, ComputerBlockEntity computer) {
        super(computer, Component.translatable((String)TITLE));
        this.minecraft = mc;
        this.font = this.minecraft.font;
        this.icons = new ArrayList<ComputerIcon>();
        computer.setGuiCallback(this::updateGui);
    }

    @Override
    public void init() {
        this.genIcons();
        super.init();
        if (this.program != null) {
            this.program.gui.onInit(this);
        }
        this.updateGui();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        boolean bsod = this.computer.isBrokenOrOff();
        if (!bsod && this.program != null) {
            this.program.gui.render(guiGraphics, this);
        }
    }

    public void updateGui() {
        if (this.program != null) {
            this.program.updateGui(this);
        }
        boolean shouldShowIcons = this.program == null && !this.computer.isBrokenOrOff();
        this.icons.forEach(icon -> {
            icon.visible = shouldShowIcons;
        });
    }

    protected void setProgram(ProgramType<?> programType) {
        if (this.computer.isBrokenOrOff()) {
            return;
        }
        this.program = new TypedProgramGui(programType);
        this.program.gui.onInit(this);
        this.updateGui();
    }

    protected void exitProgram() {
        this.program = null;
        this.clearWidgets();
        this.icons.forEach(this::addRenderableWidget);
        this.addRenderableWidget(this.powerButton);
        this.updateGui();
    }

    private void genIcons() {
        int xOffset = (this.width - 176) / 2;
        int yOffset = (this.height - 166) / 2;
        this.icons.clear();
        int programCount = 0;
        for (ProgramType<?> programType : this.computer.installedPrograms().sorted(ProgramTypes.DISPLAY_ORDER_SORTER).toList()) {
            this.icons.add(this.addRenderableWidget(new ComputerIcon(this, xOffset + 15 + Math.floorDiv(programCount, 5) * 20, yOffset + 44 + programCount % 5 * 20, programType)));
            ++programCount;
        }
    }

    @Override
    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            if (this.program == null) {
                this.onClose();
            } else {
                this.exitProgram();
            }
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    private static final class TypedProgramGui<D extends ProgramType.Data> {
        private final ProgramType<D> type;
        private final ProgramGui<D> gui;

        TypedProgramGui(ProgramType<D> type) {
            this.type = type;
            this.gui = ProgramGui.Registry.createGuiInstance(type);
        }

        void updateGui(ComputerScreen screen) {
            Optional<D> programData = screen.computer.getProgramData(this.type);
            if (programData.isPresent()) {
                this.gui.onUpdate(screen, (ProgramType.Data)programData.get());
            } else {
                screen.exitProgram();
            }
        }
    }

    private class ComputerIcon
    extends ExtendedButton {
        private final ResourceLocation icon;
        private static final int WIDTH = 16;
        private static final int HEIGHT = 16;

        public ComputerIcon(ComputerScreen computerScreen, int xPos, int yPos, ProgramType<?> programType) {
            super(xPos, yPos, 16, 16, (Component)Component.empty(), button -> computerScreen.setProgram(programType));
            ResourceLocation programKey = Objects.requireNonNullElse(ProgramTypes.REGISTRY.getKey(programType), Minestuck.id("invalid"));
            this.icon = programKey.withPath(name -> "textures/gui/desktop_icon/" + name + ".png");
            this.setTooltip(Tooltip.create((Component)programType.name()));
        }

        public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            if (!this.visible) {
                return;
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            guiGraphics.blit(this.icon, this.getX(), this.getY(), 16, 16, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }
}

