/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.computer;

import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.client.gui.computer.ThemedScreen;
import com.mraof.minestuck.computer.theme.ComputerTheme;
import com.mraof.minestuck.computer.theme.ComputerThemes;
import com.mraof.minestuck.computer.theme.MSComputerThemes;
import com.mraof.minestuck.network.computer.ThemeSelectPacket;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.client.gui.widget.ExtendedButton;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class ComputerThemeScreen
extends ThemedScreen {
    public static final String TITLE = "minestuck.computer_themes";
    public static final String SELECTED_THEME = "minestuck.computer_themes.divide_value";
    public static final String DONE_MESSAGE = "minestuck.computer_themes.done";
    private static final int ENTRIES_ACROSS = 2;
    private static final int ENTRIES_DOWN = 4;
    private static final int ENTRIES_PER_PAGE = 8;
    private static final Comparator<ComputerTheme> THEME_SORTER = Comparator.comparing(theme -> !theme.id().equals((Object)MSComputerThemes.DEFAULT));
    private int page = 0;
    private Button previousButton;
    private Button nextButton;
    private final List<Button> entryButtons = new ArrayList<Button>();
    private final List<ComputerTheme> themes = new ArrayList<ComputerTheme>();

    public ComputerThemeScreen(ComputerBlockEntity computer) {
        super(computer, Component.translatable((String)TITLE));
    }

    @Override
    public void init() {
        super.init();
        this.themes.clear();
        ComputerThemes.instance().allThemes().stream().sorted(THEME_SORTER).forEach(this.themes::add);
        this.previousButton = new ExtendedButton(this.xOffset + 9 + 108, this.yOffset + 38 + 8, 16, 16, (Component)Component.literal((String)"<"), button -> this.prevPage());
        this.nextButton = new ExtendedButton(this.xOffset + 9 + 133, this.yOffset + 38 + 8, 16, 16, (Component)Component.literal((String)">"), button -> this.nextPage());
        this.addRenderableWidget(this.nextButton);
        this.addRenderableWidget(this.previousButton);
        this.recreateThemeButtons();
        this.addRenderableWidget(new ExtendedButton(this.width / 2 - 20, this.yOffset + 38 + 104, 40, 14, (Component)Component.translatable((String)DONE_MESSAGE), button -> this.finish()));
    }

    public void recreateThemeButtons() {
        this.entryButtons.forEach(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.entryButtons.clear();
        for (int i = 0; i < this.themes.size(); ++i) {
            ComputerTheme theme = this.themes.get(i);
            int yPositionOffset = 18 * (i / 2 % 4);
            int xPositionOffset = 76 * (i % 2);
            ExtendedButton entryButton = new ExtendedButton(this.xOffset + 9 + 5 + xPositionOffset, this.yOffset + 38 + 30 + yPositionOffset, 72, 14, (Component)theme.name(), button -> {
                this.selectedTheme = theme;
            });
            this.entryButtons.add((Button)this.addRenderableWidget(entryButton));
        }
        this.updateButtonStates();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, (Component)Component.translatable((String)SELECTED_THEME), this.xOffset + 9 + 8, this.yOffset + 38 + 8, this.selectedTheme.data().textColor(), false);
        guiGraphics.drawString(this.font, (Component)this.selectedTheme.name(), this.xOffset + 9 + 8, this.yOffset + 38 + 18, this.selectedTheme.data().textColor(), false);
    }

    private void prevPage() {
        --this.page;
        this.updateButtonStates();
    }

    private void nextPage() {
        ++this.page;
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        int startElement = this.page * 8;
        this.previousButton.active = 0 < startElement;
        this.nextButton.active = startElement + 8 < this.entryButtons.size();
        for (int i = 0; i < this.entryButtons.size(); ++i) {
            Button button = this.entryButtons.get(i);
            button.visible = startElement <= i && i < startElement + 8;
        }
    }

    private void finish() {
        if (!this.selectedTheme.id().equals((Object)this.computer.getTheme())) {
            PacketDistributor.sendToServer((CustomPacketPayload)ThemeSelectPacket.create(this.computer, this.selectedTheme.id()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        this.onClose();
    }
}

