/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.computer;

import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.client.gui.computer.ButtonListHelper;
import com.mraof.minestuck.client.gui.computer.ProgramGui;
import com.mraof.minestuck.client.gui.computer.ThemedScreen;
import com.mraof.minestuck.computer.ProgramType;
import com.mraof.minestuck.item.components.MSItemComponents;
import com.mraof.minestuck.network.computer.EjectDiskPacket;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

@ParametersAreNonnullByDefault
public class DiskManagerScreen
extends ThemedScreen {
    public static final String TITLE = "minestuck.disk_manager";
    private final ButtonListHelper buttonListHelper = new ButtonListHelper();

    public DiskManagerScreen(ComputerBlockEntity computer) {
        super(computer, Component.translatable((String)TITLE));
    }

    @Override
    public void init() {
        super.init();
        this.buttonListHelper.init(this);
        this.recreateButtons();
    }

    public void recreateButtons() {
        ArrayList<ButtonListHelper.ButtonData> diskButtons = new ArrayList<ButtonListHelper.ButtonData>();
        AtomicInteger i = new AtomicInteger();
        this.computer.getDisks().forEach(disk -> {
            int diskIndex = i.getAndIncrement();
            Holder programTypeHolder = (Holder)disk.getComponents().get(MSItemComponents.PROGRAM_TYPE.get());
            Component diskName = programTypeHolder != null ? ((ProgramType)programTypeHolder.value()).name() : disk.getDisplayName();
            diskButtons.add(new ButtonListHelper.ButtonData((Component)Component.literal((String)"Eject ").append(diskName), () -> this.ejectDisk(diskIndex)));
        });
        this.buttonListHelper.updateButtons(diskButtons);
    }

    @Override
    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        ProgramGui.drawHeaderMessage((Component)Component.translatable((String)TITLE), guiGraphics, this);
    }

    private void ejectDisk(int index) {
        PacketDistributor.sendToServer((CustomPacketPayload)EjectDiskPacket.create(this.computer, index), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.minecraft.setScreen(null);
    }
}

