/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.computer;

import com.mraof.minestuck.client.gui.computer.ThemedScreen;
import com.mraof.minestuck.computer.ProgramType;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;

public interface ProgramGui<D> {
    default public void onInit(ThemedScreen screen) {
    }

    default public void onUpdate(ThemedScreen screen, D data) {
    }

    public void render(GuiGraphics var1, ThemedScreen var2);

    public static void drawHeaderMessage(Component message, GuiGraphics guiGraphics, ThemedScreen gui) {
        guiGraphics.drawString(gui.getMinecraft().font, message, (gui.width - 176) / 2 + 15, (gui.height - 166) / 2 + 45, gui.selectedTheme.data().textColor(), false);
    }

    public static final class Registry {
        private static final HashMap<ProgramType<?>, Supplier<? extends ProgramGui<?>>> programs = new HashMap();

        public static <D extends ProgramType.Data> void register(Supplier<ProgramType<D>> programType, Supplier<? extends ProgramGui<D>> factory) {
            if (programs.containsKey(programType.get())) {
                throw new IllegalArgumentException("Program type " + String.valueOf(programType.get()) + " is already registered!");
            }
            programs.put(programType.get(), factory);
        }

        public static <D extends ProgramType.Data> ProgramGui<D> createGuiInstance(ProgramType<D> programType) {
            return Objects.requireNonNull(programs.get(programType)).get();
        }
    }
}

