/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.computer;

import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.client.gui.ColorSelectorScreen;
import com.mraof.minestuck.client.gui.computer.ButtonListHelper;
import com.mraof.minestuck.client.gui.computer.ProgramGui;
import com.mraof.minestuck.client.gui.computer.ThemedScreen;
import com.mraof.minestuck.computer.SburbClientData;
import com.mraof.minestuck.network.computer.ClearMessagePacket;
import com.mraof.minestuck.network.computer.CloseRemoteSburbConnectionPacket;
import com.mraof.minestuck.network.computer.CloseSburbConnectionPackets;
import com.mraof.minestuck.network.computer.ConnectToSburbServerPacket;
import com.mraof.minestuck.network.computer.ResumeSburbConnectionPackets;
import com.mraof.minestuck.skaianet.client.ReducedConnection;
import com.mraof.minestuck.skaianet.client.SkaiaClient;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public final class SburbClientGui
implements ProgramGui<SburbClientData> {
    public static final String NAME = "minestuck.program.sburb_client";
    public static final String CLOSE_BUTTON = "minestuck.program.close_button";
    public static final String RESUME_BUTTON = "minestuck.program.resume_button";
    public static final String SELECT_COLOR = "minestuck.program.client.select_color_button";
    public static final String CONNECT = "minestuck.program.connect_message";
    public static final String CLIENT_ACTIVE = "minestuck.program.client.client_active_message";
    public static final String SELECT = "minestuck.program.client.select_message";
    public static final String RESUME_CLIENT = "minestuck.program.client.resume_client_message";
    private final ButtonListHelper buttonListHelper = new ButtonListHelper();
    private Component message;

    @Override
    public void onInit(ThemedScreen gui) {
        this.buttonListHelper.init(gui);
    }

    @Override
    public void onUpdate(ThemedScreen gui, SburbClientData data) {
        MutableComponent message;
        ComputerBlockEntity computer = gui.computer;
        ArrayList<ButtonListHelper.ButtonData> list = new ArrayList<ButtonListHelper.ButtonData>();
        Optional<String> eventMessage = data.getEventMessage();
        if (eventMessage.isPresent()) {
            list.add(new ButtonListHelper.ButtonData((Component)Component.translatable((String)"minestuck.clear_button"), () -> SburbClientGui.sendClearMessagePacket(computer)));
        }
        ReducedConnection c = SkaiaClient.getClientConnection(computer.clientSideOwnerId());
        if (data.isConnectedToServer() && c != null) {
            String displayPlayer = c.server().name();
            message = Component.translatable((String)CONNECT, (Object[])new Object[]{displayPlayer});
            list.add(new ButtonListHelper.ButtonData((Component)Component.translatable((String)CLOSE_BUTTON), () -> {
                if (eventMessage.isPresent()) {
                    SburbClientGui.sendClearMessagePacket(computer);
                }
                SburbClientGui.sendCloseConnectionPacket(computer, data);
            }));
        } else if (data.isResuming()) {
            message = Component.translatable((String)RESUME_CLIENT);
            list.add(new ButtonListHelper.ButtonData((Component)Component.translatable((String)CLOSE_BUTTON), () -> {
                if (eventMessage.isPresent()) {
                    SburbClientGui.sendClearMessagePacket(computer);
                }
                SburbClientGui.sendCloseConnectionPacket(computer, data);
            }));
        } else if (!SkaiaClient.isActive(computer.clientSideOwnerId(), true)) {
            message = Component.translatable((String)SELECT);
            if (SkaiaClient.hasPrimaryConnectionAsClient(computer.clientSideOwnerId())) {
                list.add(new ButtonListHelper.ButtonData((Component)Component.translatable((String)RESUME_BUTTON), () -> {
                    if (eventMessage.isPresent()) {
                        SburbClientGui.sendClearMessagePacket(computer);
                    }
                    PacketDistributor.sendToServer((CustomPacketPayload)ResumeSburbConnectionPackets.asClient(computer), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }));
            }
            for (Map.Entry<Integer, String> entry : SkaiaClient.getAvailableServers(computer.clientSideOwnerId()).entrySet()) {
                list.add(new ButtonListHelper.ButtonData((Component)Component.literal((String)entry.getValue()), () -> {
                    if (eventMessage.isPresent()) {
                        SburbClientGui.sendClearMessagePacket(computer);
                    }
                    PacketDistributor.sendToServer((CustomPacketPayload)ConnectToSburbServerPacket.create(computer, (Integer)entry.getKey()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }));
            }
        } else {
            message = Component.translatable((String)CLIENT_ACTIVE);
            list.add(new ButtonListHelper.ButtonData((Component)Component.translatable((String)CLOSE_BUTTON), () -> {
                if (eventMessage.isPresent()) {
                    SburbClientGui.sendClearMessagePacket(computer);
                }
                SburbClientGui.sendCloseConnectionPacket(computer, data);
            }));
        }
        if (SkaiaClient.canSelect(computer.clientSideOwnerId())) {
            list.add(new ButtonListHelper.ButtonData((Component)Component.translatable((String)SELECT_COLOR), () -> {
                if (eventMessage.isPresent()) {
                    SburbClientGui.sendClearMessagePacket(computer);
                }
                Minecraft.getInstance().setScreen((Screen)new ColorSelectorScreen(computer));
            }));
        }
        this.message = eventMessage.map(Component::translatable).orElse((Component)message);
        this.buttonListHelper.updateButtons(list);
    }

    private static void sendClearMessagePacketIfRelevant(ComputerBlockEntity computer, SburbClientData data) {
        if (data.getEventMessage().isPresent()) {
            SburbClientGui.sendClearMessagePacket(computer);
        }
    }

    private static void sendClearMessagePacket(ComputerBlockEntity computer) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ClearMessagePacket(computer.getBlockPos(), 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void sendCloseConnectionPacket(ComputerBlockEntity computer, SburbClientData data) {
        if (!data.isResuming() && !data.isConnectedToServer()) {
            PacketDistributor.sendToServer((CustomPacketPayload)CloseRemoteSburbConnectionPacket.asClient(computer), (CustomPacketPayload[])new CustomPacketPayload[0]);
        } else {
            PacketDistributor.sendToServer((CustomPacketPayload)CloseSburbConnectionPackets.asClient(computer), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @Override
    public void render(GuiGraphics guiGraphics, ThemedScreen gui) {
        ProgramGui.drawHeaderMessage(this.message, guiGraphics, gui);
    }
}

