/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.computer;

import com.mraof.minestuck.MinestuckConfig;
import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.client.gui.computer.ButtonListHelper;
import com.mraof.minestuck.client.gui.computer.ProgramGui;
import com.mraof.minestuck.client.gui.computer.ThemedScreen;
import com.mraof.minestuck.computer.SburbServerData;
import com.mraof.minestuck.network.computer.ClearMessagePacket;
import com.mraof.minestuck.network.computer.CloseSburbConnectionPackets;
import com.mraof.minestuck.network.computer.OpenSburbServerPacket;
import com.mraof.minestuck.network.computer.ResumeSburbConnectionPackets;
import com.mraof.minestuck.network.editmode.ClientEditPackets;
import com.mraof.minestuck.skaianet.client.ReducedConnection;
import com.mraof.minestuck.skaianet.client.SkaiaClient;
import java.util.ArrayList;
import java.util.Optional;
import java.util.OptionalInt;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.neoforged.neoforge.network.PacketDistributor;

public final class SburbServerGui
implements ProgramGui<SburbServerData> {
    public static final String NAME = "minestuck.program.sburb_server";
    public static final String CLOSE_BUTTON = "minestuck.program.close_button";
    public static final String EDIT_BUTTON = "minestuck.program.server.edit_button";
    public static final String GIVE_BUTTON = "minestuck.program.server.give_button";
    public static final String OPEN_BUTTON = "minestuck.program.server.open_button";
    public static final String RESUME_BUTTON = "minestuck.program.resume_button";
    public static final String CONNECT = "minestuck.program.connect_message";
    public static final String OFFLINE = "minestuck.program.server.offline_message";
    public static final String SERVER_ACTIVE = "minestuck.program.server.server_active_message";
    public static final String RESUME_SERVER = "minestuck.program.server.resume_server_message";
    private final ButtonListHelper buttonListHelper = new ButtonListHelper();
    private Component message;

    @Override
    public void onInit(ThemedScreen gui) {
        this.buttonListHelper.init(gui);
    }

    @Override
    public void onUpdate(ThemedScreen gui, SburbServerData data) {
        MutableComponent message;
        String displayPlayer;
        ReducedConnection connection;
        ComputerBlockEntity computer = gui.computer;
        ArrayList<ButtonListHelper.ButtonData> list = new ArrayList<ButtonListHelper.ButtonData>();
        Optional<String> eventMessage = data.getEventMessage();
        OptionalInt clientId = data.getConnectedClientId();
        ReducedConnection reducedConnection = connection = clientId.isPresent() ? SkaiaClient.getClientConnection(clientId.getAsInt()) : null;
        if (connection != null && connection.server().id() != computer.clientSideOwnerId()) {
            connection = null;
        }
        if (eventMessage.isPresent()) {
            list.add(new ButtonListHelper.ButtonData((Component)Component.translatable((String)"minestuck.clear_button"), () -> SburbServerGui.sendClearMessagePacket(computer)));
        }
        String string = displayPlayer = connection == null ? "UNDEFINED" : connection.client().name();
        if (connection != null) {
            message = Component.translatable((String)CONNECT, (Object[])new Object[]{displayPlayer});
            list.add(new ButtonListHelper.ButtonData((Component)Component.translatable((String)CLOSE_BUTTON), () -> {
                if (eventMessage.isPresent()) {
                    SburbServerGui.sendClearMessagePacket(computer);
                }
                SburbServerGui.sendCloseConnectionPacket(computer);
            }));
            list.add(new ButtonListHelper.ButtonData((Component)Component.translatable((String)((Boolean)MinestuckConfig.SERVER.giveItems.get() != false ? GIVE_BUTTON : EDIT_BUTTON)), () -> {
                if (eventMessage.isPresent()) {
                    SburbServerGui.sendClearMessagePacket(computer);
                }
                SburbServerGui.sendActivateEditmodePacket(computer, clientId.orElseThrow());
            }));
        } else if (data.isOpen()) {
            message = Component.translatable((String)RESUME_SERVER);
            list.add(new ButtonListHelper.ButtonData((Component)Component.translatable((String)CLOSE_BUTTON), () -> {
                if (eventMessage.isPresent()) {
                    SburbServerGui.sendClearMessagePacket(computer);
                }
                SburbServerGui.sendCloseConnectionPacket(computer);
            }));
        } else if (SkaiaClient.isActive(computer.clientSideOwnerId(), false)) {
            message = Component.translatable((String)SERVER_ACTIVE);
        } else {
            message = Component.translatable((String)OFFLINE);
            if (((Boolean)MinestuckConfig.SERVER.allowSecondaryConnections.get()).booleanValue() || !SkaiaClient.hasPrimaryConnectionAsServer(computer.clientSideOwnerId())) {
                list.add(new ButtonListHelper.ButtonData((Component)Component.translatable((String)OPEN_BUTTON), () -> {
                    if (eventMessage.isPresent()) {
                        SburbServerGui.sendClearMessagePacket(computer);
                    }
                    PacketDistributor.sendToServer((CustomPacketPayload)OpenSburbServerPacket.create(computer), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }));
            }
            if (SkaiaClient.hasPrimaryConnectionAsServer(computer.clientSideOwnerId())) {
                list.add(new ButtonListHelper.ButtonData((Component)Component.translatable((String)RESUME_BUTTON), () -> {
                    if (eventMessage.isPresent()) {
                        SburbServerGui.sendClearMessagePacket(computer);
                    }
                    PacketDistributor.sendToServer((CustomPacketPayload)ResumeSburbConnectionPackets.asServer(computer), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }));
            }
        }
        this.message = eventMessage.map(Component::translatable).orElse((Component)message);
        this.buttonListHelper.updateButtons(list);
    }

    private static void sendClearMessagePacket(ComputerBlockEntity computer) {
        PacketDistributor.sendToServer((CustomPacketPayload)new ClearMessagePacket(computer.getBlockPos(), 1), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void sendCloseConnectionPacket(ComputerBlockEntity computer) {
        PacketDistributor.sendToServer((CustomPacketPayload)CloseSburbConnectionPackets.asServer(computer), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static void sendActivateEditmodePacket(ComputerBlockEntity computer, int targetClientId) {
        ClientEditPackets.Activate packet = new ClientEditPackets.Activate(computer.clientSideOwnerId(), targetClientId);
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void render(GuiGraphics guiGraphics, ThemedScreen gui) {
        ProgramGui.drawHeaderMessage(this.message, guiGraphics, gui);
    }
}

