/*
 * Decompiled with CFR 0.152.
 */
package com.mraof.minestuck.client.gui.computer;

import com.mraof.minestuck.blockentity.ComputerBlockEntity;
import com.mraof.minestuck.client.gui.computer.ButtonListHelper;
import com.mraof.minestuck.client.gui.computer.ComputerThemeScreen;
import com.mraof.minestuck.client.gui.computer.DiskManagerScreen;
import com.mraof.minestuck.client.gui.computer.ProgramGui;
import com.mraof.minestuck.client.gui.computer.ThemedScreen;
import com.mraof.minestuck.computer.ProgramType;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public final class SettingsAppGui
implements ProgramGui<ProgramType.EmptyData> {
    public static final String NAME = "minestuck.program.settings";
    public static final String THEME = "minestuck.program.settings.theme";
    public static final String DISK_MANAGER = "minestuck.program.settings.disk_manager";
    public static final String TITLE = "minestuck.program.settings.title";
    private final ButtonListHelper buttonListHelper = new ButtonListHelper();

    @Override
    public void onInit(ThemedScreen gui) {
        this.buttonListHelper.init(gui);
    }

    @Override
    public void onUpdate(ThemedScreen gui, ProgramType.EmptyData data) {
        this.buttonListHelper.updateButtons(List.of(new ButtonListHelper.ButtonData((Component)Component.translatable((String)THEME), () -> SettingsAppGui.openThemeScreen(gui.computer)), new ButtonListHelper.ButtonData((Component)Component.translatable((String)DISK_MANAGER), () -> this.openDiskManagerScreen(gui.computer))));
    }

    private static void openThemeScreen(ComputerBlockEntity computer) {
        Minecraft.getInstance().setScreen((Screen)new ComputerThemeScreen(computer));
    }

    private void openDiskManagerScreen(ComputerBlockEntity computer) {
        Minecraft.getInstance().setScreen((Screen)new DiskManagerScreen(computer));
    }

    @Override
    public void render(GuiGraphics guiGraphics, ThemedScreen gui) {
        ProgramGui.drawHeaderMessage((Component)Component.translatable((String)TITLE), guiGraphics, gui);
    }
}

